/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.WeakHashSet;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.UML;

public final class ValueRestriction
implements Serializable {
    private static final long serialVersionUID = 888961503200860655L;
    static final ValueRestriction PENDING = new ValueRestriction(null, null);
    private static final WeakHashSet<ValueRestriction> POOL = WeakHashSet.newInstance(ValueRestriction.class);
    public final Obligation obligation;
    public final NumberRange<?> range;

    private ValueRestriction(Obligation obligation, NumberRange<?> numberRange) {
        this.obligation = obligation;
        this.range = numberRange;
    }

    static ValueRestriction create(Obligation obligation, NumberRange<?> numberRange) {
        if (numberRange == null && !Obligation.MANDATORY.equals((Object)obligation) && !Obligation.FORBIDDEN.equals((Object)obligation)) {
            return null;
        }
        return POOL.unique(new ValueRestriction(obligation, numberRange));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ValueRestriction create(Class<?> clazz, Method method, Method method2) {
        Obligation obligation = null;
        NumberRange numberRange = null;
        UML uML = method.getAnnotation(UML.class);
        while (true) {
            ValueRange valueRange;
            if (uML != null) {
                obligation = uML.obligation();
            }
            if ((valueRange = method.getAnnotation(ValueRange.class)) != null) {
                void var7_9;
                Class<Number> clazz2 = Number.class;
                if (!Number.class.isAssignableFrom(clazz)) throw new ClassCastException(Errors.format(66, clazz, var7_9));
                Class<Comparable> clazz3 = Comparable.class;
                if (!Comparable.class.isAssignableFrom(clazz)) throw new ClassCastException(Errors.format(66, clazz, var7_9));
                numberRange = new NumberRange(clazz, valueRange);
            }
            if (method == method2) return ValueRestriction.create(obligation, numberRange);
            method = method2;
        }
    }

    final ValueRestriction violation(Object object) {
        Obligation obligation = this.obligation;
        NumberRange<?> numberRange = this.range;
        boolean bl = false;
        if (!(object == null ? Obligation.MANDATORY : Obligation.FORBIDDEN).equals((Object)obligation)) {
            obligation = null;
            bl = true;
        }
        if (object == null || numberRange == null || object instanceof Number && numberRange.contains((Number)object)) {
            numberRange = null;
            bl = true;
        }
        return bl ? ValueRestriction.create(obligation, numberRange) : this;
    }

    public boolean equals(Object object) {
        if (object instanceof ValueRestriction) {
            ValueRestriction valueRestriction = (ValueRestriction)object;
            return Utilities.equals((Object)this.obligation, (Object)valueRestriction.obligation) && Utilities.equals(this.range, valueRestriction.range);
        }
        return false;
    }

    public int hashCode() {
        int n = -112666129;
        if (this.obligation != null) {
            n ^= this.obligation.hashCode();
        }
        if (this.range != null) {
            n ^= this.range.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Restriction[");
        String string = "";
        if (this.obligation != null) {
            stringBuilder.append(this.obligation.name());
            string = ", ";
        }
        if (this.range != null) {
            stringBuilder.append(string).append("range=").append(this.range);
        }
        return stringBuilder.append(']').toString();
    }
}

