/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.acquisition;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Priority;
import org.opengis.metadata.acquisition.RequestedDate;
import org.opengis.metadata.acquisition.Requirement;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;

@XmlType(propOrder={"citation", "identifier", "requestors", "recipients", "priority", "requestedDate", "expiryDate", "satisfiedPlans"})
@XmlRootElement(name="MI_Requirement")
public class DefaultRequirement
extends MetadataEntity
implements Requirement {
    private static final long serialVersionUID = 7305276418007196949L;
    private Citation citation;
    private Identifier identifier;
    private Collection<ResponsibleParty> requestors;
    private Collection<ResponsibleParty> recipients;
    private Priority priority;
    private RequestedDate requestedDate;
    private long expiryDate = Long.MIN_VALUE;
    private Collection<Plan> satisfiedPlans;

    public DefaultRequirement() {
    }

    public DefaultRequirement(Requirement requirement) {
        super(requirement);
    }

    @Override
    @XmlElement(name="citation")
    public synchronized Citation getCitation() {
        return this.citation;
    }

    public synchronized void setCitation(Citation citation) {
        this.checkWritePermission();
        this.citation = citation;
    }

    @Override
    @XmlElement(name="identifier")
    public synchronized Identifier getIdentifier() {
        return this.identifier;
    }

    public synchronized void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        this.identifier = identifier;
    }

    @XmlElement(name="requestor")
    public synchronized Collection<ResponsibleParty> getRequestors() {
        this.requestors = this.nonNullCollection(this.requestors, ResponsibleParty.class);
        return this.requestors;
    }

    public synchronized void setRequestors(Collection<? extends ResponsibleParty> collection) {
        this.requestors = this.copyCollection(collection, this.requestors, ResponsibleParty.class);
    }

    @XmlElement(name="recipient")
    public synchronized Collection<ResponsibleParty> getRecipients() {
        this.recipients = this.nonNullCollection(this.recipients, ResponsibleParty.class);
        return this.recipients;
    }

    public synchronized void setRecipients(Collection<? extends ResponsibleParty> collection) {
        this.recipients = this.copyCollection(collection, this.recipients, ResponsibleParty.class);
    }

    @Override
    @XmlElement(name="priority")
    public synchronized Priority getPriority() {
        return this.priority;
    }

    public synchronized void setPriority(Priority priority) {
        this.checkWritePermission();
        this.priority = priority;
    }

    @Override
    @XmlElement(name="requestedDate")
    public synchronized RequestedDate getRequestedDate() {
        return this.requestedDate;
    }

    public synchronized void setRequestedDate(RequestedDate requestedDate) {
        this.checkWritePermission();
        this.requestedDate = requestedDate;
    }

    @Override
    @XmlElement(name="expiryDate")
    public synchronized Date getExpiryDate() {
        long l = this.expiryDate;
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public synchronized void setExpiryDate(Date date) {
        this.checkWritePermission();
        this.expiryDate = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @XmlElement(name="satisfiedPlan")
    public synchronized Collection<Plan> getSatisfiedPlans() {
        this.satisfiedPlans = this.nonNullCollection(this.satisfiedPlans, Plan.class);
        return DefaultRequirement.xmlOptional(this.satisfiedPlans);
    }

    public synchronized void setSatisfiedPlans(Collection<? extends Plan> collection) {
        this.satisfiedPlans = this.copyCollection(collection, this.satisfiedPlans, Plan.class);
    }

    @Deprecated
    public Collection<Plan> getSatisifedPlans() {
        return this.getSatisfiedPlans();
    }

    @Deprecated
    public void setSatisifedPlans(Collection<? extends Plan> collection) {
        this.setSatisfiedPlans(collection);
    }
}

