/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.util.Collection;
import org.geotoolkit.metadata.iso.citation.CitationConstant;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultOnLineResource;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

public final class Citations {
    public static final Citation OGC;
    public static final Citation OPEN_GIS;
    public static final Citation ESRI;
    public static final Citation ORACLE;
    public static final Citation POSTGIS;
    public static final Citation GEOTOOLKIT;
    public static final Citation GEOTOOLS;
    public static final Citation WMS;
    public static final Citation GEOTIFF;
    public static final Citation JAI;
    public static final Citation EPSG;
    public static final Citation AUTO;
    public static final Citation AUTO2;
    public static final Citation CRS;
    public static final Citation URN_OGC;
    public static final Citation HTTP_OGC;
    private static final Citation[] AUTHORITIES;

    private Citations() {
    }

    public static Citation fromName(String string) {
        for (int i = 0; i < AUTHORITIES.length; ++i) {
            Citation citation = AUTHORITIES[i];
            if (!Citations.titleMatches(citation, string)) continue;
            return citation;
        }
        return new DefaultCitation(string);
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        return org.geotoolkit.internal.Citations.titleMatches(citation, citation2);
    }

    public static boolean titleMatches(Citation citation, String string) {
        return org.geotoolkit.internal.Citations.titleMatches(citation, string);
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        return org.geotoolkit.internal.Citations.identifierMatches(citation, citation2);
    }

    public static boolean identifierMatches(Citation citation, String string) {
        return org.geotoolkit.internal.Citations.identifierMatches(citation, string);
    }

    public static String getIdentifier(Citation citation) {
        return org.geotoolkit.internal.Citations.getIdentifier(citation);
    }

    static {
        CitationConstant citationConstant = new CitationConstant(DefaultResponsibleParty.OGC, "OGC");
        citationConstant.addAuthority("OGC", false);
        citationConstant.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        citationConstant.freeze();
        OGC = citationConstant;
        citationConstant = new CitationConstant(DefaultResponsibleParty.OPEN_GIS, "OPEN_GIS");
        citationConstant.addAuthority("OpenGIS", false);
        citationConstant.getAlternateTitles().addAll(OGC.getAlternateTitles());
        citationConstant.getIdentifiers().addAll(OGC.getIdentifiers());
        citationConstant.getPresentationForms().addAll(OGC.getPresentationForms());
        citationConstant.freeze();
        OPEN_GIS = citationConstant;
        citationConstant = new CitationConstant(DefaultResponsibleParty.ESRI, "ESRI");
        citationConstant.addAuthority("ESRI", false);
        citationConstant.freeze();
        ESRI = citationConstant;
        citationConstant = new CitationConstant(DefaultResponsibleParty.ORACLE, "ORACLE");
        citationConstant.addAuthority("Oracle", false);
        citationConstant.freeze();
        ORACLE = citationConstant;
        citationConstant = new CitationConstant(DefaultResponsibleParty.POSTGIS, "POSTGIS");
        citationConstant.addAuthority("PostGIS", false);
        citationConstant.freeze();
        POSTGIS = citationConstant;
        citationConstant = new CitationConstant(DefaultResponsibleParty.GEOTOOLKIT, "GEOTOOLKIT");
        citationConstant.addAuthority("Geotoolkit.org", false);
        citationConstant.freeze();
        GEOTOOLKIT = citationConstant;
        citationConstant = new CitationConstant(DefaultResponsibleParty.GEOTOOLS, "GEOTOOLS");
        citationConstant.addAuthority("GeoTools", false);
        citationConstant.freeze();
        GEOTOOLS = citationConstant;
        citationConstant = new CitationConstant((CharSequence)"Web Map Service", "WMS");
        citationConstant.addAuthority("WMS", false);
        Collection<Object> collection = citationConstant.getAlternateTitles();
        collection.add(new SimpleInternationalString("WMS 1.3.0"));
        collection.add(new SimpleInternationalString("OGC 04-024"));
        collection.add(new SimpleInternationalString("ISO 19128"));
        Collection<ResponsibleParty> collection2 = citationConstant.getCitedResponsibleParties();
        collection2.add(DefaultResponsibleParty.OGC);
        collection2.add(DefaultResponsibleParty.OGC(Role.PUBLISHER, DefaultOnLineResource.WMS));
        citationConstant.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        citationConstant.freeze();
        WMS = citationConstant;
        citationConstant = new CitationConstant(DefaultResponsibleParty.GEOTIFF, "GEOTIFF");
        citationConstant.addAuthority("GeoTIFF", false);
        citationConstant.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        citationConstant.freeze();
        GEOTIFF = citationConstant;
        citationConstant = new CitationConstant((CharSequence)"Java Advanced Imaging", "JAI");
        citationConstant.addAuthority("JAI", true);
        citationConstant.getCitedResponsibleParties().add(DefaultResponsibleParty.SUN_MICROSYSTEMS);
        citationConstant.freeze();
        JAI = citationConstant;
        citationConstant = new CitationConstant(DefaultResponsibleParty.EPSG, "EPSG");
        citationConstant.addAuthority("EPSG", true);
        citationConstant.getPresentationForms().add(PresentationForm.TABLE_DIGITAL);
        citationConstant.freeze();
        EPSG = citationConstant;
        citationConstant = new CitationConstant((CharSequence)"Automatic Projections", "AUTO");
        citationConstant.addAuthority("AUTO", false);
        collection = citationConstant.getCitedResponsibleParties();
        collection.add((InternationalString)((Object)DefaultResponsibleParty.OGC));
        collection.add(DefaultResponsibleParty.OGC(Role.PUBLISHER, OnLineFunction.DOWNLOAD, "http://www.opengis.org/docs/01-068r3.pdf"));
        citationConstant.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        citationConstant.freeze();
        AUTO = citationConstant;
        citationConstant = new CitationConstant((CharSequence)"Automatic Projections", "AUTO2");
        citationConstant.addAuthority("AUTO2", false);
        collection = citationConstant.getCitedResponsibleParties();
        collection.add(DefaultResponsibleParty.OGC);
        collection.add(DefaultResponsibleParty.OGC(Role.PUBLISHER, DefaultOnLineResource.WMS));
        citationConstant.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        citationConstant.freeze();
        AUTO2 = citationConstant;
        citationConstant = new CitationConstant((CharSequence)"Web Map Service CRS", "CRS");
        citationConstant.addAuthority("CRS", false);
        citationConstant.addAuthority("OGC", false);
        citationConstant.getCitedResponsibleParties().addAll(AUTO2.getCitedResponsibleParties());
        citationConstant.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        citationConstant.freeze();
        CRS = citationConstant;
        citationConstant = new CitationConstant((CharSequence)"URN in OGC namespace", "URN_OGC");
        citationConstant.addAuthority("urn:ogc:def", false);
        citationConstant.addAuthority("urn:x-ogc:def", false);
        citationConstant.getCitedResponsibleParties().add(DefaultResponsibleParty.OGC);
        citationConstant.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        citationConstant.freeze();
        URN_OGC = citationConstant;
        citationConstant = new CitationConstant((CharSequence)"URL in OGC namespace", "HTTP_OGC");
        citationConstant.addAuthority("http://www.opengis.net", false);
        citationConstant.getCitedResponsibleParties().add(DefaultResponsibleParty.OGC);
        citationConstant.getPresentationForms().add(PresentationForm.DOCUMENT_DIGITAL);
        citationConstant.freeze();
        HTTP_OGC = citationConstant;
        AUTHORITIES = new Citation[]{OGC, OPEN_GIS, ESRI, ORACLE, GEOTOOLKIT, WMS, GEOTIFF, JAI, EPSG, AUTO, AUTO2, CRS};
    }
}

