/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

@XmlType(propOrder={"title", "alternateTitles", "dates", "edition", "editionDate", "identifiers", "citedResponsibleParties", "presentationForms", "series", "otherCitationDetails", "collectiveTitle", "ISBN", "ISSN"})
@XmlRootElement(name="CI_Citation")
public class DefaultCitation
extends MetadataEntity
implements Citation {
    private static final long serialVersionUID = 490722440306018256L;
    private InternationalString title;
    private Collection<InternationalString> alternateTitles;
    private Collection<CitationDate> dates;
    private InternationalString edition;
    private long editionDate = Long.MIN_VALUE;
    private Collection<Identifier> identifiers;
    private Collection<ResponsibleParty> citedResponsibleParties;
    private Collection<PresentationForm> presentationForms;
    private Series series;
    private InternationalString otherCitationDetails;
    private InternationalString collectiveTitle;
    private String ISBN;
    private String ISSN;

    public DefaultCitation() {
    }

    public DefaultCitation(Citation citation) {
        super(citation);
    }

    public DefaultCitation(CharSequence charSequence) {
        InternationalString internationalString = charSequence instanceof InternationalString ? (InternationalString)charSequence : new SimpleInternationalString(((Object)charSequence).toString());
        this.setTitle(internationalString);
    }

    public DefaultCitation(ResponsibleParty responsibleParty) {
        String string;
        InternationalString internationalString = responsibleParty.getOrganisationName();
        if (internationalString == null && (internationalString = responsibleParty.getPositionName()) == null && (string = responsibleParty.getIndividualName()) != null) {
            internationalString = new SimpleInternationalString(string);
        }
        this.setTitle(internationalString);
        this.getCitedResponsibleParties().add(responsibleParty);
    }

    @Override
    @XmlElement(name="title", required=true)
    public synchronized InternationalString getTitle() {
        return this.title;
    }

    public synchronized void setTitle(InternationalString internationalString) {
        this.checkWritePermission();
        this.title = internationalString;
    }

    @XmlElement(name="alternateTitle")
    public synchronized Collection<InternationalString> getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return DefaultCitation.xmlOptional(this.alternateTitles);
    }

    public synchronized void setAlternateTitles(Collection<? extends InternationalString> collection) {
        this.alternateTitles = this.copyCollection(collection, this.alternateTitles, InternationalString.class);
    }

    @XmlElement(name="date", required=true)
    public synchronized Collection<CitationDate> getDates() {
        this.dates = this.nonNullCollection(this.dates, CitationDate.class);
        return this.dates;
    }

    public synchronized void setDates(Collection<? extends CitationDate> collection) {
        this.dates = this.copyCollection(collection, this.dates, CitationDate.class);
    }

    @Override
    @XmlElement(name="edition")
    public synchronized InternationalString getEdition() {
        return this.edition;
    }

    public synchronized void setEdition(InternationalString internationalString) {
        this.checkWritePermission();
        this.edition = internationalString;
    }

    @Override
    @XmlElement(name="editionDate")
    public synchronized Date getEditionDate() {
        return this.editionDate != Long.MIN_VALUE ? new Date(this.editionDate) : null;
    }

    public synchronized void setEditionDate(Date date) {
        this.checkWritePermission();
        this.editionDate = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @XmlElement(name="identifier")
    public synchronized Collection<Identifier> getIdentifiers() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        return DefaultCitation.xmlOptional(this.identifiers);
    }

    public synchronized void setIdentifiers(Collection<? extends Identifier> collection) {
        this.identifiers = this.copyCollection(collection, this.identifiers, Identifier.class);
    }

    @XmlElement(name="citedResponsibleParty")
    public synchronized Collection<ResponsibleParty> getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return DefaultCitation.xmlOptional(this.citedResponsibleParties);
    }

    public synchronized void setCitedResponsibleParties(Collection<? extends ResponsibleParty> collection) {
        this.citedResponsibleParties = this.copyCollection(collection, this.citedResponsibleParties, ResponsibleParty.class);
    }

    @Override
    @XmlElement(name="presentationForm")
    public synchronized Collection<PresentationForm> getPresentationForms() {
        this.presentationForms = this.nonNullCollection(this.presentationForms, PresentationForm.class);
        return DefaultCitation.xmlOptional(this.presentationForms);
    }

    public synchronized void setPresentationForms(Collection<? extends PresentationForm> collection) {
        this.presentationForms = this.copyCollection(collection, this.presentationForms, PresentationForm.class);
    }

    @Override
    @XmlElement(name="series")
    public synchronized Series getSeries() {
        return this.series;
    }

    public synchronized void setSeries(Series series) {
        this.checkWritePermission();
        this.series = series;
    }

    @Override
    @XmlElement(name="otherCitationDetails")
    public synchronized InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public synchronized void setOtherCitationDetails(InternationalString internationalString) {
        this.checkWritePermission();
        this.otherCitationDetails = internationalString;
    }

    @Override
    @XmlElement(name="collectiveTitle", required=true)
    public synchronized InternationalString getCollectiveTitle() {
        return this.collectiveTitle;
    }

    public synchronized void setCollectiveTitle(InternationalString internationalString) {
        this.checkWritePermission();
        this.collectiveTitle = internationalString;
    }

    @Override
    @XmlElement(name="ISBN")
    public synchronized String getISBN() {
        return this.ISBN;
    }

    public synchronized void setISBN(String string) {
        this.checkWritePermission();
        this.ISBN = string;
    }

    @Override
    @XmlElement(name="ISSN")
    public synchronized String getISSN() {
        return this.ISSN;
    }

    public synchronized void setISSN(String string) {
        this.checkWritePermission();
        this.ISSN = string;
    }
}

