/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.util.InternationalString;

@XmlType(propOrder={"linkage", "protocol", "applicationProfile", "name", "description", "function"})
@XmlRootElement(name="CI_OnlineResource")
public class DefaultOnLineResource
extends MetadataEntity
implements OnLineResource {
    private static final long serialVersionUID = 5412370008274334799L;
    public static final OnLineResource OGC;
    public static final OnLineResource OPEN_GIS;
    public static final OnLineResource EPSG;
    public static final OnLineResource GEOTIFF;
    public static final OnLineResource ESRI;
    public static final OnLineResource ORACLE;
    public static final OnLineResource POSTGIS;
    public static final OnLineResource SUN_MICROSYSTEMS;
    public static final OnLineResource GEOTOOLKIT;
    public static final OnLineResource GEOTOOLS;
    public static final OnLineResource WMS;
    private String applicationProfile;
    private String name;
    private InternationalString description;
    private OnLineFunction function;
    private URI linkage;
    private String protocol;

    public DefaultOnLineResource() {
    }

    public DefaultOnLineResource(OnLineResource onLineResource) {
        super(onLineResource);
    }

    private DefaultOnLineResource(String string) {
        try {
            this.setLinkage(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        this.setFunction(OnLineFunction.INFORMATION);
    }

    public DefaultOnLineResource(URI uRI) {
        this.setLinkage(uRI);
    }

    @Override
    @XmlElement(name="applicationProfile")
    public synchronized String getApplicationProfile() {
        return this.applicationProfile;
    }

    public synchronized void setApplicationProfile(String string) {
        this.checkWritePermission();
        this.applicationProfile = string;
    }

    @Override
    @XmlElement(name="name")
    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String string) {
        this.checkWritePermission();
        this.name = string;
    }

    @Override
    @XmlElement(name="description")
    public synchronized InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @Override
    @XmlElement(name="function")
    public synchronized OnLineFunction getFunction() {
        return this.function;
    }

    public synchronized void setFunction(OnLineFunction onLineFunction) {
        this.checkWritePermission();
        this.function = onLineFunction;
    }

    @Override
    @XmlElement(name="linkage", required=true)
    public synchronized URI getLinkage() {
        return this.linkage;
    }

    public synchronized void setLinkage(URI uRI) {
        this.checkWritePermission();
        this.linkage = uRI;
    }

    @Override
    @XmlElement(name="protocol")
    public synchronized String getProtocol() {
        return this.protocol;
    }

    public synchronized void setProtocol(String string) {
        this.checkWritePermission();
        this.protocol = string;
    }

    static {
        DefaultOnLineResource defaultOnLineResource = new DefaultOnLineResource("http://www.opengeospatial.org/");
        OGC = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://www.opengis.org");
        OPEN_GIS = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://www.epsg.org");
        EPSG = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://www.remotesensing.org/geotiff");
        GEOTIFF = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://www.esri.com");
        ESRI = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://www.oracle.com");
        ORACLE = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://postgis.refractions.net");
        POSTGIS = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://java.sun.com");
        SUN_MICROSYSTEMS = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://www.geotoolkit.org");
        GEOTOOLKIT = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://www.geotools.org");
        GEOTOOLS = defaultOnLineResource;
        defaultOnLineResource.freeze();
        defaultOnLineResource = new DefaultOnLineResource("http://portal.opengis.org/files/?artifact_id=5316");
        WMS = defaultOnLineResource;
        defaultOnLineResource.setFunction(OnLineFunction.DOWNLOAD);
        defaultOnLineResource.freeze();
    }
}

