/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.citation.DefaultContact;
import org.geotoolkit.metadata.iso.citation.DefaultOnLineResource;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

@XmlType(propOrder={"individualName", "organisationName", "positionName", "contactInfo", "role"})
@XmlRootElement(name="CI_ResponsibleParty")
public class DefaultResponsibleParty
extends MetadataEntity
implements ResponsibleParty {
    private static final long serialVersionUID = -2477962229031486552L;
    static final InternationalString OGC_NAME = new SimpleInternationalString("Open Geospatial Consortium");
    public static ResponsibleParty OGC;
    public static ResponsibleParty OPEN_GIS;
    public static ResponsibleParty EPSG;
    public static ResponsibleParty GEOTIFF;
    public static ResponsibleParty ESRI;
    public static ResponsibleParty ORACLE;
    public static ResponsibleParty POSTGIS;
    public static ResponsibleParty SUN_MICROSYSTEMS;
    public static ResponsibleParty GEOTOOLKIT;
    public static ResponsibleParty GEOTOOLS;
    private String individualName;
    private InternationalString organisationName;
    private InternationalString positionName;
    private Contact contactInfo;
    private Role role;

    public static ResponsibleParty OGC(Role role, OnLineResource onLineResource) {
        DefaultContact defaultContact = new DefaultContact(onLineResource);
        defaultContact.freeze();
        DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(role);
        defaultResponsibleParty.setOrganisationName(OGC_NAME);
        defaultResponsibleParty.setContactInfo(defaultContact);
        defaultResponsibleParty.freeze();
        return defaultResponsibleParty;
    }

    public static ResponsibleParty OGC(Role role, OnLineFunction onLineFunction, URI uRI) {
        DefaultOnLineResource defaultOnLineResource = new DefaultOnLineResource(uRI);
        defaultOnLineResource.setFunction(onLineFunction);
        defaultOnLineResource.freeze();
        return DefaultResponsibleParty.OGC(role, defaultOnLineResource);
    }

    static ResponsibleParty OGC(Role role, OnLineFunction onLineFunction, String string) {
        try {
            return DefaultResponsibleParty.OGC(role, onLineFunction, new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.unexpectedException(LOGGER, ResponsibleParty.class, "OGC", uRISyntaxException);
            return OGC;
        }
    }

    public DefaultResponsibleParty() {
    }

    public DefaultResponsibleParty(ResponsibleParty responsibleParty) {
        super(responsibleParty);
    }

    public DefaultResponsibleParty(Role role) {
        this.setRole(role);
    }

    @Override
    @XmlElement(name="individualName")
    public synchronized String getIndividualName() {
        return this.individualName;
    }

    public synchronized void setIndividualName(String string) {
        this.checkWritePermission();
        this.individualName = string;
    }

    @Override
    @XmlElement(name="organisationName")
    public synchronized InternationalString getOrganisationName() {
        return this.organisationName;
    }

    public synchronized void setOrganisationName(InternationalString internationalString) {
        this.checkWritePermission();
        this.organisationName = internationalString;
    }

    @Override
    @XmlElement(name="positionName")
    public synchronized InternationalString getPositionName() {
        return this.positionName;
    }

    public synchronized void setPositionName(InternationalString internationalString) {
        this.checkWritePermission();
        this.positionName = internationalString;
    }

    @Override
    @XmlElement(name="contactInfo")
    public synchronized Contact getContactInfo() {
        return this.contactInfo;
    }

    public synchronized void setContactInfo(Contact contact) {
        this.checkWritePermission();
        this.contactInfo = contact;
    }

    @Override
    @XmlElement(name="role", required=true)
    public synchronized Role getRole() {
        return this.role;
    }

    public synchronized void setRole(Role role) {
        this.checkWritePermission();
        this.role = role;
    }

    static {
        DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(Role.RESOURCE_PROVIDER);
        defaultResponsibleParty.setOrganisationName(OGC_NAME);
        defaultResponsibleParty.setContactInfo(DefaultContact.OGC);
        defaultResponsibleParty.freeze();
        OGC = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.RESOURCE_PROVIDER);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("OpenGIS consortium"));
        defaultResponsibleParty.setContactInfo(DefaultContact.OPEN_GIS);
        defaultResponsibleParty.freeze();
        OPEN_GIS = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("European Petroleum Survey Group"));
        defaultResponsibleParty.setContactInfo(DefaultContact.EPSG);
        defaultResponsibleParty.freeze();
        EPSG = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("GeoTIFF"));
        defaultResponsibleParty.setContactInfo(DefaultContact.GEOTIFF);
        defaultResponsibleParty.freeze();
        GEOTIFF = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.OWNER);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("ESRI"));
        defaultResponsibleParty.setContactInfo(DefaultContact.ESRI);
        defaultResponsibleParty.freeze();
        ESRI = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.OWNER);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("Oracle"));
        defaultResponsibleParty.setContactInfo(DefaultContact.ORACLE);
        defaultResponsibleParty.freeze();
        ORACLE = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("PostGIS"));
        defaultResponsibleParty.setContactInfo(DefaultContact.POSTGIS);
        defaultResponsibleParty.freeze();
        POSTGIS = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("Sun Microsystems"));
        defaultResponsibleParty.setContactInfo(DefaultContact.SUN_MICROSYSTEMS);
        defaultResponsibleParty.freeze();
        SUN_MICROSYSTEMS = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("Geotoolkit.org"));
        defaultResponsibleParty.setContactInfo(DefaultContact.GEOTOOLKIT);
        defaultResponsibleParty.freeze();
        GEOTOOLKIT = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName(new SimpleInternationalString("GeoTools"));
        defaultResponsibleParty.setContactInfo(DefaultContact.GEOTOOLS);
        defaultResponsibleParty.freeze();
        GEOTOOLS = defaultResponsibleParty;
    }
}

