/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.distribution;

import java.util.Collection;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.distribution.Medium;
import org.opengis.metadata.distribution.MediumFormat;
import org.opengis.metadata.distribution.MediumName;
import org.opengis.util.InternationalString;

@XmlType(propOrder={"name", "densities", "volumes", "mediumFormats", "mediumNote"})
@XmlRootElement(name="MD_Medium")
public class DefaultMedium
extends MetadataEntity
implements Medium {
    private static final long serialVersionUID = -2838122926367921673L;
    private MediumName name;
    private Collection<Double> densities;
    private Unit<?> densityUnits;
    private Integer volumes;
    private Collection<MediumFormat> mediumFormats;
    private InternationalString mediumNote;

    public DefaultMedium() {
    }

    public DefaultMedium(Medium medium) {
        super(medium);
    }

    @Override
    @XmlElement(name="name")
    public synchronized MediumName getName() {
        return this.name;
    }

    public synchronized void setName(MediumName mediumName) {
        this.checkWritePermission();
        this.name = mediumName;
    }

    @Override
    public synchronized Unit<?> getDensityUnits() {
        return this.densityUnits;
    }

    public synchronized void setDensityUnits(Unit<?> unit) {
        this.checkWritePermission();
        this.densityUnits = unit;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="volumes")
    public synchronized Integer getVolumes() {
        return this.volumes;
    }

    public synchronized void setVolumes(Integer n) {
        this.checkWritePermission();
        this.volumes = n;
    }

    @Override
    @XmlElement(name="mediumFormat")
    public synchronized Collection<MediumFormat> getMediumFormats() {
        this.mediumFormats = this.nonNullCollection(this.mediumFormats, MediumFormat.class);
        return DefaultMedium.xmlOptional(this.mediumFormats);
    }

    public synchronized void setMediumFormats(Collection<? extends MediumFormat> collection) {
        this.mediumFormats = this.copyCollection(collection, this.mediumFormats, MediumFormat.class);
    }

    @Override
    @XmlElement(name="mediumNote")
    public synchronized InternationalString getMediumNote() {
        return this.mediumNote;
    }

    public synchronized void setMediumNote(InternationalString internationalString) {
        this.checkWritePermission();
        this.mediumNote = internationalString;
    }

    @Override
    @XmlElement(name="density")
    public synchronized Collection<Double> getDensities() {
        this.densities = this.nonNullCollection(this.densities, Double.class);
        return DefaultMedium.xmlOptional(this.densities);
    }

    public synchronized void setDensities(Collection<? extends Double> collection) {
        this.densities = this.copyCollection(collection, this.densities, Double.class);
    }
}

