/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.extent;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.metadata.ModifiableMetadata;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.util.InternationalString;

@XmlType(propOrder={"description", "geographicElements", "temporalElements", "verticalElements"})
@XmlRootElement(name="EX_Extent")
public class DefaultExtent
extends MetadataEntity
implements Extent {
    private static final long serialVersionUID = 7812213837337326257L;
    public static final Extent WORLD;
    private InternationalString description;
    private Collection<GeographicExtent> geographicElements;
    private Collection<TemporalExtent> temporalElements;
    private Collection<VerticalExtent> verticalElements;

    public DefaultExtent() {
    }

    public DefaultExtent(Extent extent) {
        super(extent);
    }

    @Override
    @XmlElement(name="description")
    public synchronized InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="geographicElement")
    public synchronized Collection<GeographicExtent> getGeographicElements() {
        this.geographicElements = this.nonNullCollection(this.geographicElements, GeographicExtent.class);
        return DefaultExtent.xmlOptional(this.geographicElements);
    }

    public synchronized void setGeographicElements(Collection<? extends GeographicExtent> collection) {
        this.geographicElements = this.copyCollection(collection, this.geographicElements, GeographicExtent.class);
    }

    @XmlElement(name="temporalElement")
    public synchronized Collection<TemporalExtent> getTemporalElements() {
        this.temporalElements = this.nonNullCollection(this.temporalElements, TemporalExtent.class);
        return DefaultExtent.xmlOptional(this.temporalElements);
    }

    public synchronized void setTemporalElements(Collection<? extends TemporalExtent> collection) {
        this.temporalElements = this.copyCollection(collection, this.temporalElements, TemporalExtent.class);
    }

    @XmlElement(name="verticalElement")
    public synchronized Collection<VerticalExtent> getVerticalElements() {
        this.verticalElements = this.nonNullCollection(this.verticalElements, VerticalExtent.class);
        return DefaultExtent.xmlOptional(this.verticalElements);
    }

    public synchronized void setVerticalElements(Collection<? extends VerticalExtent> collection) {
        this.verticalElements = this.copyCollection(collection, this.verticalElements, VerticalExtent.class);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        Object object = null;
        if (extent != null) {
            ModifiableMetadata modifiableMetadata = null;
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) {
                    if (!(geographicExtent instanceof BoundingPolygon)) continue;
                    continue;
                }
                GeographicBoundingBox geographicBoundingBox = (GeographicBoundingBox)geographicExtent;
                if (object == null) {
                    Boolean bl = geographicBoundingBox.getInclusion();
                    DefaultExtent.ensureNonNull("inclusion", bl);
                    if (!bl.booleanValue()) continue;
                    object = geographicBoundingBox;
                    continue;
                }
                if (modifiableMetadata == null) {
                    modifiableMetadata = new DefaultGeographicBoundingBox((GeographicBoundingBox)object);
                    object = modifiableMetadata;
                }
                ((DefaultGeographicBoundingBox)modifiableMetadata).add(geographicBoundingBox);
            }
            if (modifiableMetadata != null) {
                modifiableMetadata.freeze();
            }
        }
        return object;
    }

    static {
        DefaultExtent defaultExtent = new DefaultExtent();
        defaultExtent.getGeographicElements().add(DefaultGeographicBoundingBox.WORLD);
        defaultExtent.freeze();
        WORLD = defaultExtent;
    }
}

