/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.extent;

import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.metadata.iso.extent.AbstractGeographicExtent;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@XmlType(name="EX_GeographicBoundingBox", propOrder={"westBoundLongitude", "eastBoundLongitude", "southBoundLatitude", "northBoundLatitude"})
@XmlRootElement(name="EX_GeographicBoundingBox")
public class DefaultGeographicBoundingBox
extends AbstractGeographicExtent
implements GeographicBoundingBox {
    private static final long serialVersionUID = -3278089380004172514L;
    private static Method fromEnvelope;
    private static Method fromRectangle;
    private static Method toString;
    public static final GeographicBoundingBox WORLD;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public DefaultGeographicBoundingBox() {
    }

    public DefaultGeographicBoundingBox(GeographicBoundingBox geographicBoundingBox) {
        this.setBounds(geographicBoundingBox);
    }

    public DefaultGeographicBoundingBox(Envelope envelope) throws TransformException {
        super(true);
        if (fromEnvelope == null) {
            fromEnvelope = DefaultGeographicBoundingBox.getMethod("copy", new Class[]{Envelope.class, DefaultGeographicBoundingBox.class});
        }
        try {
            DefaultGeographicBoundingBox.invoke(fromEnvelope, new Object[]{envelope, this});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof TransformException) {
                throw (TransformException)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
    }

    public DefaultGeographicBoundingBox(Rectangle2D rectangle2D, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        super(true);
        if (fromRectangle == null) {
            fromRectangle = DefaultGeographicBoundingBox.getMethod("copy", new Class[]{Rectangle2D.class, CoordinateReferenceSystem.class, DefaultGeographicBoundingBox.class});
        }
        try {
            DefaultGeographicBoundingBox.invoke(fromRectangle, new Object[]{rectangle2D, coordinateReferenceSystem, this});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof TransformException) {
                throw (TransformException)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
    }

    public DefaultGeographicBoundingBox(Rectangle2D rectangle2D) {
        this(rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY());
    }

    public DefaultGeographicBoundingBox(double d, double d2, double d3, double d4) {
        super(true);
        this.setBounds(d, d2, d3, d4);
    }

    @Override
    @ValueRange(minimum=-180.0, maximum=180.0)
    @XmlElement(name="westBoundLongitude", required=true)
    public synchronized double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public synchronized void setWestBoundLongitude(double d) {
        this.checkWritePermission();
        this.westBoundLongitude = d;
    }

    @Override
    @ValueRange(minimum=-180.0, maximum=180.0)
    @XmlElement(name="eastBoundLongitude", required=true)
    public synchronized double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public synchronized void setEastBoundLongitude(double d) {
        this.checkWritePermission();
        this.eastBoundLongitude = d;
    }

    @Override
    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="southBoundLatitude", required=true)
    public synchronized double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public synchronized void setSouthBoundLatitude(double d) {
        this.checkWritePermission();
        this.southBoundLatitude = d;
    }

    @Override
    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="northBoundLatitude", required=true)
    public synchronized double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public synchronized void setNorthBoundLatitude(double d) {
        this.checkWritePermission();
        this.northBoundLatitude = d;
    }

    public synchronized void setBounds(double d, double d2, double d3, double d4) {
        this.checkWritePermission();
        this.westBoundLongitude = d;
        this.eastBoundLongitude = d2;
        this.southBoundLatitude = d3;
        this.northBoundLatitude = d4;
    }

    public void setBounds(GeographicBoundingBox geographicBoundingBox) {
        DefaultGeographicBoundingBox.ensureNonNull("box", geographicBoundingBox);
        this.setInclusion(geographicBoundingBox.getInclusion());
        this.setBounds(geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getNorthBoundLatitude());
    }

    public synchronized void add(GeographicBoundingBox geographicBoundingBox) {
        this.checkWritePermission();
        double d = geographicBoundingBox.getWestBoundLongitude();
        double d2 = geographicBoundingBox.getEastBoundLongitude();
        double d3 = geographicBoundingBox.getSouthBoundLatitude();
        double d4 = geographicBoundingBox.getNorthBoundLatitude();
        Boolean bl = this.getInclusion();
        DefaultGeographicBoundingBox.ensureNonNull("inclusion", bl);
        Boolean bl2 = geographicBoundingBox.getInclusion();
        DefaultGeographicBoundingBox.ensureNonNull("inclusion", bl2);
        if (bl.booleanValue() == bl2.booleanValue()) {
            if (d < this.westBoundLongitude) {
                this.westBoundLongitude = d;
            }
            if (d2 > this.eastBoundLongitude) {
                this.eastBoundLongitude = d2;
            }
            if (d3 < this.southBoundLatitude) {
                this.southBoundLatitude = d3;
            }
            if (d4 > this.northBoundLatitude) {
                this.northBoundLatitude = d4;
            }
        } else {
            if (d3 <= this.southBoundLatitude && d4 >= this.northBoundLatitude) {
                if (d > this.westBoundLongitude) {
                    this.westBoundLongitude = d;
                }
                if (d2 < this.eastBoundLongitude) {
                    this.eastBoundLongitude = d2;
                }
            }
            if (d <= this.westBoundLongitude && d2 >= this.eastBoundLongitude) {
                if (d3 > this.southBoundLatitude) {
                    this.southBoundLatitude = d3;
                }
                if (d4 < this.northBoundLatitude) {
                    this.northBoundLatitude = d4;
                }
            }
        }
    }

    public synchronized void intersect(GeographicBoundingBox geographicBoundingBox) {
        this.checkWritePermission();
        Boolean bl = this.getInclusion();
        DefaultGeographicBoundingBox.ensureNonNull("inclusion", bl);
        Boolean bl2 = geographicBoundingBox.getInclusion();
        DefaultGeographicBoundingBox.ensureNonNull("inclusion", bl2);
        if (bl.booleanValue() != bl2.booleanValue()) {
            throw new IllegalArgumentException(Errors.format(62, "box"));
        }
        double d = geographicBoundingBox.getWestBoundLongitude();
        double d2 = geographicBoundingBox.getEastBoundLongitude();
        double d3 = geographicBoundingBox.getSouthBoundLatitude();
        double d4 = geographicBoundingBox.getNorthBoundLatitude();
        if (d > this.westBoundLongitude) {
            this.westBoundLongitude = d;
        }
        if (d2 < this.eastBoundLongitude) {
            this.eastBoundLongitude = d2;
        }
        if (d3 > this.southBoundLatitude) {
            this.southBoundLatitude = d3;
        }
        if (d4 < this.northBoundLatitude) {
            this.northBoundLatitude = d4;
        }
        if (this.westBoundLongitude > this.eastBoundLongitude) {
            this.westBoundLongitude = this.eastBoundLongitude = 0.5 * (this.westBoundLongitude + this.eastBoundLongitude);
        }
        if (this.southBoundLatitude > this.northBoundLatitude) {
            this.southBoundLatitude = this.northBoundLatitude = 0.5 * (this.southBoundLatitude + this.northBoundLatitude);
        }
    }

    public synchronized boolean isEmpty() {
        return !(this.eastBoundLongitude > this.westBoundLongitude) || !(this.northBoundLatitude > this.southBoundLatitude);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(DefaultGeographicBoundingBox.class)) {
            DefaultGeographicBoundingBox defaultGeographicBoundingBox = (DefaultGeographicBoundingBox)object;
            return Utilities.equals(this.getInclusion(), defaultGeographicBoundingBox.getInclusion()) && Utilities.equals(this.southBoundLatitude, defaultGeographicBoundingBox.southBoundLatitude) && Utilities.equals(this.northBoundLatitude, defaultGeographicBoundingBox.northBoundLatitude) && Utilities.equals(this.eastBoundLongitude, defaultGeographicBoundingBox.eastBoundLongitude) && Utilities.equals(this.westBoundLongitude, defaultGeographicBoundingBox.westBoundLongitude);
        }
        return super.equals(object);
    }

    @Override
    public synchronized int hashCode() {
        if (!this.getClass().equals(DefaultGeographicBoundingBox.class)) {
            return super.hashCode();
        }
        Boolean bl = this.getInclusion();
        int n = bl != null ? bl.hashCode() : 0;
        n += DefaultGeographicBoundingBox.hashCode(this.southBoundLatitude);
        n += DefaultGeographicBoundingBox.hashCode(this.northBoundLatitude);
        n += DefaultGeographicBoundingBox.hashCode(this.eastBoundLongitude);
        return n += DefaultGeographicBoundingBox.hashCode(this.westBoundLongitude);
    }

    private static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)l ^ (int)(l >>> 32);
    }

    @Override
    public synchronized String toString() {
        return DefaultGeographicBoundingBox.toString(this, "DD\u00b0MM'SS.s\"", null);
    }

    public static String toString(GeographicBoundingBox geographicBoundingBox, String string, Locale locale) {
        if (toString == null) {
            toString = DefaultGeographicBoundingBox.getMethod("toString", new Class[]{GeographicBoundingBox.class, String.class, Locale.class});
        }
        try {
            return String.valueOf(DefaultGeographicBoundingBox.invoke(toString, new Object[]{geographicBoundingBox, string, locale}));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UndeclaredThrowableException(invocationTargetException.getTargetException());
        }
    }

    private static Method getMethod(String string, Class<?>[] classArray) {
        try {
            return Class.forName("org.geotoolkit.internal.referencing.BoundingBoxes").getMethod(string, classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException(Errors.format(105, "referencing"), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    private static Object invoke(Method method, Object[] objectArray) throws InvocationTargetException {
        try {
            return method.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw invocationTargetException;
        }
    }

    static {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(-180.0, 180.0, -90.0, 90.0);
        defaultGeographicBoundingBox.freeze();
        WORLD = defaultGeographicBoundingBox;
    }
}

