/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.maintenance;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

@XmlType(propOrder={"maintenanceAndUpdateFrequency", "dateOfNextUpdate", "updateScopes", "updateScopeDescriptions", "maintenanceNotes", "contacts"})
@XmlRootElement(name="MD_MaintenanceInformation")
public class DefaultMaintenanceInformation
extends MetadataEntity
implements MaintenanceInformation {
    private static final long serialVersionUID = 8523463344581266776L;
    private MaintenanceFrequency maintenanceAndUpdateFrequency;
    private long dateOfNextUpdate = Long.MIN_VALUE;
    private PeriodDuration userDefinedMaintenanceFrequency;
    private Collection<ScopeCode> updateScopes;
    private Collection<ScopeDescription> updateScopeDescriptions;
    private Collection<InternationalString> maintenanceNotes;
    private Collection<ResponsibleParty> contacts;

    public DefaultMaintenanceInformation() {
    }

    public DefaultMaintenanceInformation(MaintenanceInformation maintenanceInformation) {
        super(maintenanceInformation);
    }

    public DefaultMaintenanceInformation(MaintenanceFrequency maintenanceFrequency) {
        this.setMaintenanceAndUpdateFrequency(maintenanceFrequency);
    }

    @Override
    @XmlElement(name="maintenanceAndUpdateFrequency", required=true)
    public synchronized MaintenanceFrequency getMaintenanceAndUpdateFrequency() {
        return this.maintenanceAndUpdateFrequency;
    }

    public synchronized void setMaintenanceAndUpdateFrequency(MaintenanceFrequency maintenanceFrequency) {
        this.checkWritePermission();
        this.maintenanceAndUpdateFrequency = maintenanceFrequency;
    }

    @Override
    @XmlElement(name="dateOfNextUpdate")
    public synchronized Date getDateOfNextUpdate() {
        long l = this.dateOfNextUpdate;
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public synchronized void setDateOfNextUpdate(Date date) {
        this.checkWritePermission();
        this.dateOfNextUpdate = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @Override
    public synchronized PeriodDuration getUserDefinedMaintenanceFrequency() {
        return this.userDefinedMaintenanceFrequency;
    }

    public synchronized void setUserDefinedMaintenanceFrequency(PeriodDuration periodDuration) {
        this.checkWritePermission();
        this.userDefinedMaintenanceFrequency = periodDuration;
    }

    @Override
    @XmlElement(name="updateScope")
    public synchronized Collection<ScopeCode> getUpdateScopes() {
        this.updateScopes = this.nonNullCollection(this.updateScopes, ScopeCode.class);
        return DefaultMaintenanceInformation.xmlOptional(this.updateScopes);
    }

    public synchronized void setUpdateScopes(Collection<? extends ScopeCode> collection) {
        this.updateScopes = this.copyCollection(collection, this.updateScopes, ScopeCode.class);
    }

    @XmlElement(name="updateScopeDescription")
    public synchronized Collection<ScopeDescription> getUpdateScopeDescriptions() {
        this.updateScopeDescriptions = this.nonNullCollection(this.updateScopeDescriptions, ScopeDescription.class);
        return DefaultMaintenanceInformation.xmlOptional(this.updateScopeDescriptions);
    }

    public synchronized void setUpdateScopeDescriptions(Collection<? extends ScopeDescription> collection) {
        this.updateScopeDescriptions = this.copyCollection(collection, this.updateScopeDescriptions, ScopeDescription.class);
    }

    @XmlElement(name="maintenanceNote")
    public synchronized Collection<InternationalString> getMaintenanceNotes() {
        this.maintenanceNotes = this.nonNullCollection(this.maintenanceNotes, InternationalString.class);
        return DefaultMaintenanceInformation.xmlOptional(this.maintenanceNotes);
    }

    public synchronized void setMaintenanceNotes(Collection<? extends InternationalString> collection) {
        this.maintenanceNotes = this.copyCollection(collection, this.maintenanceNotes, InternationalString.class);
    }

    @XmlElement(name="contact")
    public synchronized Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return DefaultMaintenanceInformation.xmlOptional(this.contacts);
    }

    public synchronized void setContacts(Collection<? extends ResponsibleParty> collection) {
        this.contacts = this.copyCollection(collection, this.contacts, ResponsibleParty.class);
    }
}

