/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.opengis.geometry.primitive.Point;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Georectified", propOrder={"checkPointAvailable", "checkPointDescription", "pointInPixel", "transformationDimensionDescription", "transformationDimensionMapping", "checkPoints"})
@XmlRootElement(name="MD_Georectified")
public class DefaultGeorectified
extends DefaultGridSpatialRepresentation
implements Georectified {
    private static final long serialVersionUID = -4467097498958444505L;
    private boolean checkPointAvailable;
    private InternationalString checkPointDescription;
    private List<Point> cornerPoints;
    private Point centerPoint;
    private PixelOrientation pointInPixel;
    private InternationalString transformationDimensionDescription;
    private Collection<InternationalString> transformationDimensionMapping;
    private Collection<GCP> checkPoints;

    public DefaultGeorectified() {
    }

    public DefaultGeorectified(Georectified georectified) {
        super(georectified);
    }

    public DefaultGeorectified(int n, List<? extends Dimension> list, CellGeometry cellGeometry, boolean bl, boolean bl2, List<? extends Point> list2, PixelOrientation pixelOrientation) {
        super(n, list, cellGeometry, bl);
        this.setCheckPointAvailable(bl2);
        this.setCornerPoints(list2);
        this.setPointInPixel(pixelOrientation);
    }

    @Override
    @XmlElement(name="checkPointAvailability", required=true)
    public synchronized boolean isCheckPointAvailable() {
        return this.checkPointAvailable;
    }

    public synchronized void setCheckPointAvailable(boolean bl) {
        this.checkWritePermission();
        this.checkPointAvailable = bl;
    }

    @Override
    @XmlElement(name="checkPointDescription")
    public synchronized InternationalString getCheckPointDescription() {
        return this.checkPointDescription;
    }

    public synchronized void setCheckPointDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.checkPointDescription = internationalString;
    }

    public synchronized List<Point> getCornerPoints() {
        this.cornerPoints = this.nonNullList(this.cornerPoints, Point.class);
        return this.cornerPoints;
    }

    public synchronized void setCornerPoints(List<? extends Point> list) {
        this.cornerPoints = this.copyList(list, this.cornerPoints, Point.class);
    }

    @Override
    public synchronized Point getCenterPoint() {
        return this.centerPoint;
    }

    public synchronized void setCenterPoint(Point point) {
        this.checkWritePermission();
        this.centerPoint = point;
    }

    @Override
    @XmlElement(name="pointInPixel", required=true)
    public synchronized PixelOrientation getPointInPixel() {
        return this.pointInPixel;
    }

    public synchronized void setPointInPixel(PixelOrientation pixelOrientation) {
        this.checkWritePermission();
        this.pointInPixel = pixelOrientation;
    }

    @Override
    @XmlElement(name="transformationDimensionDescription")
    public synchronized InternationalString getTransformationDimensionDescription() {
        return this.transformationDimensionDescription;
    }

    public synchronized void setTransformationDimensionDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.transformationDimensionDescription = internationalString;
    }

    @XmlElement(name="transformationDimensionMapping")
    public synchronized Collection<InternationalString> getTransformationDimensionMapping() {
        this.transformationDimensionMapping = this.nonNullCollection(this.transformationDimensionMapping, InternationalString.class);
        return DefaultGeorectified.xmlOptional(this.transformationDimensionMapping);
    }

    public synchronized void setTransformationDimensionMapping(Collection<? extends InternationalString> collection) {
        this.transformationDimensionMapping = this.copyCollection(collection, this.transformationDimensionMapping, InternationalString.class);
    }

    @XmlElement(name="checkPoint")
    public synchronized Collection<GCP> getCheckPoints() {
        this.checkPoints = this.nonNullCollection(this.checkPoints, GCP.class);
        return DefaultGeorectified.xmlOptional(this.checkPoints);
    }

    public synchronized void setCheckPoints(Collection<? extends GCP> collection) {
        this.checkPoints = this.copyCollection(collection, this.checkPoints, GCP.class);
    }
}

