/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.spatial;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.metadata.iso.spatial.AbstractSpatialRepresentation;
import org.geotoolkit.metadata.iso.spatial.DefaultGeorectified;
import org.geotoolkit.metadata.iso.spatial.DefaultGeoreferenceable;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.GridSpatialRepresentation;

@XmlType(name="MD_GridSpatialRepresentation", propOrder={"numberOfDimensions", "axisDimensionProperties", "cellGeometry", "transformationParameterAvailable"})
@XmlSeeAlso(value={DefaultGeorectified.class, DefaultGeoreferenceable.class})
@XmlRootElement(name="MD_GridSpatialRepresentation")
public class DefaultGridSpatialRepresentation
extends AbstractSpatialRepresentation
implements GridSpatialRepresentation {
    private static final long serialVersionUID = -8400572307442433979L;
    private Integer numberOfDimensions;
    private List<Dimension> axisDimensionProperties;
    private CellGeometry cellGeometry;
    private boolean transformationParameterAvailable;

    public DefaultGridSpatialRepresentation() {
    }

    public DefaultGridSpatialRepresentation(GridSpatialRepresentation gridSpatialRepresentation) {
        super(gridSpatialRepresentation);
    }

    public DefaultGridSpatialRepresentation(int n, List<? extends Dimension> list, CellGeometry cellGeometry, boolean bl) {
        this.setNumberOfDimensions(n);
        this.setAxisDimensionProperties(list);
        this.setCellGeometry(cellGeometry);
        this.setTransformationParameterAvailable(bl);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="numberOfDimensions", required=true)
    public synchronized Integer getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    public synchronized void setNumberOfDimensions(Integer n) {
        this.checkWritePermission();
        this.numberOfDimensions = n;
    }

    @XmlElement(name="axisDimensionProperties", required=true)
    public synchronized List<Dimension> getAxisDimensionProperties() {
        this.axisDimensionProperties = this.nonNullList(this.axisDimensionProperties, Dimension.class);
        return this.axisDimensionProperties;
    }

    public synchronized void setAxisDimensionProperties(List<? extends Dimension> list) {
        this.checkWritePermission();
        this.axisDimensionProperties = (List)this.copyCollection(list, this.axisDimensionProperties, Dimension.class);
    }

    @Deprecated
    public List<Dimension> getAxisDimensionsProperties() {
        return this.getAxisDimensionProperties();
    }

    @Deprecated
    public void setAxisDimensionsProperties(List<? extends Dimension> list) {
        this.setAxisDimensionProperties(list);
    }

    @Override
    @XmlElement(name="cellGeometry", required=true)
    public synchronized CellGeometry getCellGeometry() {
        return this.cellGeometry;
    }

    public synchronized void setCellGeometry(CellGeometry cellGeometry) {
        this.checkWritePermission();
        this.cellGeometry = cellGeometry;
    }

    @Override
    @XmlElement(name="transformationParameterAvailability", required=true)
    public synchronized boolean isTransformationParameterAvailable() {
        return this.transformationParameterAvailable;
    }

    public synchronized void setTransformationParameterAvailable(boolean bl) {
        this.checkWritePermission();
        this.transformationParameterAvailable = bl;
    }
}

