/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.naming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.naming.AbstractName;
import org.geotoolkit.naming.DefaultLocalName;
import org.geotoolkit.naming.DefaultNameSpace;
import org.geotoolkit.naming.DefaultScopedName;
import org.geotoolkit.naming.DefaultTypeName;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.DefaultInternationalString;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

public class DefaultNameFactory
extends Factory
implements NameFactory {
    @Override
    public InternationalString createInternationalString(Map<Locale, String> map) {
        AbstractName.ensureNonNull("strings", map);
        switch (map.size()) {
            case 0: {
                throw new IllegalArgumentException(Errors.format(50));
            }
            case 1: {
                return new SimpleInternationalString(map.values().iterator().next());
            }
        }
        return new DefaultInternationalString(map);
    }

    private static String getString(Map<String, ?> map, String string) {
        Object obj;
        if (map != null && (obj = map.get(string)) != null) {
            return obj.toString();
        }
        return null;
    }

    @Override
    public NameSpace createNameSpace(GenericName genericName, Map<String, ?> map) {
        boolean bl;
        String string;
        AbstractName.ensureNonNull("name", genericName);
        String string2 = DefaultNameFactory.getString(map, "separator");
        if (string2 == null) {
            string2 = ":";
        }
        if ((string = DefaultNameFactory.getString(map, "separator.head")) == null) {
            string = string2;
        }
        boolean bl2 = bl = string2.length() == 0;
        if (bl || string.length() == 0) {
            throw new IllegalArgumentException(Errors.format(62, bl ? "separator" : "separator.head"));
        }
        return DefaultNameSpace.forName(genericName, string, string2);
    }

    public NameSpace createNameSpace(GenericName genericName) {
        return this.createNameSpace(genericName, null);
    }

    @Override
    public TypeName createTypeName(NameSpace nameSpace, CharSequence charSequence) throws IllegalArgumentException {
        return new DefaultTypeName(nameSpace, charSequence);
    }

    @Override
    public LocalName createLocalName(NameSpace nameSpace, CharSequence charSequence) throws IllegalArgumentException {
        if (nameSpace instanceof DefaultNameSpace) {
            return ((DefaultNameSpace)nameSpace).local(charSequence, null);
        }
        return new DefaultLocalName(nameSpace, charSequence);
    }

    @Override
    public GenericName createGenericName(NameSpace nameSpace, CharSequence[] charSequenceArray) throws IllegalArgumentException {
        AbstractName.ensureNonNull("parsedNames", charSequenceArray);
        switch (charSequenceArray.length) {
            default: {
                return new DefaultScopedName(nameSpace, Arrays.asList(charSequenceArray));
            }
            case 1: {
                return this.createLocalName(nameSpace, charSequenceArray[0]);
            }
            case 0: 
        }
        throw new IllegalArgumentException(Errors.format(49));
    }

    @Override
    public GenericName parseGenericName(NameSpace nameSpace, CharSequence charSequence) {
        int n;
        String string = nameSpace instanceof DefaultNameSpace ? ((DefaultNameSpace)nameSpace).separator : ":";
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        String string2 = ((Object)charSequence).toString();
        while ((n = string2.indexOf(string, n3)) >= 0) {
            arrayList.add(string2.substring(n3, n));
            n3 = n + n2;
        }
        arrayList.add(string2.substring(n3));
        if (arrayList.size() == 1) {
            return this.createLocalName(nameSpace, charSequence);
        }
        return this.createGenericName(nameSpace, arrayList.toArray(new String[arrayList.size()]));
    }

    private GenericName createFromObject(Object object) {
        AbstractName.ensureNonNull("value", object);
        if (object instanceof GenericName) {
            return (GenericName)object;
        }
        if (object instanceof Identifier) {
            return this.parseGenericName(null, ((Identifier)object).getCode());
        }
        if (object instanceof CharSequence) {
            return this.parseGenericName(null, (CharSequence)object);
        }
        return null;
    }

    public GenericName[] toArray(Object object) throws ClassCastException {
        block7: {
            Object[] objectArray;
            GenericName genericName;
            block9: {
                block8: {
                    genericName = this.createFromObject(object);
                    if (genericName != null) {
                        return new GenericName[]{genericName};
                    }
                    if (!(object instanceof Collection)) break block8;
                    objectArray = ((Collection)object).toArray();
                    break block9;
                }
                if (!(object instanceof Object[])) break block7;
                objectArray = (Object[])object;
            }
            if (objectArray instanceof GenericName[]) {
                return (GenericName[])objectArray;
            }
            GenericName[] genericNameArray = new GenericName[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                genericName = this.createFromObject(object);
                if (genericName != null) {
                    genericNameArray[i] = genericName;
                    continue;
                }
                break block7;
            }
            return genericNameArray;
        }
        throw new ClassCastException(Errors.format(198, object.getClass()));
    }
}

