/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Set;
import javax.measure.unit.Unit;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Units;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public abstract class AbstractParameter
extends FormattableObject
implements GeneralParameterValue,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8458179223988766398L;
    final GeneralParameterDescriptor descriptor;

    protected AbstractParameter(GeneralParameterDescriptor generalParameterDescriptor) {
        this.descriptor = generalParameterDescriptor;
        AbstractParameter.ensureNonNull("descriptor", generalParameterDescriptor);
    }

    @Override
    public GeneralParameterDescriptor getDescriptor() {
        return this.descriptor;
    }

    static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    static void ensureNonNull(String string, Object[] objectArray, int n) throws NullArgumentException {
        if (objectArray[n] == null) {
            throw new NullArgumentException(Errors.format(152, string + '[' + n + ']'));
        }
    }

    static <T> void ensureValidClass(Class<?> clazz, Object object) throws IllegalArgumentException {
        Class<?> clazz2;
        if (object != null && !clazz.isAssignableFrom(clazz2 = object.getClass())) {
            throw new IllegalArgumentException(Errors.format(66, clazz2, clazz));
        }
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> parameterDescriptor, Object object) throws InvalidParameterValueException {
        String string;
        if (object == null) {
            return null;
        }
        Class<T> clazz = parameterDescriptor.getValueClass();
        if (!clazz.isInstance(object)) {
            string = Errors.format(77, Classes.getClass(object));
        } else {
            Comparable<Object> comparable = parameterDescriptor.getMinimumValue();
            Comparable<Object> comparable2 = parameterDescriptor.getMaximumValue();
            if (comparable != null && comparable.compareTo(object) > 0 || comparable2 != null && comparable2.compareTo(object) < 0) {
                string = Errors.format(215, object, comparable, comparable2);
            } else {
                Set<T> set = parameterDescriptor.getValidValues();
                if (set != null && !set.contains(object)) {
                    string = Errors.format(63, AbstractParameter.getName(parameterDescriptor), object);
                } else {
                    return clazz.cast(object);
                }
            }
        }
        throw new InvalidParameterValueException(string, AbstractParameter.getName(parameterDescriptor), object);
    }

    static IllegalStateException unitlessParameter(GeneralParameterDescriptor generalParameterDescriptor) {
        return new IllegalStateException(Errors.format(189, AbstractParameter.getName(generalParameterDescriptor)));
    }

    static String getName(GeneralParameterDescriptor generalParameterDescriptor) {
        return generalParameterDescriptor.getName().getCode();
    }

    static int getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 121;
        }
        if (Units.isAngular(unit)) {
            return 115;
        }
        if (Units.isTemporal(unit)) {
            return 125;
        }
        if (Units.isScale(unit)) {
            return 124;
        }
        return 81;
    }

    @Override
    public AbstractParameter clone() {
        try {
            return (AbstractParameter)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            AbstractParameter abstractParameter = (AbstractParameter)object;
            return Utilities.equals(this.descriptor, abstractParameter.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ 0xDC7086BE;
    }

    @Override
    public final String toString() {
        TableWriter tableWriter = new TableWriter(null, 1);
        tableWriter.setMultiLinesCells(true);
        try {
            this.write(tableWriter);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return tableWriter.toString();
    }

    protected void write(TableWriter tableWriter) throws IOException {
        tableWriter.write(AbstractParameter.getName(this.descriptor));
        tableWriter.nextColumn();
        if (this instanceof ParameterValue) {
            tableWriter.write(61);
            tableWriter.nextColumn();
            AbstractParameter.append(tableWriter, ((ParameterValue)((Object)this)).getValue());
        } else if (this instanceof ParameterValueGroup) {
            tableWriter.write(58);
            tableWriter.nextColumn();
            TableWriter tableWriter2 = null;
            for (GeneralParameterValue generalParameterValue : ((ParameterValueGroup)((Object)this)).values()) {
                if (generalParameterValue instanceof AbstractParameter) {
                    if (tableWriter2 == null) {
                        tableWriter2 = new TableWriter((Writer)tableWriter, 1);
                    }
                    ((AbstractParameter)generalParameterValue).write(tableWriter2);
                    continue;
                }
                if (tableWriter2 != null) {
                    tableWriter2.flush();
                    tableWriter2 = null;
                }
                tableWriter.write(generalParameterValue.toString());
                tableWriter.write(10);
            }
            if (tableWriter2 != null) {
                tableWriter2.flush();
            }
        }
        tableWriter.nextLine();
    }

    private static void append(Writer writer, Object object) throws IOException {
        if (object == null) {
            writer.write("null");
        } else if (object.getClass().isArray()) {
            writer.write(123);
            int n = Array.getLength(object);
            int n2 = Math.min(5, n);
            for (int i = 0; i < n2; ++i) {
                if (i != 0) {
                    writer.write(", ");
                }
                AbstractParameter.append(writer, Array.get(object, i));
            }
            if (n > n2) {
                writer.write(", ...");
            }
            writer.write(125);
        } else {
            boolean bl = object instanceof Number;
            if (!bl) {
                writer.write(34);
            }
            writer.write(object.toString());
            if (!bl) {
                writer.write(34);
            }
        }
    }

    @Override
    public String formatWKT(Formatter formatter) {
        return "PARAMETER";
    }
}

