/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.Map;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;

public abstract class AbstractParameterDescriptor
extends AbstractIdentifiedObject
implements GeneralParameterDescriptor {
    private static final long serialVersionUID = -2630644278783845276L;
    private final int minimumOccurs;

    protected AbstractParameterDescriptor(GeneralParameterDescriptor generalParameterDescriptor) {
        super(generalParameterDescriptor);
        this.minimumOccurs = generalParameterDescriptor.getMinimumOccurs();
    }

    protected AbstractParameterDescriptor(Map<String, ?> map, int n, int n2) {
        super(map);
        this.minimumOccurs = n;
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException(Errors.format(13, n, n2));
        }
    }

    @Override
    public abstract GeneralParameterValue createValue();

    @Override
    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    @Override
    public abstract int getMaximumOccurs();

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (super.equals(abstractIdentifiedObject, bl)) {
            AbstractParameterDescriptor abstractParameterDescriptor = (AbstractParameterDescriptor)abstractIdentifiedObject;
            return this.minimumOccurs == abstractParameterDescriptor.minimumOccurs;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.minimumOccurs ^ 0x58ACDC64;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.setInvalidWKT(GeneralParameterDescriptor.class);
        return "PARAMETER";
    }
}

