/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.parameter.AbstractParameterDescriptor;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.CodeList;

public class DefaultParameterDescriptor<T>
extends AbstractParameterDescriptor
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = -295668622297737705L;
    private static final Map<Double, Double> CACHE = new HashMap<Double, Double>(13);
    private final Class<T> valueClass;
    private final Set<T> validValues;
    private final T defaultValue;
    private final Comparable<T> minimum;
    private final Comparable<T> maximum;
    private final Unit<?> unit;

    private static void cache(Double d) {
        if (CACHE.put(d, d) != null) {
            throw new AssertionError(d);
        }
    }

    private static <T> T cached(T t) {
        Double d = CACHE.get(t);
        return (T)(d != null ? d : t);
    }

    public DefaultParameterDescriptor(ParameterDescriptor<T> parameterDescriptor) {
        super(parameterDescriptor);
        this.valueClass = parameterDescriptor.getValueClass();
        this.validValues = parameterDescriptor.getValidValues();
        this.defaultValue = parameterDescriptor.getDefaultValue();
        this.minimum = parameterDescriptor.getMinimumValue();
        this.maximum = parameterDescriptor.getMaximumValue();
        this.unit = parameterDescriptor.getUnit();
    }

    public DefaultParameterDescriptor(String string, Class<T> clazz, T[] TArray, T t) {
        this(Collections.singletonMap("name", string), clazz, TArray, t, null, null, null, true);
    }

    public DefaultParameterDescriptor(Citation citation, String string, Class<T> clazz, T[] TArray, T t, Comparable<T> comparable, Comparable<T> comparable2, Unit<?> unit, boolean bl) {
        this(Collections.singletonMap("name", new NamedIdentifier(citation, string)), clazz, TArray, t, comparable, comparable2, unit, bl);
    }

    public DefaultParameterDescriptor(String string, CharSequence charSequence, Class<T> clazz, T t, boolean bl) {
        this(DefaultParameterDescriptor.properties(string, charSequence), clazz, DefaultParameterDescriptor.codeList(clazz), t, null, null, null, bl);
    }

    public DefaultParameterDescriptor(Map<String, ?> map, Class<T> clazz, T[] TArray, T t, Comparable<T> comparable, Comparable<T> comparable2, Unit<?> unit, boolean bl) {
        super(map, bl ? 1 : 0, 1);
        this.valueClass = clazz;
        this.defaultValue = DefaultParameterDescriptor.cached(t);
        this.minimum = DefaultParameterDescriptor.cached(comparable);
        this.maximum = DefaultParameterDescriptor.cached(comparable2);
        this.unit = unit;
        DefaultParameterDescriptor.ensureNonNull("valueClass", clazz);
        AbstractParameter.ensureValidClass(clazz, t);
        AbstractParameter.ensureValidClass(clazz, comparable);
        AbstractParameter.ensureValidClass(clazz, comparable2);
        if (comparable != null && comparable2 != null && comparable.compareTo(clazz.cast(comparable2)) > 0) {
            throw new IllegalArgumentException(Errors.format(13, comparable, comparable2));
        }
        if (TArray != null) {
            HashSet<T> hashSet = new HashSet<T>(Math.max(Utilities.hashMapCapacity(TArray.length), 8));
            for (int i = 0; i < TArray.length; ++i) {
                T t2 = DefaultParameterDescriptor.cached(TArray[i]);
                AbstractParameter.ensureValidClass(clazz, t2);
                hashSet.add(t2);
            }
            this.validValues = Collections.unmodifiableSet(hashSet);
        } else {
            this.validValues = null;
        }
        if (t != null) {
            AbstractParameter.ensureValidValue(this, t);
        }
    }

    public static DefaultParameterDescriptor<Integer> create(String string, int n, int n2, int n3) {
        return DefaultParameterDescriptor.create(Collections.singletonMap("name", string), n, n2, n3, true);
    }

    public static DefaultParameterDescriptor<Integer> create(Map<String, ?> map, int n, int n2, int n3, boolean bl) {
        return new DefaultParameterDescriptor<Integer>(map, Integer.class, null, n, n2 == Integer.MIN_VALUE ? null : Integer.valueOf(n2), n3 == Integer.MAX_VALUE ? null : Integer.valueOf(n3), null, bl);
    }

    public static DefaultParameterDescriptor<Double> create(String string, double d, double d2, double d3, Unit<?> unit) {
        return DefaultParameterDescriptor.create(Collections.singletonMap("name", string), d, d2, d3, unit, true);
    }

    public static DefaultParameterDescriptor<Double> create(Map<String, ?> map, double d, double d2, double d3, Unit<?> unit, boolean bl) {
        return new DefaultParameterDescriptor<Double>(map, Double.class, null, Double.isNaN(d) ? null : Double.valueOf(d), d2 == Double.NEGATIVE_INFINITY ? null : Double.valueOf(d2), d3 == Double.POSITIVE_INFINITY ? null : Double.valueOf(d3), unit, bl);
    }

    private static <T> T[] codeList(Class<T> clazz) {
        Object[] objectArray = null;
        if (CodeList.class.isAssignableFrom(clazz)) {
            try {
                Object[] objectArray2;
                objectArray = objectArray2 = (Object[])clazz.getMethod("values", null).invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectArray;
    }

    private static Map<String, CharSequence> properties(String string, CharSequence charSequence) {
        Map<String, CharSequence> map;
        if (charSequence == null) {
            map = Collections.singletonMap("name", string);
        } else {
            map = new HashMap<String, String>(4);
            map.put("name", string);
            map.put("remarks", charSequence);
        }
        return map;
    }

    @Override
    public int getMaximumOccurs() {
        return 1;
    }

    @Override
    public ParameterValue<T> createValue() {
        if (Double.class.equals(this.valueClass) && this.unit == null) {
            return new FloatParameter(this);
        }
        return new Parameter(this);
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public Set<T> getValidValues() {
        return this.validValues;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Comparable<T> getMinimumValue() {
        return this.minimum;
    }

    @Override
    public Comparable<T> getMaximumValue() {
        return this.maximum;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            if (!(bl || this.nameMatches(abstractIdentifiedObject.getName().getCode()) || DefaultParameterDescriptor.nameMatches((IdentifiedObject)abstractIdentifiedObject, this.getName().getCode()))) {
                return false;
            }
            DefaultParameterDescriptor defaultParameterDescriptor = (DefaultParameterDescriptor)abstractIdentifiedObject;
            return Utilities.equals(this.validValues, defaultParameterDescriptor.validValues) && Utilities.equals(this.defaultValue, defaultParameterDescriptor.defaultValue) && Utilities.equals(this.minimum, defaultParameterDescriptor.minimum) && Utilities.equals(this.maximum, defaultParameterDescriptor.maximum) && Utilities.equals(this.unit, defaultParameterDescriptor.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode() * 31 + this.valueClass.hashCode();
        if (this.defaultValue != null) {
            n = n * 31 + this.defaultValue.hashCode();
        }
        if (this.minimum != null) {
            n = n * 31 + this.minimum.hashCode();
        }
        if (this.maximum != null) {
            n = n * 31 + this.maximum.hashCode();
        }
        if (this.unit != null) {
            n = n * 31 + this.unit.hashCode();
        }
        return n;
    }

    static {
        DefaultParameterDescriptor.cache(0.0);
        DefaultParameterDescriptor.cache(1.0);
        DefaultParameterDescriptor.cache(-90.0);
        DefaultParameterDescriptor.cache(90.0);
        DefaultParameterDescriptor.cache(-180.0);
        DefaultParameterDescriptor.cache(180.0);
        DefaultParameterDescriptor.cache(-648000.0);
        DefaultParameterDescriptor.cache(648000.0);
        DefaultParameterDescriptor.cache(Double.NEGATIVE_INFINITY);
        DefaultParameterDescriptor.cache(Double.POSITIVE_INFINITY);
    }
}

