/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.net.URI;
import javax.measure.unit.Unit;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class FloatParameter
extends AbstractParameter
implements ParameterValue<Double> {
    private static final long serialVersionUID = 9027797654033417816L;
    private double value;

    public FloatParameter(ParameterDescriptor<Double> parameterDescriptor) {
        super(parameterDescriptor);
        Class<Double> clazz = parameterDescriptor.getValueClass();
        Class<Double> clazz2 = Double.class;
        if (!clazz2.equals(clazz) && !Double.TYPE.equals(clazz)) {
            throw new IllegalArgumentException(Errors.format(66, clazz, clazz2));
        }
        Number number = parameterDescriptor.getDefaultValue();
        this.value = number != null ? number.doubleValue() : Double.NaN;
    }

    public FloatParameter(ParameterDescriptor<Double> parameterDescriptor, double d) {
        this(parameterDescriptor);
        this.setValue(d);
    }

    @Override
    public ParameterDescriptor<Double> getDescriptor() {
        return (ParameterDescriptor)this.descriptor;
    }

    @Override
    public Unit<?> getUnit() {
        return ((ParameterDescriptor)this.descriptor).getUnit();
    }

    @Override
    public double doubleValue(Unit<?> unit) throws IllegalArgumentException {
        FloatParameter.ensureNonNull("unit", unit);
        Unit<?> unit2 = this.getUnit();
        if (unit2 == null) {
            throw FloatParameter.unitlessParameter(this.descriptor);
        }
        int n = FloatParameter.getUnitMessageID(unit2);
        if (FloatParameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format(n, unit));
        }
        return unit2.getConverterTo(unit).convert(this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)Math.round(this.value);
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException {
        return new double[]{this.doubleValue(unit)};
    }

    @Override
    public double[] doubleValueList() {
        return new double[]{this.doubleValue()};
    }

    @Override
    public int[] intValueList() {
        return new int[]{this.intValue()};
    }

    @Override
    public URI valueFile() throws InvalidParameterTypeException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor));
    }

    private static String getClassTypeError() {
        return Errors.format(77, Double.class);
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        FloatParameter.ensureNonNull("unit", unit);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> unit2 = parameterDescriptor.getUnit();
        if (unit2 == null) {
            throw FloatParameter.unitlessParameter(parameterDescriptor);
        }
        int n = FloatParameter.getUnitMessageID(unit2);
        if (FloatParameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format(n, unit));
        }
        d = unit.getConverterTo(unit2).convert(d);
        this.value = (Double)FloatParameter.ensureValidValue(parameterDescriptor, d);
    }

    @Override
    public void setValue(double d) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        this.value = (Double)FloatParameter.ensureValidValue(parameterDescriptor, d);
    }

    @Override
    public void setValue(int n) throws InvalidParameterValueException {
        this.setValue((double)n);
    }

    @Override
    public void setValue(boolean bl) throws InvalidParameterValueException {
        this.setValue(bl ? 1.0 : 0.0);
    }

    @Override
    public void setValue(Object object) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        this.value = (Double)FloatParameter.ensureValidValue(parameterDescriptor, object);
    }

    @Override
    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor));
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            FloatParameter floatParameter = (FloatParameter)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(floatParameter.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >>> 32) + super.hashCode() * 37;
    }

    @Override
    public FloatParameter clone() {
        return (FloatParameter)super.clone();
    }
}

