/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.measure.Units;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.util.CodeList;

public class Parameter<T>
extends AbstractParameter
implements ParameterValue<T> {
    private static final long serialVersionUID = -5837826787089486776L;
    private T value;
    private Unit<?> unit;

    public Parameter(ParameterDescriptor<T> parameterDescriptor) {
        super(parameterDescriptor);
        this.value = parameterDescriptor.getDefaultValue();
        this.unit = parameterDescriptor.getUnit();
    }

    public Parameter(ParameterDescriptor<T> parameterDescriptor, T t) throws InvalidParameterValueException {
        super(parameterDescriptor);
        this.unit = parameterDescriptor.getUnit();
        this.setValue(t);
    }

    public static Parameter<Integer> create(String string, int n) {
        DefaultParameterDescriptor<Object> defaultParameterDescriptor = new DefaultParameterDescriptor<Object>(string, Integer.class, null, null);
        Parameter<Object> parameter = new Parameter<Object>(defaultParameterDescriptor);
        parameter.value = n;
        return parameter;
    }

    public static Parameter<Double> create(String string, double d, Unit<?> unit) {
        if (unit != null) {
            if (Units.isLinear(unit)) {
                unit = SI.METRE;
            } else if (Units.isTemporal(unit)) {
                unit = NonSI.DAY;
            } else if (Units.isAngular(unit)) {
                unit = NonSI.DEGREE_ANGLE;
            }
        }
        DefaultParameterDescriptor<Double> defaultParameterDescriptor = DefaultParameterDescriptor.create(string, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, unit);
        Parameter<Double> parameter = new Parameter<Double>(defaultParameterDescriptor);
        parameter.value = d;
        parameter.unit = unit;
        return parameter;
    }

    public static <T extends CodeList<T>> Parameter<T> create(String string, Class<T> clazz, T t) {
        DefaultParameterDescriptor<Object> defaultParameterDescriptor = new DefaultParameterDescriptor<Object>(string, null, clazz, null, true);
        Parameter<Object> parameter = new Parameter<Object>(defaultParameterDescriptor);
        parameter.value = t;
        return parameter;
    }

    private String getClassTypeError() {
        return Errors.format(77, ((ParameterDescriptor)this.descriptor).getValueClass());
    }

    @Override
    public ParameterDescriptor<T> getDescriptor() {
        return (ParameterDescriptor)super.getDescriptor();
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public double doubleValue(Unit<?> unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        int n = Parameter.getUnitMessageID(this.unit);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format(n, unit));
        }
        return this.unit.getConverterTo(unit).convert(this.doubleValue());
    }

    @Override
    public double doubleValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(106, string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    @Override
    public int intValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(106, string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    @Override
    public boolean booleanValue() throws InvalidParameterTypeException {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(106, string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    @Override
    public String stringValue() throws InvalidParameterTypeException {
        if (this.value instanceof CharSequence) {
            return this.value.toString();
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(106, string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        int n = Parameter.getUnitMessageID(this.unit);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format(n, unit));
        }
        UnitConverter unitConverter = this.unit.getConverterTo(unit);
        double[] dArray = (double[])this.doubleValueList().clone();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = unitConverter.convert(dArray[i]);
        }
        return dArray;
    }

    @Override
    public double[] doubleValueList() throws InvalidParameterTypeException {
        if (this.value instanceof double[]) {
            return (double[])this.value;
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(106, string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    @Override
    public int[] intValueList() throws InvalidParameterTypeException {
        if (this.value instanceof int[]) {
            return (int[])this.value;
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(106, string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    @Override
    public URI valueFile() throws InvalidParameterTypeException {
        if (this.value instanceof URI) {
            return (URI)this.value;
        }
        if (this.value instanceof File) {
            return ((File)this.value).toURI();
        }
        URISyntaxException uRISyntaxException = null;
        try {
            if (this.value instanceof URL) {
                return ((URL)this.value).toURI();
            }
            if (this.value instanceof String) {
                return new URI((String)this.value);
            }
        }
        catch (URISyntaxException uRISyntaxException2) {
            uRISyntaxException = uRISyntaxException2;
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(106, string));
        }
        InvalidParameterTypeException invalidParameterTypeException = new InvalidParameterTypeException(this.getClassTypeError(), string);
        if (uRISyntaxException != null) {
            invalidParameterTypeException.initCause(uRISyntaxException);
        }
        throw invalidParameterTypeException;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> unit2 = parameterDescriptor.getUnit();
        if (unit2 == null) {
            throw Parameter.unitlessParameter(parameterDescriptor);
        }
        int n = Parameter.getUnitMessageID(unit2);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new InvalidParameterValueException(Errors.format(n, unit), parameterDescriptor.getName().getCode(), d);
        }
        Double d2 = unit.getConverterTo(unit2).convert(d);
        Parameter.ensureValidValue(parameterDescriptor, d2);
        this.value = parameterDescriptor.getValueClass().cast(d);
        this.unit = unit;
    }

    @Override
    public void setValue(double d) throws InvalidParameterValueException {
        Double d2 = d;
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        this.value = Parameter.ensureValidValue(parameterDescriptor, d2);
    }

    @Override
    public void setValue(int n) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Class clazz = parameterDescriptor.getValueClass();
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            this.setValue((double)n);
            return;
        }
        Integer n2 = n;
        this.value = Parameter.ensureValidValue(parameterDescriptor, n2);
    }

    @Override
    public void setValue(boolean bl) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Boolean bl2 = bl;
        this.value = Parameter.ensureValidValue(parameterDescriptor, bl2);
    }

    @Override
    public void setValue(Object object) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        this.value = Parameter.ensureValidValue(parameterDescriptor, object);
    }

    @Override
    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> unit2 = parameterDescriptor.getUnit();
        if (unit2 == null) {
            throw Parameter.unitlessParameter(parameterDescriptor);
        }
        int n = Parameter.getUnitMessageID(unit2);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format(n, unit));
        }
        double[] dArray2 = (double[])dArray.clone();
        UnitConverter unitConverter = unit.getConverterTo(unit2);
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = unitConverter.convert(dArray2[i]);
        }
        this.value = Parameter.ensureValidValue(parameterDescriptor, dArray2);
        this.unit = unit;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Parameter parameter = (Parameter)object;
            return Utilities.equals(this.value, parameter.value) && Utilities.equals(this.unit, parameter.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 31 * super.hashCode();
        if (this.value != null) {
            n += this.value.hashCode();
        }
        if (this.unit != null) {
            n += 31 * this.unit.hashCode();
        }
        return n ^ 0x9F456C48;
    }

    @Override
    public Parameter<T> clone() {
        return (Parameter)super.clone();
    }
}

