/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.parameter.ParameterValueList;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class ParameterGroup
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = -1985309386356545126L;
    public static ParameterValueGroup EMPTY = new ParameterGroup(Collections.singletonMap("name", "Void"), (GeneralParameterValue[])new ParameterValue[0]);
    private ArrayList<GeneralParameterValue> values;
    private transient List<GeneralParameterValue> asList;

    public ParameterGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        this.values = new ArrayList(list.size());
        for (GeneralParameterDescriptor generalParameterDescriptor : list) {
            int n = generalParameterDescriptor.getMinimumOccurs();
            while (--n >= 0) {
                GeneralParameterValue generalParameterValue = generalParameterDescriptor.createValue();
                ParameterGroup.ensureNonNull("createValue", generalParameterValue);
                this.values.add(generalParameterValue);
            }
        }
    }

    public ParameterGroup(ParameterDescriptorGroup parameterDescriptorGroup, GeneralParameterValue[] generalParameterValueArray) {
        super(parameterDescriptorGroup);
        ParameterGroup.ensureNonNull("values", generalParameterValueArray);
        this.values = new ArrayList(generalParameterValueArray.length);
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            this.values.add(generalParameterValueArray[i]);
        }
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        LinkedHashMap<GeneralParameterDescriptor, int[]> linkedHashMap = new LinkedHashMap<GeneralParameterDescriptor, int[]>(Utilities.hashMapCapacity(list.size()));
        for (GeneralParameterDescriptor generalParameterDescriptor : list) {
            ParameterGroup.ensureNonNull("parameters", generalParameterDescriptor);
            linkedHashMap.put(generalParameterDescriptor, new int[1]);
        }
        ParameterGroup.ensureValidOccurs(generalParameterValueArray, linkedHashMap);
    }

    public ParameterGroup(Map<String, ?> map, GeneralParameterValue[] generalParameterValueArray) {
        super(ParameterGroup.createDescriptor(map, generalParameterValueArray));
        this.values = new ArrayList(generalParameterValueArray.length);
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            this.values.add(generalParameterValueArray[i]);
        }
    }

    private static ParameterDescriptorGroup createDescriptor(Map<String, ?> map, GeneralParameterValue[] generalParameterValueArray) {
        ParameterGroup.ensureNonNull("values", generalParameterValueArray);
        LinkedHashMap<GeneralParameterDescriptor, int[]> linkedHashMap = new LinkedHashMap<GeneralParameterDescriptor, int[]>(Utilities.hashMapCapacity(generalParameterValueArray.length));
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            ParameterGroup.ensureNonNull("values", generalParameterValueArray, i);
            linkedHashMap.put(generalParameterValueArray[i].getDescriptor(), new int[1]);
        }
        ParameterGroup.ensureValidOccurs(generalParameterValueArray, linkedHashMap);
        Set set = linkedHashMap.keySet();
        return new DefaultParameterDescriptorGroup(map, set.toArray(new GeneralParameterDescriptor[set.size()]));
    }

    private static void ensureValidOccurs(GeneralParameterValue[] generalParameterValueArray, Map<GeneralParameterDescriptor, int[]> map) {
        Object object;
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            ParameterGroup.ensureNonNull("values", generalParameterValueArray, i);
            GeneralParameterDescriptor object2 = generalParameterValueArray[i].getDescriptor();
            object = map.get(object2);
            if (object == null) {
                String string = ParameterGroup.getName(object2);
                throw new InvalidParameterTypeException(Errors.format(70, string), string);
            }
            Object object3 = object;
            object3[0] = object3[0] + 1;
        }
        for (Map.Entry<GeneralParameterDescriptor, int[]> entry : map.entrySet()) {
            object = entry.getKey();
            int n = entry.getValue()[0];
            int n2 = object.getMinimumOccurs();
            int n3 = object.getMaximumOccurs();
            if (n >= n2 && n <= n3) continue;
            String string = ParameterGroup.getName((GeneralParameterDescriptor)object);
            throw new InvalidParameterCardinalityException(Errors.format(76, string, n, n2, n3), string);
        }
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return (ParameterDescriptorGroup)super.getDescriptor();
    }

    @Override
    public List<GeneralParameterValue> values() {
        if (this.asList == null) {
            this.asList = new ParameterValueList((ParameterDescriptorGroup)this.descriptor, this.values);
        }
        return this.asList;
    }

    final GeneralParameterValue parameter(int n) throws IndexOutOfBoundsException {
        return this.values.get(n);
    }

    @Override
    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        ParameterGroup.ensureNonNull("name", string);
        string = string.trim();
        for (GeneralParameterValue object : this.values) {
            if (!(object instanceof ParameterValue) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)object.getDescriptor(), string)) continue;
            return (ParameterValue)object;
        }
        for (GeneralParameterDescriptor generalParameterDescriptor : this.getDescriptor().descriptors()) {
            if (!(generalParameterDescriptor instanceof ParameterDescriptor) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterDescriptor, string)) continue;
            ParameterValue parameterValue = ((ParameterDescriptor)generalParameterDescriptor).createValue();
            this.values.add(parameterValue);
            return parameterValue;
        }
        throw new ParameterNotFoundException(Errors.format(106, string), string);
    }

    @Override
    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        ParameterGroup.ensureNonNull("name", string);
        string = string.trim();
        ArrayList<ParameterValueGroup> arrayList = new ArrayList<ParameterValueGroup>(Math.min(this.values.size(), 10));
        Object object = this.values.iterator();
        while (object.hasNext()) {
            GeneralParameterValue generalParameterValue = object.next();
            if (!(generalParameterValue instanceof ParameterValueGroup) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterValue.getDescriptor(), string)) continue;
            arrayList.add((ParameterValueGroup)generalParameterValue);
        }
        if (arrayList.isEmpty() && !((object = ((ParameterDescriptorGroup)this.descriptor).descriptor(string)) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format(106, string), string);
        }
        return arrayList;
    }

    @Override
    public ParameterValueGroup addGroup(String string) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        GeneralParameterDescriptor generalParameterDescriptor = ((ParameterDescriptorGroup)this.descriptor).descriptor(string);
        if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format(106, string), string);
        }
        int n = 0;
        for (GeneralParameterValue generalParameterValue : this.values) {
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterValue.getDescriptor(), string)) continue;
            ++n;
        }
        if (n >= generalParameterDescriptor.getMaximumOccurs()) {
            throw new InvalidParameterCardinalityException(Errors.format(179, string, n), string);
        }
        ParameterValueGroup parameterValueGroup = ((ParameterDescriptorGroup)generalParameterDescriptor).createValue();
        this.values.add(parameterValueGroup);
        return parameterValueGroup;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ParameterGroup parameterGroup = (ParameterGroup)object;
            return Utilities.equals(this.values, parameterGroup.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.values.hashCode();
    }

    @Override
    public ParameterGroup clone() {
        ParameterGroup parameterGroup = (ParameterGroup)super.clone();
        parameterGroup.values = (ArrayList)parameterGroup.values.clone();
        int n = parameterGroup.values.size();
        while (--n >= 0) {
            parameterGroup.values.set(n, parameterGroup.values.get(n).clone());
        }
        parameterGroup.asList = null;
        return parameterGroup;
    }
}

