/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.Console;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.measure.Angle;
import org.geotoolkit.measure.AngleFormat;
import org.geotoolkit.parameter.ParameterTableRow;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.GenericName;

public class ParameterWriter
extends FilterWriter {
    private static final String SHOW_EPSG_CODES = "EPSG:#";
    private Set<String> scopes;
    private Locale locale = Locale.getDefault();
    private transient NumberFormat numberFormat;
    private transient DateFormat dateFormat;
    private transient AngleFormat angleFormat;
    private boolean canSetPositivePrefix;
    private boolean wantPositivePrefix;
    private boolean colorEnabled;

    public ParameterWriter() {
        this(ParameterWriter.standardOutput());
    }

    private static Writer standardOutput() {
        Console console = System.console();
        if (console != null) {
            return console.writer();
        }
        return new OutputStreamWriter(System.out);
    }

    public ParameterWriter(Writer writer) {
        super(writer);
    }

    public static void print(OperationMethod operationMethod) {
        ParameterWriter parameterWriter = new ParameterWriter();
        try {
            parameterWriter.format(operationMethod);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void print(ParameterDescriptorGroup parameterDescriptorGroup) {
        ParameterWriter parameterWriter = new ParameterWriter();
        try {
            parameterWriter.format(parameterDescriptorGroup);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void print(ParameterValueGroup parameterValueGroup) {
        ParameterWriter parameterWriter = new ParameterWriter();
        try {
            parameterWriter.format(parameterValueGroup);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(OperationMethod operationMethod) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.format(operationMethod.getName().getCode(), operationMethod.getParameters(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(ParameterDescriptorGroup parameterDescriptorGroup) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.format(parameterDescriptorGroup.getName().getCode(), parameterDescriptorGroup, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(ParameterValueGroup parameterValueGroup) throws IOException {
        ParameterDescriptorGroup parameterDescriptorGroup = parameterValueGroup.getDescriptor();
        Object object = this.lock;
        synchronized (object) {
            this.format(parameterDescriptorGroup.getName().getCode(), parameterDescriptorGroup, parameterValueGroup);
        }
    }

    private void format(String string, ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) throws IOException {
        GeneralParameterDescriptor generalParameterDescriptor;
        Object object;
        Object object2;
        Object object3;
        Writer writer = this.out;
        Locale locale = this.locale;
        boolean bl = this.colorEnabled;
        String string2 = System.getProperty("line.separator", "\n");
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        new ParameterTableRow(parameterDescriptorGroup, locale, null).write(writer, bl, false, string2);
        writer.write(string2);
        int n = 9552;
        TableWriter tableWriter = new TableWriter(writer);
        tableWriter.setMultiLinesCells(true);
        tableWriter.nextLine((char)n);
        int n2 = 0;
        block8: while (true) {
            int n3;
            boolean bl2 = false;
            switch (n2) {
                case 0: {
                    n3 = 180;
                    break;
                }
                case 1: {
                    n3 = 275;
                    break;
                }
                case 2: {
                    n3 = 175;
                    break;
                }
                case 3: {
                    n3 = 170;
                    break;
                }
                case 4: {
                    n3 = parameterValueGroup == null ? 61 : 286;
                    break;
                }
                case 5: {
                    n3 = 277;
                    bl2 = true;
                    break;
                }
                default: {
                    break block8;
                }
            }
            if (bl) {
                tableWriter.write(X364.BOLD.sequence());
            }
            tableWriter.write(vocabulary.getString(n3));
            if (bl) {
                tableWriter.write(X364.NORMAL.sequence());
            }
            if (bl2) {
                tableWriter.nextLine();
            } else {
                tableWriter.nextColumn();
            }
            ++n2;
        }
        n2 = 0;
        List<Object> list = parameterValueGroup != null ? parameterValueGroup.values() : parameterDescriptorGroup.descriptors();
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>(Utilities.hashMapCapacity(list.size()));
        ArrayList arrayList = null;
        for (Object object42 : list) {
            if (parameterValueGroup != null) {
                object3 = (GeneralParameterValue)object42;
                object2 = object3.getDescriptor();
            } else {
                object3 = null;
                object2 = (GeneralParameterDescriptor)object42;
            }
            if (object2 instanceof ParameterDescriptorGroup) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(object42);
                continue;
            }
            Iterator iterator = null;
            if (object3 instanceof ParameterValue) {
                iterator = ((ParameterValue)object3).getValue();
            } else if (object2 instanceof ParameterDescriptor) {
                iterator = ((ParameterDescriptor)object2).getDefaultValue();
            }
            Map.Entry entry = (ParameterTableRow)linkedHashMap.get(object2);
            if (entry == null) {
                entry = new ParameterTableRow((IdentifiedObject)object2, locale, iterator);
                linkedHashMap.put(object2, entry);
            } else {
                ((ParameterTableRow)((Object)entry)).addValue(iterator);
            }
            if (((ParameterTableRow)((Object)entry)).width <= n2) continue;
            n2 = ((ParameterTableRow)((Object)entry)).width;
        }
        Object object5 = null;
        Object[] objectArray = new Object[1];
        object3 = Double.POSITIVE_INFINITY;
        object2 = Double.NEGATIVE_INFINITY;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            tableWriter.nextLine((char)n);
            n = 9472;
            object = (ParameterTableRow)entry.getValue();
            ((ParameterTableRow)object).width = n2;
            ((ParameterTableRow)object).write(tableWriter, false, bl, string2);
            tableWriter.nextColumn();
            generalParameterDescriptor = (GeneralParameterDescriptor)entry.getKey();
            if (generalParameterDescriptor instanceof ParameterDescriptor) {
                ParameterDescriptor parameterDescriptor = (ParameterDescriptor)generalParameterDescriptor;
                Class clazz = parameterDescriptor.getValueClass();
                tableWriter.write(Classes.getShortName(clazz));
                tableWriter.nextColumn();
                Object object4 = parameterDescriptor.getMinimumValue();
                Object object6 = parameterDescriptor.getMaximumValue();
                boolean bl2 = false;
                boolean bl3 = Number.class.isAssignableFrom(clazz);
                if (bl3) {
                    tableWriter.setAlignment(2);
                    if (object4 == null) {
                        object4 = object2;
                    }
                    if (object6 == null) {
                        object6 = object3;
                    }
                    boolean bl4 = bl2 = ((Number)object4).doubleValue() < 0.0;
                }
                if (object4 != null) {
                    tableWriter.write(this.formatValue(object4));
                }
                tableWriter.nextColumn();
                this.wantPositivePrefix = bl2;
                if (object6 != null) {
                    tableWriter.write(this.formatValue(object6));
                }
                this.wantPositivePrefix = false;
                tableWriter.nextColumn();
                Object object7 = ((ParameterTableRow)object).values(objectArray);
                int n3 = Array.getLength(object7);
                for (int i = 0; i < n3; ++i) {
                    Object object8 = Array.get(object7, i);
                    if (object8 == null) continue;
                    if (i != 0) {
                        tableWriter.write(string2);
                    }
                    tableWriter.write(this.formatValue(object8));
                }
                tableWriter.nextColumn();
                tableWriter.setAlignment(0);
                Unit<?> i = parameterDescriptor.getUnit();
                if (i != null) {
                    if (object5 == null) {
                        object5 = UnitFormat.getInstance(locale);
                    }
                    tableWriter.write(((Format)object5).format(i));
                }
            }
            tableWriter.nextLine();
        }
        tableWriter.nextLine('\u2550');
        tableWriter.flush();
        if (arrayList != null) {
            for (Map.Entry entry : arrayList) {
                if (entry instanceof ParameterValueGroup) {
                    object = (ParameterValueGroup)((Object)entry);
                    generalParameterDescriptor = object.getDescriptor();
                } else {
                    object = null;
                    generalParameterDescriptor = (ParameterDescriptorGroup)((Object)entry);
                }
                writer.write(string2);
                this.format(string + '/' + generalParameterDescriptor.getName().getCode(), (ParameterDescriptorGroup)generalParameterDescriptor, (ParameterValueGroup)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void summary(Collection<? extends IdentifiedObject> collection) throws IOException {
        Object object;
        String[] stringArray;
        Object i;
        int n;
        LinkedHashMap<Object, Integer> linkedHashMap = new LinkedHashMap<Object, Integer>();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Locale locale = this.getLocale();
        Set<String> set = this.getAuthorities();
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        int n2 = n = set == null || set.contains(SHOW_EPSG_CODES) ? 1 : 0;
        if (n != 0) {
            linkedHashMap.put(SHOW_EPSG_CODES, 0);
        }
        linkedHashMap.put(null, n);
        for (IdentifiedObject object3 : collection) {
            Object object2;
            String string;
            String n5 = null;
            String[] n6 = new String[linkedHashMap.size()];
            n6[n] = object3.getName().getCode();
            int n3 = 0;
            Collection<GenericName> n8 = object3.getAlias();
            if (n8 != null) {
                i = n8.iterator();
                while (i.hasNext()) {
                    stringArray = (GenericName)i.next();
                    object = stringArray.scope().name();
                    string = stringArray.tip().toInternationalString().toString(locale);
                    object2 = object != null ? object.toInternationalString().toString(locale) : Integer.valueOf(++n3);
                    if (object2.equals("EPSG")) {
                        n5 = string;
                    }
                    if (set != null && !set.contains(object.toString())) continue;
                    n6 = ParameterWriter.putIfAbsent(n6, ParameterWriter.getColumnIndex(linkedHashMap, object2), string);
                }
            }
            if ((i = object3.getIdentifiers()) != null) {
                stringArray = i.iterator();
                while (stringArray.hasNext()) {
                    int n4;
                    String string2;
                    object = (ReferenceIdentifier)stringArray.next();
                    string = object.getCodeSpace();
                    object2 = object.getCode();
                    String string3 = string2 = string != null ? string : Integer.valueOf(++n3);
                    if (n != 0 && string2.equals("EPSG")) {
                        n4 = 0;
                    } else {
                        if (set != null && !set.contains(string)) continue;
                        n4 = ParameterWriter.getColumnIndex(linkedHashMap, string2);
                    }
                    n6 = ParameterWriter.putIfAbsent(n6, n4, (String)object2);
                }
            }
            arrayList.add(n6);
            arrayList2.add(n5);
        }
        Object object5 = this.lock;
        synchronized (object5) {
            TableWriter tableWriter = new TableWriter(this.out, " \u2502 ");
            tableWriter.setMultiLinesCells(true);
            tableWriter.writeHorizontalSeparator();
            int n5 = 0;
            int n6 = -1;
            for (Collection<GenericName> n8 : linkedHashMap.keySet()) {
                if (n8 == null) {
                    i = vocabulary.getString(130);
                } else if (n8 == SHOW_EPSG_CODES) {
                    i = "EPSG";
                } else if (n8 instanceof String) {
                    i = (String)((Object)n8);
                    if (((String)i).equalsIgnoreCase("geotk") || ((String)i).equalsIgnoreCase("Geotoolkit.org") || ((String)i).equalsIgnoreCase("Geotoolkit")) {
                        n6 = n5;
                        i = vocabulary.getString(65);
                    }
                } else {
                    i = vocabulary.getString(5) + ' ' + n8;
                }
                if (this.colorEnabled) {
                    i = X364.BOLD.sequence() + (String)i + X364.NORMAL.sequence();
                }
                tableWriter.write((String)i);
                tableWriter.nextColumn();
                ++n5;
            }
            tableWriter.writeHorizontalSeparator();
            int n7 = arrayList.size();
            int n8 = linkedHashMap.size();
            for (int j = 0; j < n7; ++j) {
                stringArray = (String[])arrayList.get(j);
                for (n5 = 0; n5 < n8; ++n5) {
                    if (n5 < stringArray.length) {
                        object = stringArray[n5];
                        if (n5 == n6) {
                            if (object == null) {
                                object = (String)arrayList2.get(j);
                            } else if (this.colorEnabled && !((String)object).equals(stringArray[n])) {
                                object = X364.FAINT.sequence() + (String)object + X364.NORMAL.sequence();
                            }
                        }
                        if (object != null) {
                            tableWriter.write((String)object);
                        }
                    }
                    tableWriter.nextColumn();
                }
                tableWriter.nextLine();
            }
            tableWriter.writeHorizontalSeparator();
            tableWriter.flush();
        }
    }

    private static int getColumnIndex(Map<Object, Integer> map, Object object) {
        Integer n = map.get(object);
        if (n == null) {
            n = map.size();
            map.put(object, n);
        }
        return n;
    }

    private static String[] putIfAbsent(String[] stringArray, int n, String string) {
        if (n >= stringArray.length) {
            stringArray = Arrays.copyOf(stringArray, n + 1);
        }
        if (stringArray[n] == null) {
            stringArray[n] = string;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAuthorities() {
        Object object = this.lock;
        synchronized (object) {
            return this.scopes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthorities(String ... stringArray) {
        Set<String> set = null;
        if (stringArray != null) {
            set = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(stringArray)));
        }
        Object object = this.lock;
        synchronized (object) {
            this.scopes = set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColorEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.colorEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorEnabled(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.colorEnabled = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLocale() {
        Object object = this.lock;
        synchronized (object) {
            return this.locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        Object object = this.lock;
        synchronized (object) {
            this.locale = locale;
            this.numberFormat = null;
            this.dateFormat = null;
            this.angleFormat = null;
        }
    }

    protected String formatValue(Object object) {
        if (object instanceof Number) {
            if (this.numberFormat == null) {
                DecimalFormat decimalFormat;
                String string;
                this.numberFormat = NumberFormat.getNumberInstance(this.locale);
                this.canSetPositivePrefix = false;
                if (this.numberFormat instanceof DecimalFormat && (string = (decimalFormat = (DecimalFormat)this.numberFormat).getPositivePrefix()) != null && string.length() == 0 && "-".equals(string = decimalFormat.getNegativePrefix())) {
                    this.canSetPositivePrefix = true;
                }
            }
            if (this.canSetPositivePrefix) {
                ((DecimalFormat)this.numberFormat).setPositivePrefix(this.wantPositivePrefix ? "+" : "");
            }
            return this.numberFormat.format(object);
        }
        if (object instanceof Date) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(2, this.locale);
            }
            return this.dateFormat.format(object);
        }
        if (object instanceof Angle) {
            if (this.angleFormat == null) {
                this.angleFormat = AngleFormat.getInstance(this.locale);
            }
            return this.angleFormat.format(object);
        }
        return String.valueOf(object);
    }
}

