/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public final class Parameters {
    private static final double EPS = 1.0E-8;
    public static ParameterDescriptorGroup EMPTY_GROUP = new DefaultParameterDescriptorGroup(Vocabulary.format(83), new GeneralParameterDescriptor[0]);

    private Parameters() {
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> parameterDescriptor, Class<T> clazz) throws ClassCastException {
        Class<?> clazz2;
        if (parameterDescriptor != null && !clazz.equals(clazz2 = parameterDescriptor.getValueClass())) {
            throw new ClassCastException(Errors.format(12, parameterDescriptor.getName().getCode(), clazz2));
        }
        return parameterDescriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> parameterValue, Class<T> clazz) throws ClassCastException {
        ParameterDescriptor<?> parameterDescriptor;
        Class<?> clazz2;
        if (parameterValue != null && !clazz.equals(clazz2 = (parameterDescriptor = parameterValue.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Errors.format(12, parameterDescriptor.getName().getCode(), clazz2));
        }
        return parameterValue;
    }

    public static boolean isValid(ParameterValue<?> parameterValue) {
        ParameterDescriptor<?> parameterDescriptor = parameterValue.getDescriptor();
        Object obj = parameterValue.getValue();
        if (obj == null) {
            Set<?> set = parameterDescriptor.getValidValues();
            return set != null && set.contains(obj);
        }
        Class<?> clazz = Classes.primitiveToWrapper(obj.getClass());
        Class<?> clazz2 = Classes.primitiveToWrapper(parameterDescriptor.getValueClass());
        if (clazz2.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isArray()) {
            int n = Array.getLength(obj);
            for (int i = 0; i < n; ++i) {
                if (Parameters.isValidValue(Array.get(obj, i), parameterDescriptor)) continue;
                return false;
            }
        } else if (obj instanceof Collection) {
            for (Object e : (Collection)obj) {
                if (Parameters.isValidValue(e, parameterDescriptor)) continue;
                return false;
            }
        } else if (!Parameters.isValidValue(obj, parameterDescriptor)) {
            return false;
        }
        return true;
    }

    private static boolean isValidValue(Object object, ParameterDescriptor<?> parameterDescriptor) {
        Set<?> set = parameterDescriptor.getValidValues();
        if (set != null && !set.contains(object)) {
            return false;
        }
        Comparable<?> comparable = parameterDescriptor.getMinimumValue();
        if (comparable != null && comparable.compareTo(object) > 0) {
            return false;
        }
        Comparable<?> comparable2 = parameterDescriptor.getMaximumValue();
        return comparable2 == null || comparable2.compareTo(object) >= 0;
    }

    private static <T> ParameterValue<T> getParameter(ParameterDescriptor<T> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        String string = AbstractIdentifiedObject.getName(parameterDescriptor, parameterValueGroup.getDescriptor().getName().getAuthority());
        if (string == null) {
            string = parameterDescriptor.getName().getCode();
        }
        if (parameterDescriptor.getMinimumOccurs() != 0) {
            return Parameters.cast(parameterValueGroup.parameter(string), parameterDescriptor.getValueClass());
        }
        GeneralParameterDescriptor generalParameterDescriptor = parameterValueGroup.getDescriptor().descriptor(string);
        if (generalParameterDescriptor instanceof ParameterDescriptor) {
            for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
                if (!generalParameterDescriptor.equals(generalParameterValue.getDescriptor())) continue;
                return Parameters.cast((ParameterValue)generalParameterValue, parameterDescriptor.getValueClass());
            }
        }
        return null;
    }

    public static <T> T value(ParameterDescriptor<T> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<T> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? (T)parameterValue.getValue() : null;
    }

    public static String stringValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? parameterValue.stringValue() : null;
    }

    public static Integer integerValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? Integer.valueOf(parameterValue.intValue()) : null;
    }

    public static double doubleValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        Unit<?> unit = parameterDescriptor.getUnit();
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue == null ? Double.NaN : (unit != null ? parameterValue.doubleValue(unit) : parameterValue.doubleValue());
    }

    public static List<GeneralParameterValue> search(GeneralParameterValue generalParameterValue, String string, int n) {
        ArrayList<GeneralParameterValue> arrayList = new ArrayList<GeneralParameterValue>();
        Parameters.search(generalParameterValue, string, n, arrayList);
        return arrayList;
    }

    private static void search(GeneralParameterValue generalParameterValue, String string, int n, Collection<GeneralParameterValue> collection) {
        if (n >= 0) {
            if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterValue.getDescriptor(), string)) {
                collection.add(generalParameterValue);
            }
            if (n != 0 && generalParameterValue instanceof ParameterValueGroup) {
                for (GeneralParameterValue generalParameterValue2 : ((ParameterValueGroup)generalParameterValue).values()) {
                    Parameters.search(generalParameterValue2, string, n - 1, collection);
                }
            }
        }
    }

    public static void copy(ParameterValueGroup parameterValueGroup, ParameterValueGroup parameterValueGroup2) {
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            String string = generalParameterValue.getDescriptor().getName().getCode();
            if (generalParameterValue instanceof ParameterValueGroup) {
                Parameters.copy((ParameterValueGroup)generalParameterValue, parameterValueGroup2.addGroup(string));
                continue;
            }
            parameterValueGroup2.parameter(string).setValue(((ParameterValue)generalParameterValue).getValue());
        }
    }

    public static Map<String, Object> toNameValueMap(GeneralParameterValue generalParameterValue, Map<String, Object> map) {
        GeneralParameterValue generalParameterValue2;
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
        }
        if (generalParameterValue instanceof ParameterValue) {
            generalParameterValue2 = (ParameterValue)generalParameterValue;
            Object t = generalParameterValue2.getValue();
            Object object = map.put(generalParameterValue2.getDescriptor().getName().getCode(), t);
            if (object != null && !object.equals(t)) {
                throw new IllegalArgumentException(Errors.format(84));
            }
        }
        if (generalParameterValue instanceof ParameterValueGroup) {
            generalParameterValue2 = (ParameterValueGroup)generalParameterValue;
            for (GeneralParameterValue generalParameterValue3 : generalParameterValue2.values()) {
                map = Parameters.toNameValueMap(generalParameterValue3, map);
            }
        }
        return map;
    }

    public static boolean ensureSet(ParameterValueGroup parameterValueGroup, String string, double d, Unit<?> unit, boolean bl) {
        ParameterValue<?> parameterValue;
        try {
            parameterValue = parameterValueGroup.parameter(string);
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            return false;
        }
        try {
            if (Math.abs(parameterValue.doubleValue(unit) / d - 1.0) <= 1.0E-8) {
                return false;
            }
        }
        catch (InvalidParameterTypeException invalidParameterTypeException) {
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            parameterValue.setValue(d, unit);
            return true;
        }
        if (bl) {
            parameterValue.setValue(d, unit);
        } else {
            LogRecord logRecord = new LogRecord(Level.FINE, Errors.format(214, string));
            logRecord.setSourceClassName(Parameters.class.getName());
            logRecord.setSourceMethodName("ensureSet");
            Logging.log(Parameters.class, logRecord);
        }
        return true;
    }
}

