/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.DefaultAuthorityFactory;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.IdentityTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class CRS {
    private static volatile CRSFactory crsFactory;
    private static volatile CRSAuthorityFactory standardFactory;
    private static volatile CRSAuthorityFactory xyFactory;
    private static volatile CoordinateOperationFactory strictFactory;
    private static volatile CoordinateOperationFactory lenientFactory;
    private static volatile Boolean defaultOrder;
    private static volatile Boolean defaultLenient;

    private CRS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CRSFactory getCRSFactory() {
        CRSFactory cRSFactory = crsFactory;
        if (cRSFactory != null) return cRSFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            cRSFactory = crsFactory;
            if (cRSFactory != null) return cRSFactory;
            crsFactory = cRSFactory = FactoryFinder.getCRSFactory(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cRSFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRSAuthorityFactory getAuthorityFactory(Boolean bl) throws FactoryRegistryException {
        CRSAuthorityFactory cRSAuthorityFactory;
        if (bl == null && (bl = defaultOrder) == null) {
            defaultOrder = bl = Boolean.valueOf(Boolean.TRUE.equals(Hints.getSystemDefault(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER)));
        }
        CRSAuthorityFactory cRSAuthorityFactory2 = cRSAuthorityFactory = bl != false ? xyFactory : standardFactory;
        if (cRSAuthorityFactory != null) return cRSAuthorityFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CRSAuthorityFactory cRSAuthorityFactory3 = cRSAuthorityFactory = bl != false ? xyFactory : standardFactory;
            if (cRSAuthorityFactory != null) return cRSAuthorityFactory;
            try {
                cRSAuthorityFactory = DefaultAuthorityFactory.create(bl);
                if (bl.booleanValue()) {
                    xyFactory = cRSAuthorityFactory;
                } else {
                    standardFactory = cRSAuthorityFactory;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new FactoryNotFoundException(null, noSuchElementException);
            }
            return cRSAuthorityFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CoordinateOperationFactory getCoordinateOperationFactory(boolean bl) {
        CoordinateOperationFactory coordinateOperationFactory;
        CoordinateOperationFactory coordinateOperationFactory2 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
        if (coordinateOperationFactory != null) return coordinateOperationFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CoordinateOperationFactory coordinateOperationFactory3 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
            if (coordinateOperationFactory != null) return coordinateOperationFactory;
            Hints hints = new Hints();
            if (bl) {
                hints.put(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
            }
            coordinateOperationFactory = FactoryFinder.getCoordinateOperationFactory(hints);
            if (bl) {
                lenientFactory = coordinateOperationFactory;
            } else {
                strictFactory = coordinateOperationFactory;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return coordinateOperationFactory;
        }
    }

    public static Version getVersion(String string) throws FactoryRegistryException {
        Factory factory;
        CRSAuthorityFactory cRSAuthorityFactory = AuthorityFactoryFinder.getCRSAuthorityFactory(string, null);
        HashSet<Factory> hashSet = new HashSet<Factory>();
        while (cRSAuthorityFactory instanceof Factory && hashSet.add(factory = (Factory)((Object)cRSAuthorityFactory))) {
            Map<RenderingHints.Key, ?> map = factory.getImplementationHints();
            Object obj = map.get(Hints.VERSION);
            if (obj instanceof Version) {
                return (Version)obj;
            }
            cRSAuthorityFactory = map.get(Hints.CRS_AUTHORITY_FACTORY);
        }
        return null;
    }

    public static Set<String> getSupportedCodes(String string) {
        return DefaultAuthorityFactory.getSupportedCodes(string);
    }

    public static Set<String> getSupportedAuthorities(boolean bl) {
        return DefaultAuthorityFactory.getSupportedAuthorities(bl);
    }

    public static CoordinateReferenceSystem decode(String string) throws NoSuchAuthorityCodeException, FactoryException {
        string = string.trim();
        return CRS.getAuthorityFactory(null).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem decode(String string, boolean bl) throws NoSuchAuthorityCodeException, FactoryException {
        string = string.trim();
        return CRS.getAuthorityFactory(bl).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem parseWKT(String string) throws FactoryException {
        return CRS.getCRSFactory().createFromWKT(string);
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        Object object;
        Envelope envelope = null;
        GeneralEnvelope generalEnvelope = null;
        if (coordinateReferenceSystem != null && (object = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent object2 : object.getGeographicElements()) {
                if (Boolean.FALSE.equals(object2.getInclusion()) || !(object2 instanceof BoundingPolygon)) continue;
                for (Geometry geometry : ((BoundingPolygon)object2).getPolygons()) {
                    CoordinateReferenceSystem coordinateReferenceSystem2;
                    Envelope envelope2 = geometry.getEnvelope();
                    if (envelope2 == null || (coordinateReferenceSystem2 = envelope2.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) continue;
                    if (envelope == null) {
                        envelope = envelope2;
                        continue;
                    }
                    if (generalEnvelope == null) {
                        envelope = generalEnvelope = new GeneralEnvelope(envelope);
                    }
                    generalEnvelope.add(envelope);
                }
            }
        }
        if (envelope == null && (object = CRS.getGeographicBoundingBox(coordinateReferenceSystem)) != null && !Boolean.FALSE.equals(object.getInclusion())) {
            envelope = generalEnvelope = new GeneralEnvelope(new double[]{object.getWestBoundLongitude(), object.getSouthBoundLatitude()}, new double[]{object.getEastBoundLongitude(), object.getNorthBoundLatitude()});
            SingleCRS singleCRS = CRS.getHorizontalCRS(coordinateReferenceSystem);
            GeographicCRS geographicCRS = CRSUtilities.getStandardGeographicCRS2D(singleCRS);
            generalEnvelope.setCoordinateReferenceSystem(geographicCRS);
            try {
                envelope = CRS.transform(envelope, singleCRS);
            }
            catch (TransformException transformException) {
                envelope = null;
                CRS.unexpectedException("getEnvelope", transformException);
            }
            generalEnvelope.setCoordinateReferenceSystem(singleCRS);
        }
        return envelope;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem coordinateReferenceSystem) {
        Extent extent;
        GeographicBoundingBox geographicBoundingBox = null;
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        if (coordinateReferenceSystem != null && (extent = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox geographicBoundingBox2 = (GeographicBoundingBox)geographicExtent;
                if (geographicBoundingBox == null) {
                    geographicBoundingBox = geographicBoundingBox2;
                    continue;
                }
                if (defaultGeographicBoundingBox == null) {
                    defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox);
                    geographicBoundingBox = defaultGeographicBoundingBox;
                }
                defaultGeographicBoundingBox.add(geographicBoundingBox2);
            }
        }
        return geographicBoundingBox;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        IdentifiedObject identifiedObject;
        IdentifiedObject identifiedObject2;
        if (coordinateReferenceSystem instanceof SingleCRS) {
            IdentifiedObject identifiedObject3;
            identifiedObject2 = coordinateReferenceSystem.getCoordinateSystem();
            int n = identifiedObject2.getDimension();
            if (n == 2) {
                identifiedObject3 = coordinateReferenceSystem;
                while (identifiedObject3 instanceof GeneralDerivedCRS) {
                    identifiedObject3 = ((GeneralDerivedCRS)identifiedObject3).getBaseCRS();
                }
                if (identifiedObject3 instanceof GeographicCRS) {
                    return (SingleCRS)coordinateReferenceSystem;
                }
            } else if (n >= 3 && coordinateReferenceSystem instanceof GeographicCRS) {
                Object object;
                identifiedObject3 = null;
                identifiedObject = null;
                int n2 = 0;
                block9: for (int i = 0; i < n; ++i) {
                    object = identifiedObject2.getAxis(i);
                    if (!DefaultCoordinateSystemAxis.isCompassDirection(object.getDirection())) continue;
                    switch (n2++) {
                        case 0: {
                            identifiedObject3 = object;
                            continue block9;
                        }
                        case 1: {
                            identifiedObject = object;
                            continue block9;
                        }
                    }
                }
                if (n2 == 2) {
                    GeographicCRS geographicCRS;
                    EllipsoidalCS ellipsoidalCS;
                    GeodeticDatum geodeticDatum = ((GeographicCRS)coordinateReferenceSystem).getDatum();
                    object = CRSUtilities.changeDimensionInName(identifiedObject2, "3D", "2D");
                    try {
                        ellipsoidalCS = FactoryFinder.getCSFactory(null).createEllipsoidalCS((Map<String, ?>)object, (CoordinateSystemAxis)identifiedObject3, (CoordinateSystemAxis)identifiedObject);
                    }
                    catch (FactoryException factoryException) {
                        Logging.recoverableException(CRS.class, "getHorizontalCRS", factoryException);
                        ellipsoidalCS = new DefaultEllipsoidalCS((Map<String, ?>)object, (CoordinateSystemAxis)identifiedObject3, (CoordinateSystemAxis)identifiedObject);
                    }
                    object = CRSUtilities.changeDimensionInName(coordinateReferenceSystem, "3D", "2D");
                    try {
                        geographicCRS = CRS.getCRSFactory().createGeographicCRS((Map<String, ?>)object, geodeticDatum, ellipsoidalCS);
                    }
                    catch (FactoryException factoryException) {
                        Logging.recoverableException(CRS.class, "getHorizontalCRS", factoryException);
                        geographicCRS = new DefaultGeographicCRS((Map<String, ?>)object, geodeticDatum, ellipsoidalCS);
                    }
                    return geographicCRS;
                }
            }
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            identifiedObject2 = (CompoundCRS)coordinateReferenceSystem;
            for (IdentifiedObject identifiedObject3 : identifiedObject2.getComponents()) {
                identifiedObject = CRS.getHorizontalCRS(identifiedObject3);
                if (identifiedObject == null) continue;
                return identifiedObject;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            return (ProjectedCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                ProjectedCRS projectedCRS = CRS.getProjectedCRS(coordinateReferenceSystem2);
                if (projectedCRS == null) continue;
                return projectedCRS;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            return (VerticalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                VerticalCRS verticalCRS = CRS.getVerticalCRS(coordinateReferenceSystem2);
                if (verticalCRS == null) continue;
                return verticalCRS;
            }
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return (TemporalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                TemporalCRS temporalCRS = CRS.getTemporalCRS(coordinateReferenceSystem2);
                if (temporalCRS == null) continue;
                return temporalCRS;
            }
        }
        return null;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        Datum datum = CRSUtilities.getDatum(coordinateReferenceSystem);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                Ellipsoid ellipsoid = CRS.getEllipsoid(coordinateReferenceSystem2);
                if (ellipsoid == null) continue;
                return ellipsoid;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object instanceof AbstractIdentifiedObject && object2 instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).equals((AbstractIdentifiedObject)object2, false);
        }
        if (object2 instanceof MathTransform && object instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)object).equivalent((MathTransform)object2, false);
        }
        return object != null && object.equals(object2);
    }

    public static String toSRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem != null) {
            ReferenceIdentifier referenceIdentifier2 = null;
            Set<ReferenceIdentifier> set = coordinateReferenceSystem.getIdentifiers();
            if (set != null) {
                for (ReferenceIdentifier referenceIdentifier2 : set) {
                    if (referenceIdentifier2 != null) break;
                }
            }
            if (referenceIdentifier2 == null) {
                referenceIdentifier2 = coordinateReferenceSystem.getName();
            }
            if (referenceIdentifier2 != null) {
                return referenceIdentifier2.toString();
            }
        }
        return null;
    }

    public static String lookupIdentifier(IdentifiedObject identifiedObject, boolean bl) throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = (AbstractAuthorityFactory)((Object)CRS.getAuthorityFactory(true));
        IdentifiedObjectFinder identifiedObjectFinder = abstractAuthorityFactory.getIdentifiedObjectFinder(identifiedObject.getClass());
        identifiedObjectFinder.setFullScanAllowed(bl);
        return identifiedObjectFinder.findIdentifier(identifiedObject);
    }

    public static String lookupIdentifier(Citation citation, CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) throws FactoryException {
        ReferenceIdentifier referenceIdentifier = AbstractIdentifiedObject.getIdentifier(coordinateReferenceSystem, citation);
        if (referenceIdentifier != null) {
            return referenceIdentifier.getCode();
        }
        DefaultAuthorityFactory defaultAuthorityFactory = (DefaultAuthorityFactory)CRS.getAuthorityFactory(true);
        for (AuthorityFactory authorityFactory : defaultAuthorityFactory.backingStore.getFactories()) {
            if (!Citations.identifierMatches(authorityFactory.getAuthority(), citation) || !(authorityFactory instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory abstractAuthorityFactory = (AbstractAuthorityFactory)authorityFactory;
            IdentifiedObjectFinder identifiedObjectFinder = abstractAuthorityFactory.getIdentifiedObjectFinder(coordinateReferenceSystem.getClass());
            identifiedObjectFinder.setFullScanAllowed(bl);
            String string = identifiedObjectFinder.findIdentifier(coordinateReferenceSystem);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static Integer lookupEpsgCode(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) throws FactoryException {
        String string = CRS.lookupIdentifier(Citations.EPSG, coordinateReferenceSystem, bl);
        if (string != null) {
            int n = string.lastIndexOf(58);
            String string2 = string.substring(n + 1);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FactoryException(Errors.format(72, string), numberFormatException);
            }
        }
        return null;
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Boolean bl = defaultLenient;
        if (bl == null) {
            defaultLenient = bl = Boolean.valueOf(Boolean.TRUE.equals(Hints.getSystemDefault(Hints.LENIENT_DATUM_SHIFT)));
        }
        return CRS.findMathTransform(coordinateReferenceSystem, coordinateReferenceSystem2, bl);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            return IdentityTransform.create(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        }
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(bl);
        return coordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (envelope != null && coordinateReferenceSystem != null && (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != null) {
            if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) {
                CoordinateOperation coordinateOperation;
                CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(true);
                try {
                    coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem2, coordinateReferenceSystem);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(Errors.format(34), factoryException);
                }
                if (!coordinateOperation.getMathTransform().isIdentity()) {
                    envelope = CRS.transform(coordinateOperation, envelope);
                }
            }
            assert (CRS.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), coordinateReferenceSystem));
        }
        return envelope;
    }

    public static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope) throws TransformException {
        return CRS.transform(mathTransform, envelope, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope, GeneralDirectPosition generalDirectPosition) throws TransformException {
        if (envelope == null) {
            return null;
        }
        if (mathTransform.isIdentity()) {
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(envelope);
            generalEnvelope.setCoordinateReferenceSystem(null);
            if (generalDirectPosition != null) {
                int n = envelope.getDimension();
                while (--n >= 0) {
                    generalDirectPosition.setOrdinate(n, generalEnvelope.getMedian(n));
                }
            }
            return generalEnvelope;
        }
        int n = mathTransform.getSourceDimensions();
        if (envelope.getDimension() != n) {
            throw new MismatchedDimensionException(Errors.format(100, n, envelope.getDimension()));
        }
        int n2 = 0;
        GeneralEnvelope generalEnvelope = null;
        if (generalDirectPosition == null) {
            generalDirectPosition = new GeneralDirectPosition(mathTransform.getTargetDimensions());
        }
        GeneralDirectPosition generalDirectPosition2 = new GeneralDirectPosition(n);
        int n3 = n;
        while (--n3 >= 0) {
            generalDirectPosition2.setOrdinate(n3, envelope.getMinimum(n3));
        }
        block7: while (true) {
            if (generalDirectPosition != mathTransform.transform(generalDirectPosition2, generalDirectPosition)) {
                throw new UnsupportedImplementationException(mathTransform.getClass());
            }
            if (generalEnvelope != null) {
                generalEnvelope.add(generalDirectPosition);
            } else {
                generalEnvelope = new GeneralEnvelope(generalDirectPosition, generalDirectPosition);
            }
            n3 = ++n2;
            int n4 = n;
            block8: while (true) {
                if (--n4 < 0) {
                    return generalEnvelope;
                }
                switch (n3 % 3) {
                    case 0: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMinimum(n4));
                        n3 /= 3;
                        continue block8;
                    }
                    case 1: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMaximum(n4));
                        continue block7;
                    }
                    case 2: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMedian(n4));
                        continue block7;
                    }
                }
                break;
            }
            break;
        }
        throw new AssertionError(n3);
    }

    public static GeneralEnvelope transform(CoordinateOperation coordinateOperation, Envelope envelope) throws TransformException {
        Object object;
        Object object2;
        IdentifiedObject identifiedObject;
        Object object3;
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem != null && (object3 = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(object3, coordinateReferenceSystem)) {
            throw new MismatchedReferenceSystemException(Errors.format(99));
        }
        object3 = coordinateOperation.getMathTransform();
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(object3.getTargetDimensions());
        GeneralEnvelope generalEnvelope = CRS.transform((MathTransform)object3, envelope, generalDirectPosition);
        if (coordinateReferenceSystem != null && (identifiedObject = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            object2 = null;
            object = null;
            int n = identifiedObject.getDimension();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                CoordinateSystemAxis coordinateSystemAxis = identifiedObject.getAxis(i);
                if (coordinateSystemAxis == null) continue;
                double d = envelope.getMinimum(i);
                double d2 = envelope.getMaximum(i);
                double d3 = coordinateSystemAxis.getMinimumValue();
                double d4 = coordinateSystemAxis.getMaximumValue();
                boolean bl2 = d3 > d && d3 < d2;
                boolean bl3 = bl = d4 > d && d4 < d2;
                if (!bl2 && !bl) continue;
                if (object2 == null) {
                    object2 = new GeneralDirectPosition(n);
                    for (int j = 0; j < n; ++j) {
                        object2.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (bl2) {
                    object2.setOrdinate(i, d3);
                    object = object3.transform((DirectPosition)object2, (DirectPosition)object);
                    generalEnvelope.add((DirectPosition)object);
                }
                if (bl) {
                    object2.setOrdinate(i, d4);
                    object = object3.transform((DirectPosition)object2, (DirectPosition)object);
                    generalEnvelope.add((DirectPosition)object);
                }
                object2.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((identifiedObject = coordinateOperation.getTargetCRS()) == null) {
            return generalEnvelope;
        }
        generalEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)identifiedObject);
        object2 = identifiedObject.getCoordinateSystem();
        if (object2 == null) {
            return generalEnvelope;
        }
        object = null;
        DirectPosition directPosition = null;
        DirectPosition directPosition2 = null;
        int n = object2.getDimension();
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = object2.getAxis(i);
            if (coordinateSystemAxis == null) continue;
            boolean bl = false;
            do {
                double d;
                double d5 = d = bl ? coordinateSystemAxis.getMaximumValue() : coordinateSystemAxis.getMinimumValue();
                if (Double.isInfinite(d) || Double.isNaN(d)) continue;
                if (directPosition2 == null) {
                    try {
                        object3 = object3.inverse();
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        if (n >= object3.getSourceDimensions()) {
                            CRS.unexpectedException("transform", noninvertibleTransformException);
                        }
                        return generalEnvelope;
                    }
                    directPosition2 = new GeneralDirectPosition(object3.getSourceDimensions());
                    for (int j = 0; j < n; ++j) {
                        directPosition2.setOrdinate(j, generalDirectPosition.getOrdinate(j));
                    }
                    object = envelope instanceof GeneralEnvelope ? (GeneralEnvelope)envelope : new GeneralEnvelope(envelope);
                }
                directPosition2.setOrdinate(i, d);
                try {
                    directPosition = object3.transform(directPosition2, directPosition);
                }
                catch (TransformException transformException) {
                    continue;
                }
                if (!((GeneralEnvelope)object).contains(directPosition)) continue;
                generalEnvelope.add(directPosition2);
            } while (bl = !bl);
            if (directPosition2 == null) continue;
            directPosition2.setOrdinate(i, generalDirectPosition.getOrdinate(i));
        }
        return generalEnvelope;
    }

    public static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        return CRS.transform(mathTransform2D, rectangle2D, rectangle2D2, new Point2D.Double());
    }

    private static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Point2D.Double double_) throws TransformException {
        if (rectangle2D == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= 8; ++i) {
            double_.x = (i & 1) == 0 ? rectangle2D.getMinX() : rectangle2D.getMaxX();
            double_.y = (i & 2) == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    double_.x = rectangle2D.getCenterX();
                    break;
                }
                case 8: {
                    double_.x = rectangle2D.getCenterX();
                }
                case 4: 
                case 7: {
                    double_.y = rectangle2D.getCenterY();
                }
            }
            if (double_ != mathTransform2D.transform(double_, double_)) {
                throw new UnsupportedImplementationException(mathTransform2D.getClass());
            }
            if (double_.x < d) {
                d = double_.x;
            }
            if (double_.x > d3) {
                d3 = double_.x;
            }
            if (double_.y < d2) {
                d2 = double_.y;
            }
            if (!(double_.y > d4)) continue;
            d4 = double_.y;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
        } else {
            rectangle2D2 = XRectangle2D.createFromExtremums(d, d2, d3, d4);
        }
        assert (rectangle2D2 == rectangle2D || !(rectangle2D2 instanceof Rectangle2D.Double) && !(rectangle2D2 instanceof Rectangle2D.Float) || XRectangle2D.equalsEpsilon(rectangle2D2, CRS.transform(mathTransform2D, (Envelope)new Envelope2D(null, rectangle2D)).toRectangle2D())) : rectangle2D2;
        return rectangle2D2;
    }

    public static Rectangle2D transform(CoordinateOperation coordinateOperation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        Object object;
        IdentifiedObject identifiedObject;
        IdentifiedObject identifiedObject2;
        if (rectangle2D == null) {
            return null;
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        if (!(mathTransform instanceof MathTransform2D)) {
            throw new MismatchedDimensionException(Errors.format(148));
        }
        MathTransform2D mathTransform2D = (MathTransform2D)mathTransform;
        Point2D.Double double_ = new Point2D.Double();
        rectangle2D2 = CRS.transform(mathTransform2D, rectangle2D, rectangle2D2, double_);
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem != null && (identifiedObject2 = coordinateReferenceSystem.getCoordinateSystem()) != null && identifiedObject2.getDimension() == 2) {
            identifiedObject = identifiedObject2.getAxis(0);
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMaxX();
            object = null;
            for (int i = 0; i < 4; ++i) {
                double d3;
                if (i == 2) {
                    identifiedObject = identifiedObject2.getAxis(1);
                    d = rectangle2D.getMinY();
                    d2 = rectangle2D.getMaxY();
                }
                double d4 = d3 = (i & 1) == 0 ? identifiedObject.getMinimumValue() : identifiedObject.getMaximumValue();
                if (!(d3 > d) || !(d3 < d2)) continue;
                if (object == null) {
                    object = new Point2D.Double();
                }
                if ((i & 2) == 0) {
                    ((Point2D.Double)object).x = d3;
                    ((Point2D.Double)object).y = rectangle2D.getCenterY();
                } else {
                    ((Point2D.Double)object).x = rectangle2D.getCenterX();
                    ((Point2D.Double)object).y = d3;
                }
                rectangle2D2.add(mathTransform2D.transform((Point2D)object, (Point2D)object));
            }
        }
        if ((identifiedObject2 = coordinateOperation.getTargetCRS()) == null) {
            return rectangle2D2;
        }
        identifiedObject = identifiedObject2.getCoordinateSystem();
        if (identifiedObject == null || identifiedObject.getDimension() != 2) {
            return rectangle2D2;
        }
        Point2D point2D = null;
        Point2D point2D2 = null;
        for (int i = 0; i < 4; ++i) {
            double d;
            int n = i >> 1;
            object = identifiedObject.getAxis(n);
            if (object == null) continue;
            double d5 = d = (i & 1) == 0 ? object.getMinimumValue() : object.getMaximumValue();
            if (Double.isInfinite(d) || Double.isNaN(d)) continue;
            if (point2D2 == null) {
                try {
                    mathTransform2D = mathTransform2D.inverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    CRS.unexpectedException("transform", noninvertibleTransformException);
                    return rectangle2D2;
                }
                point2D2 = new Point2D.Double();
            }
            switch (n) {
                case 0: {
                    point2D2.setLocation(d, double_.y);
                    break;
                }
                case 1: {
                    point2D2.setLocation(double_.x, d);
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
            try {
                point2D = mathTransform2D.transform(point2D2, point2D);
            }
            catch (TransformException transformException) {
                continue;
            }
            if (!rectangle2D.contains(point2D)) continue;
            rectangle2D2.add(point2D2);
        }
        assert (rectangle2D2 == rectangle2D || XRectangle2D.equalsEpsilon(rectangle2D2, CRS.transform(coordinateOperation, (Envelope)new GeneralEnvelope(rectangle2D)).toRectangle2D())) : rectangle2D2;
        return rectangle2D2;
    }

    static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException(CRS.class, string, exception);
    }

    public static synchronized void reset(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            boolean bl = string2.equalsIgnoreCase("all");
            if (bl || string2.equalsIgnoreCase("plugins")) {
                AuthorityFactoryFinder.scanForPlugins();
            }
            if (!bl && !string2.equalsIgnoreCase("warnings")) continue;
            UnitaryProjection.resetWarnings();
        }
    }

    static {
        Factories.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    crsFactory = null;
                    standardFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    defaultOrder = null;
                    defaultLenient = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

