/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.spi.ServiceRegistry;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.factory.AllAuthoritiesFactory;
import org.geotoolkit.referencing.factory.CachingAuthorityFactory;
import org.geotoolkit.referencing.factory.MultiAuthoritiesFactory;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class DefaultAuthorityFactory
extends CachingAuthorityFactory
implements CRSAuthorityFactory {
    private static List<String> AUTHORITY_LESS = UnmodifiableArrayList.wrap(new String[]{"WGS84(DD)"});
    final MultiAuthoritiesFactory backingStore;

    private DefaultAuthorityFactory(MultiAuthoritiesFactory multiAuthoritiesFactory) {
        super(multiAuthoritiesFactory);
        this.backingStore = multiAuthoritiesFactory;
    }

    static DefaultAuthorityFactory create(boolean bl) {
        ArrayList<CRSAuthorityFactory> arrayList = new ArrayList<CRSAuthorityFactory>(AuthorityFactoryFinder.getCRSAuthorityFactories(EMPTY_HINTS));
        Filter filter = new Filter();
        Hints hints = new Hints(AuthorityFactoryFinder.FILTER_KEY, filter, Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, bl);
        int n = arrayList.size();
        while (--n >= 0) {
            CRSAuthorityFactory cRSAuthorityFactory = (CRSAuthorityFactory)arrayList.get(n);
            String string = Citations.getIdentifier(cRSAuthorityFactory.getAuthority());
            filter.type = cRSAuthorityFactory.getClass();
            hints.put(Hints.CRS_AUTHORITY_FACTORY, filter.type);
            try {
                cRSAuthorityFactory = AuthorityFactoryFinder.getCRSAuthorityFactory(string, hints);
            }
            catch (FactoryRegistryException factoryRegistryException) {
                Logging.recoverableException(LOGGER, DefaultAuthorityFactory.class, "create", factoryRegistryException);
                arrayList.remove(n);
                continue;
            }
            CRSAuthorityFactory cRSAuthorityFactory2 = arrayList.set(n, cRSAuthorityFactory);
            if (cRSAuthorityFactory2 == cRSAuthorityFactory) continue;
            LogRecord logRecord = Loggings.format(Level.FINE, 26, string, cRSAuthorityFactory.getClass(), cRSAuthorityFactory2.getClass(), bl ? 1 : 0);
            logRecord.setSourceClassName(DefaultAuthorityFactory.class.getName());
            logRecord.setSourceMethodName("create");
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
        hints.clear();
        hints.put(AllAuthoritiesFactory.USER_FACTORIES_KEY, arrayList);
        hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)bl);
        return new DefaultAuthorityFactory(AllAuthoritiesFactory.getInstance(hints));
    }

    static Set<String> getSupportedCodes(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(AUTHORITY_LESS);
        for (CRSAuthorityFactory cRSAuthorityFactory : AuthorityFactoryFinder.getCRSAuthorityFactories(null)) {
            Set<String> set;
            if (!Citations.identifierMatches(cRSAuthorityFactory.getAuthority(), string)) continue;
            try {
                set = cRSAuthorityFactory.getAuthorityCodes(CoordinateReferenceSystem.class);
            }
            catch (Exception exception) {
                CRS.unexpectedException("getSupportedCodes", exception);
                continue;
            }
            if (set == null) continue;
            linkedHashSet.addAll(set);
        }
        return linkedHashSet;
    }

    static Set<String> getSupportedAuthorities(boolean bl) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        block0: for (CRSAuthorityFactory cRSAuthorityFactory : AuthorityFactoryFinder.getCRSAuthorityFactories(null)) {
            for (Identifier identifier : cRSAuthorityFactory.getAuthority().getIdentifiers()) {
                linkedHashSet.add(identifier.getCode());
                if (bl) continue;
                continue block0;
            }
        }
        return linkedHashSet;
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        if (string != null && (string = string.trim()).equalsIgnoreCase("WGS84(DD)")) {
            return DefaultGeographicCRS.WGS84;
        }
        assert (!AUTHORITY_LESS.contains(string)) : string;
        return super.createCoordinateReferenceSystem(string);
    }

    private static final class Filter
    implements ServiceRegistry.Filter {
        Class<?> type;

        private Filter() {
        }

        @Override
        public boolean filter(Object object) {
            return object.getClass().equals(this.type);
        }
    }
}

