/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.internal.jaxb.metadata.CitationAdapter;
import org.geotoolkit.internal.jaxb.metadata.ReferenceSystemMetadata;
import org.geotoolkit.internal.jaxb.text.AnchoredStringAdapter;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.DefaultInternationalString;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

@XmlRootElement(name="RS_Identifier", namespace="http://www.isotc211.org/2005/gmd")
public class DefaultReferenceIdentifier
implements ReferenceIdentifier,
Serializable {
    private static final long serialVersionUID = -7515516481965979199L;
    @XmlElement(required=true, namespace="http://www.isotc211.org/2005/gmd")
    @XmlJavaTypeAdapter(value=AnchoredStringAdapter.class)
    final String code;
    @XmlElement(required=true, namespace="http://www.isotc211.org/2005/gmd")
    @XmlJavaTypeAdapter(value=AnchoredStringAdapter.class)
    final String codespace;
    @XmlElement(required=true, namespace="http://www.isotc211.org/2005/gmd")
    @XmlJavaTypeAdapter(value=CitationAdapter.class)
    final Citation authority;
    private final String version;
    private final InternationalString remarks;

    private DefaultReferenceIdentifier() {
        this.code = null;
        this.codespace = null;
        this.authority = null;
        this.version = null;
        this.remarks = null;
    }

    public DefaultReferenceIdentifier(ReferenceIdentifier referenceIdentifier) {
        DefaultReferenceIdentifier.ensureNonNull("identifier", referenceIdentifier);
        this.code = referenceIdentifier.getCode();
        this.codespace = referenceIdentifier.getCodeSpace();
        this.authority = referenceIdentifier.getAuthority();
        this.version = referenceIdentifier.getVersion();
        if (referenceIdentifier instanceof DefaultReferenceIdentifier) {
            DefaultReferenceIdentifier defaultReferenceIdentifier = (DefaultReferenceIdentifier)referenceIdentifier;
            this.remarks = defaultReferenceIdentifier.getRemarks();
        } else {
            this.remarks = null;
        }
    }

    public DefaultReferenceIdentifier(Citation citation, String string, String string2) {
        this(citation, string, string2, null, null);
    }

    public DefaultReferenceIdentifier(Citation citation, String string, String string2, String string3, InternationalString internationalString) {
        DefaultReferenceIdentifier.ensureNonNull("code", string2);
        this.code = string2;
        this.codespace = string;
        this.authority = citation;
        this.version = string3;
        this.remarks = internationalString;
    }

    public DefaultReferenceIdentifier(Map<String, ?> map) throws IllegalArgumentException {
        this(map, true);
    }

    DefaultReferenceIdentifier(Map<String, ?> map, boolean bl) throws IllegalArgumentException {
        DefaultReferenceIdentifier.ensureNonNull("properties", map);
        Object object = null;
        String string = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        DefaultInternationalString defaultInternationalString = null;
        String string2 = null;
        Object object5 = null;
        block10: for (Map.Entry<String, ?> object6 : map.entrySet()) {
            string2 = object6.getKey().trim().toLowerCase();
            object5 = object6.getValue();
            switch (string2.hashCode()) {
                case 3373707: {
                    if (bl || !string2.equals("name")) break;
                    object = object5;
                    continue block10;
                }
                case 3059181: {
                    if (!string2.equals("code")) break;
                    object = object5;
                    continue block10;
                }
                case -1108676807: {
                    if (!string2.equals("codespace")) break;
                    string = object5;
                    continue block10;
                }
                case 351608024: {
                    if (!string2.equals("version")) break;
                    object2 = object5;
                    continue block10;
                }
                case 1475610435: {
                    if (!string2.equals("authority")) break;
                    if (object5 instanceof String) {
                        object5 = Citations.fromName(object5.toString());
                    }
                    object3 = object5;
                    continue block10;
                }
                case 1091415283: {
                    if (!bl || !string2.equals("remarks") || !(object5 instanceof InternationalString)) break;
                    object4 = object5;
                    continue block10;
                }
            }
            if (!bl || !(object5 instanceof String)) continue;
            if (defaultInternationalString == null) {
                defaultInternationalString = object4 instanceof DefaultInternationalString ? (DefaultInternationalString)object4 : new DefaultInternationalString();
            }
            defaultInternationalString.add("remarks", string2, object5.toString());
        }
        if (defaultInternationalString != null && !defaultInternationalString.getLocales().isEmpty()) {
            if (object4 == null) {
                object4 = defaultInternationalString;
            } else {
                Logging.log(DefaultReferenceIdentifier.class, Loggings.format(Level.WARNING, 33));
            }
        }
        if (string == null && object3 instanceof Citation) {
            string = DefaultReferenceIdentifier.getCodeSpace((Citation)object3);
        }
        try {
            string2 = "code";
            object5 = object;
            this.code = (String)object5;
            string2 = "version";
            object5 = object2;
            this.version = (String)object5;
            string2 = "codespace";
            object5 = string;
            this.codespace = object5;
            string2 = "authority";
            object5 = object3;
            this.authority = (Citation)object5;
            string2 = "remarks";
            object5 = object4;
            this.remarks = (InternationalString)object5;
        }
        catch (ClassCastException classCastException) {
            InvalidParameterValueException invalidParameterValueException = new InvalidParameterValueException(Errors.format(63, string2, object5), string2, object5);
            invalidParameterValueException.initCause(classCastException);
            throw invalidParameterValueException;
        }
        DefaultReferenceIdentifier.ensureNonNull("code", object);
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    static InternationalString getShortestTitle(Citation citation) {
        InternationalString internationalString = citation.getTitle();
        int n = internationalString.length();
        Collection<? extends InternationalString> collection = citation.getAlternateTitles();
        if (collection != null) {
            for (InternationalString internationalString2 : collection) {
                int n2 = internationalString2.length();
                if (n2 <= 0 || n2 >= n) continue;
                internationalString = internationalString2;
                n = n2;
            }
        }
        return internationalString;
    }

    private static String getCodeSpace(Citation citation) {
        Object object;
        Collection<? extends Identifier> collection = citation.getIdentifiers();
        if (collection != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Identifier identifier = (Identifier)object.next();
                String string = identifier.getCode();
                if (!DefaultReferenceIdentifier.isValidCodeSpace(string)) continue;
                return string;
            }
        }
        if (DefaultReferenceIdentifier.isValidCodeSpace((String)(object = DefaultReferenceIdentifier.getShortestTitle(citation).toString(null)))) {
            return object;
        }
        return null;
    }

    private static boolean isValidCodeSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        while (--n >= 0) {
            if (Character.isJavaIdentifierPart(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getCodeSpace() {
        return this.codespace;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    public boolean isDeprecated() {
        return false;
    }

    public int hashCode() {
        int n = 483592641;
        if (this.code != null) {
            n ^= this.code.hashCode();
        }
        if (this.codespace != null) {
            n = n * 31 + this.codespace.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            DefaultReferenceIdentifier defaultReferenceIdentifier = (DefaultReferenceIdentifier)object;
            return Utilities.equals(this.code, defaultReferenceIdentifier.code) && Utilities.equals(this.codespace, defaultReferenceIdentifier.codespace) && Utilities.equals(this.authority, defaultReferenceIdentifier.authority) && Utilities.equals(this.version, defaultReferenceIdentifier.version) && Utilities.equals(this.remarks, defaultReferenceIdentifier.remarks);
        }
        return false;
    }

    public String toString() {
        return ReferenceSystemMetadata.toString("IDENTIFIER", this.authority, this.codespace, this.code);
    }
}

