/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperation;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.CoordinateOperation;

final class Properties
extends AbstractMap<String, Object> {
    private final IdentifiedObject info;
    private transient Set<Map.Entry<String, Object>> entries;
    private static final String[] KEYS = new String[]{"name", "identifiers", "alias", "remarks", "scope", "domainOfValidity", "operationVersion", "coordinateOperationAccuracy"};

    public Properties(IdentifiedObject identifiedObject) {
        this.info = identifiedObject;
        AbstractIdentifiedObject.ensureNonNull("info", identifiedObject);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public Object get(Object object) {
        if (object instanceof String) {
            String string = ((String)object).trim();
            for (int i = 0; i < KEYS.length; ++i) {
                if (!KEYS[i].equalsIgnoreCase(string)) continue;
                return this.get(i);
            }
        }
        return null;
    }

    private Object get(int n) {
        switch (n) {
            case 0: {
                return this.info.getName();
            }
            case 1: {
                return this.info.getIdentifiers().toArray(AbstractIdentifiedObject.EMPTY_IDENTIFIER_ARRAY);
            }
            case 2: {
                return this.info.getAlias().toArray(AbstractIdentifiedObject.EMPTY_ALIAS_ARRAY);
            }
            case 3: {
                return this.info.getRemarks();
            }
            case 4: {
                if (this.info instanceof ReferenceSystem) {
                    return ((ReferenceSystem)this.info).getScope();
                }
                if (this.info instanceof Datum) {
                    return ((Datum)this.info).getScope();
                }
                if (!(this.info instanceof CoordinateOperation)) break;
                return ((CoordinateOperation)this.info).getScope();
            }
            case 5: {
                if (this.info instanceof ReferenceSystem) {
                    return ((ReferenceSystem)this.info).getDomainOfValidity();
                }
                if (this.info instanceof Datum) {
                    return ((Datum)this.info).getDomainOfValidity();
                }
                if (!(this.info instanceof CoordinateOperation)) break;
                return ((CoordinateOperation)this.info).getDomainOfValidity();
            }
            case 6: {
                if (!(this.info instanceof CoordinateOperation)) break;
                return ((CoordinateOperation)this.info).getOperationVersion();
            }
            case 7: {
                if (!(this.info instanceof CoordinateOperation)) break;
                return ((CoordinateOperation)this.info).getCoordinateOperationAccuracy().toArray(AbstractCoordinateOperation.EMPTY_ACCURACY_ARRAY);
            }
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entries == null) {
            this.entries = new HashSet<Map.Entry<String, Object>>(Utilities.hashMapCapacity(KEYS.length));
            for (int i = 0; i < KEYS.length; ++i) {
                Object object = this.get(i);
                if (object == null) continue;
                this.entries.add(new AbstractMap.SimpleEntry<String, Object>(KEYS[i], object));
            }
            this.entries = Collections.unmodifiableSet(this.entries);
        }
        return this.entries;
    }
}

