/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.internal.jaxb.text.StringConverter;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.AbstractReferenceSystem;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.InternationalString;

public abstract class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    private CoordinateSystem coordinateSystem;

    @XmlID
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml", required=true)
    @XmlJavaTypeAdapter(value=StringConverter.class)
    final String getID() {
        return "coordinate-reference-system";
    }

    private AbstractCRS() {
        this(NullReferencingObject.INSTANCE);
    }

    public AbstractCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        super(coordinateReferenceSystem);
        this.coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
    }

    public AbstractCRS(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        super(map);
        AbstractCRS.ensureNonNull("cs", coordinateSystem);
        this.coordinateSystem = coordinateSystem;
    }

    static Map<String, ?> name(int n) {
        HashMap<String, CharSequence> hashMap = new HashMap<String, CharSequence>(4);
        InternationalString internationalString = Vocabulary.formatInternational(n);
        hashMap.put("name", ((Object)internationalString).toString());
        hashMap.put("alias", internationalString);
        return hashMap;
    }

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        if (this.coordinateSystem != NullReferencingObject.INSTANCE) {
            throw new IllegalStateException();
        }
        AbstractCRS.ensureNonNull("cs", coordinateSystem);
        this.coordinateSystem = coordinateSystem;
    }

    final Unit<?> getUnit() {
        return CRSUtilities.getUnit(this.coordinateSystem);
    }

    public Measure distance(double[] dArray, double[] dArray2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (this.coordinateSystem instanceof AbstractCS) {
            return ((AbstractCS)this.coordinateSystem).distance(dArray, dArray2);
        }
        throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (super.equals(abstractIdentifiedObject, bl)) {
            AbstractCRS abstractCRS = (AbstractCRS)abstractIdentifiedObject;
            return AbstractCRS.equals(this.coordinateSystem, abstractCRS.coordinateSystem, bl);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x3D90441 ^ this.coordinateSystem.hashCode();
    }

    @Override
    public String formatWKT(Formatter formatter) {
        this.formatDefaultWKT(formatter);
        return super.formatWKT(formatter);
    }

    void formatDefaultWKT(Formatter formatter) {
        Unit<?> unit = this.getUnit();
        formatter.append(unit);
        int n = this.coordinateSystem.getDimension();
        for (int i = 0; i < n; ++i) {
            formatter.append(this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(CoordinateReferenceSystem.class);
        }
    }
}

