/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.Map;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.internal.referencing.Semaphores;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.crs.AbstractSingleCRS;
import org.geotoolkit.referencing.crs.UnprefixedMap;
import org.geotoolkit.referencing.operation.DefaultConversion;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.DefaultSingleOperation;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Projection;

public class AbstractDerivedCRS
extends AbstractSingleCRS
implements GeneralDerivedCRS {
    private static final long serialVersionUID = -175151161496419854L;
    public static final String CONVERSION_TYPE_KEY = "conversionType";
    protected final CoordinateReferenceSystem baseCRS;
    protected final Conversion conversionFromBase;

    private AbstractDerivedCRS() {
        this(NullReferencingObject.INSTANCE);
    }

    protected AbstractDerivedCRS(GeneralDerivedCRS generalDerivedCRS) {
        super(generalDerivedCRS);
        this.baseCRS = generalDerivedCRS.getBaseCRS();
        this.conversionFromBase = generalDerivedCRS.getConversionFromBase();
    }

    protected AbstractDerivedCRS(Map<String, ?> map, Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, AbstractDerivedCRS.getDatum(coordinateReferenceSystem), coordinateSystem);
        AbstractDerivedCRS.ensureNonNull("conversionFromBase", conversion);
        AbstractDerivedCRS.ensureNonNull("baseToDerived", mathTransform);
        this.baseCRS = coordinateReferenceSystem;
        AbstractDerivedCRS.checkDimensions(coordinateReferenceSystem, mathTransform, coordinateSystem);
        DefaultOperationMethod.checkDimensions(conversion.getMethod(), mathTransform);
        Class clazz = (Class)map.get(CONVERSION_TYPE_KEY);
        Class<? extends Conversion> clazz2 = this.getConversionType();
        if (clazz != null) {
            clazz2 = clazz.asSubclass(clazz2);
        }
        this.conversionFromBase = DefaultConversion.create(conversion, coordinateReferenceSystem, this, mathTransform, clazz2);
    }

    protected AbstractDerivedCRS(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, AbstractDerivedCRS.getDatum(coordinateReferenceSystem), coordinateSystem);
        AbstractDerivedCRS.ensureNonNull("baseToDerived", mathTransform);
        this.baseCRS = coordinateReferenceSystem;
        AbstractDerivedCRS.checkDimensions(coordinateReferenceSystem, mathTransform, coordinateSystem);
        DefaultOperationMethod defaultOperationMethod = new DefaultOperationMethod(mathTransform);
        DefaultOperationMethod.checkDimensions(defaultOperationMethod, mathTransform);
        this.conversionFromBase = (Conversion)DefaultSingleOperation.create(new UnprefixedMap(map, "conversion."), coordinateReferenceSystem, this, mathTransform, defaultOperationMethod, this instanceof ProjectedCRS ? Projection.class : Conversion.class);
    }

    private static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        AbstractDerivedCRS.ensureNonNull("base", coordinateReferenceSystem);
        return coordinateReferenceSystem instanceof SingleCRS ? ((SingleCRS)coordinateReferenceSystem).getDatum() : null;
    }

    private static void checkDimensions(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        int n3 = n;
        int n4 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n3 != n4 || (n3 = n2) != (n4 = coordinateSystem.getDimension())) {
            throw new MismatchedDimensionException(Errors.format(100, n3, n4));
        }
    }

    @Override
    public CoordinateReferenceSystem getBaseCRS() {
        return this.baseCRS;
    }

    @Override
    public Conversion getConversionFromBase() {
        return this.conversionFromBase;
    }

    Class<? extends Conversion> getConversionType() {
        return Conversion.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            AbstractDerivedCRS abstractDerivedCRS = (AbstractDerivedCRS)abstractIdentifiedObject;
            if (AbstractDerivedCRS.equals(this.baseCRS, abstractDerivedCRS.baseCRS, bl)) {
                if (Semaphores.queryAndSet(1)) {
                    return true;
                }
                try {
                    boolean bl2 = AbstractDerivedCRS.equals(this.conversionFromBase, abstractDerivedCRS.conversionFromBase, bl);
                    return bl2;
                }
                finally {
                    Semaphores.clear(1);
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x550241F2 ^ this.baseCRS.hashCode() ^ this.conversionFromBase.getName().hashCode();
    }

    @Override
    public String formatWKT(Formatter formatter) {
        MathTransform mathTransform = this.conversionFromBase.getMathTransform();
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalStateException(noninvertibleTransformException.getLocalizedMessage(), noninvertibleTransformException);
        }
        formatter.append(mathTransform);
        formatter.append(this.baseCRS);
        return "FITTED_CS";
    }
}

