/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.crs.AbstractCRS;
import org.geotoolkit.referencing.cs.DefaultCompoundCS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.CheckedCollection;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;

public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929286L;
    private final List<? extends CoordinateReferenceSystem> crs;
    private transient List<SingleCRS> singles;

    private DefaultCompoundCRS() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultCompoundCRS(CompoundCRS compoundCRS) {
        super(compoundCRS);
        if (compoundCRS instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)compoundCRS;
            this.crs = defaultCompoundCRS.crs;
            this.singles = defaultCompoundCRS.singles;
        } else {
            this.crs = this.copy(compoundCRS.getComponents());
        }
    }

    public DefaultCompoundCRS(String string, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        this(string, new CoordinateReferenceSystem[]{coordinateReferenceSystem, coordinateReferenceSystem2});
    }

    public DefaultCompoundCRS(String string, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3) {
        this(string, new CoordinateReferenceSystem[]{coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3});
    }

    public DefaultCompoundCRS(String string, CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        this(Collections.singletonMap("name", string), coordinateReferenceSystemArray);
    }

    public DefaultCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        super(map, DefaultCompoundCRS.createCoordinateSystem(coordinateReferenceSystemArray));
        this.crs = this.copy(Arrays.asList(coordinateReferenceSystemArray));
    }

    private static CoordinateSystem createCoordinateSystem(CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        DefaultCompoundCRS.ensureNonNull("crs", coordinateReferenceSystemArray);
        if (coordinateReferenceSystemArray.length < 2) {
            throw new IllegalArgumentException(Errors.format(106, "crs[" + coordinateReferenceSystemArray.length + ']'));
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[coordinateReferenceSystemArray.length];
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            DefaultCompoundCRS.ensureNonNull("crs", coordinateReferenceSystemArray, i);
            coordinateSystemArray[i] = coordinateReferenceSystemArray[i].getCoordinateSystem();
        }
        return new DefaultCompoundCS(coordinateSystemArray);
    }

    private List<? extends CoordinateReferenceSystem> copy(List<? extends CoordinateReferenceSystem> list) {
        list = this.computeSingleCRS(list) ? this.singles : UnmodifiableArrayList.wrap(list.toArray(new CoordinateReferenceSystem[list.size()]));
        return list;
    }

    @Override
    public List<CoordinateReferenceSystem> getComponents() {
        return this.crs;
    }

    public List<SingleCRS> getSingleCRS() {
        return this.singles;
    }

    public static List<SingleCRS> getSingleCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<SingleCRS> list;
        if (coordinateReferenceSystem instanceof DefaultCompoundCRS) {
            list = ((DefaultCompoundCRS)coordinateReferenceSystem).getSingleCRS();
        } else if (coordinateReferenceSystem instanceof CompoundCRS) {
            List<CoordinateReferenceSystem> list2 = ((CompoundCRS)coordinateReferenceSystem).getComponents();
            list = new ArrayList<SingleCRS>(list2.size());
            DefaultCompoundCRS.getSingleCRS(list2, list);
        } else {
            list = Collections.singletonList((SingleCRS)coordinateReferenceSystem);
        }
        return list;
    }

    private static boolean getSingleCRS(List<? extends CoordinateReferenceSystem> list, List<SingleCRS> list2) {
        boolean bl = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : list) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                DefaultCompoundCRS.getSingleCRS(((CompoundCRS)coordinateReferenceSystem).getComponents(), list2);
                bl = false;
                continue;
            }
            list2.add((SingleCRS)coordinateReferenceSystem);
        }
        return bl;
    }

    private boolean computeSingleCRS(List<? extends CoordinateReferenceSystem> list) {
        this.singles = new ArrayList<SingleCRS>(list.size());
        boolean bl = DefaultCompoundCRS.getSingleCRS(list, this.singles);
        this.singles = UnmodifiableArrayList.wrap(this.singles.toArray(new SingleCRS[this.singles.size()]));
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        objectInputStream.defaultReadObject();
        if (this.crs instanceof CheckedCollection && SingleCRS.class.isAssignableFrom(clazz = ((CheckedCollection)((Object)this.crs)).getElementType())) {
            this.singles = this.crs;
            return;
        }
        this.computeSingleCRS(this.crs);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)abstractIdentifiedObject;
            return DefaultCompoundCRS.equals(this.crs, defaultCompoundCRS.crs, bl);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.crs).hashCode() ^ 0x73EE077A;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        for (CoordinateReferenceSystem coordinateReferenceSystem : this.crs) {
            formatter.append(coordinateReferenceSystem);
        }
        return "COMPD_CS";
    }
}

