/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.referencing.crs.AbstractSingleCRS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;

@XmlRootElement(name="GeographicCRS")
public class DefaultGeographicCRS
extends AbstractSingleCRS
implements GeographicCRS {
    private static final long serialVersionUID = 861224913438092335L;
    public static final DefaultGeographicCRS WGS84;
    public static final DefaultGeographicCRS WGS84_3D;

    private DefaultGeographicCRS() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultGeographicCRS(GeographicCRS geographicCRS) {
        super(geographicCRS);
    }

    public DefaultGeographicCRS(GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) {
        this(DefaultGeographicCRS.getProperties(geodeticDatum), geodeticDatum, ellipsoidalCS);
    }

    public DefaultGeographicCRS(String string, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) {
        this(Collections.singletonMap("name", string), geodeticDatum, ellipsoidalCS);
    }

    public DefaultGeographicCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) {
        super(map, geodeticDatum, ellipsoidalCS);
    }

    @Override
    @XmlElement(name="ellipsoidalCS")
    public EllipsoidalCS getCoordinateSystem() {
        return (EllipsoidalCS)super.getCoordinateSystem();
    }

    final void setCoordinateSystem(EllipsoidalCS ellipsoidalCS) {
        super.setCoordinateSystem(ellipsoidalCS);
    }

    @Override
    @XmlElement(name="geodeticDatum")
    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    final void setDatum(GeodeticDatum geodeticDatum) {
        super.setDatum(geodeticDatum);
    }

    @Override
    public Measure distance(double[] dArray, double[] dArray2) throws UnsupportedOperationException, MismatchedDimensionException {
        EllipsoidalCS ellipsoidalCS = this.getCoordinateSystem();
        if (!(ellipsoidalCS instanceof DefaultEllipsoidalCS)) {
            throw new UnsupportedImplementationException(ellipsoidalCS.getClass());
        }
        Ellipsoid ellipsoid = this.getDatum().getEllipsoid();
        if (!(ellipsoid instanceof DefaultEllipsoid)) {
            throw new UnsupportedImplementationException(ellipsoid.getClass());
        }
        DefaultEllipsoidalCS defaultEllipsoidalCS = (DefaultEllipsoidalCS)ellipsoidalCS;
        DefaultEllipsoid defaultEllipsoid = (DefaultEllipsoid)ellipsoid;
        if (dArray.length != 2 || dArray2.length != 2 || defaultEllipsoidalCS.getDimension() != 2) {
            return super.distance(dArray, dArray2);
        }
        return new Measure(defaultEllipsoid.orthodromicDistance(defaultEllipsoidalCS.getLongitude(dArray), defaultEllipsoidalCS.getLatitude(dArray), defaultEllipsoidalCS.getLongitude(dArray2), defaultEllipsoidalCS.getLatitude(dArray2)), defaultEllipsoid.getAxisUnit());
    }

    @Override
    public int hashCode() {
        return 0xED31AC2F ^ super.hashCode();
    }

    static Unit<Angle> getAngularUnit(CoordinateSystem coordinateSystem) {
        Unit<Angle> unit = NonSI.DEGREE_ANGLE;
        int n = coordinateSystem.getDimension();
        while (--n >= 0) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
            Unit<?> unit2 = coordinateSystemAxis.getUnit();
            if (!Units.isAngular(unit2)) continue;
            unit = unit2.asType(Angle.class);
            if (!AxisDirection.EAST.equals(coordinateSystemAxis.getDirection().absolute())) continue;
            break;
        }
        return unit;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Unit<Angle> unit = formatter.getAngularUnit();
        Unit<Angle> unit2 = DefaultGeographicCRS.getAngularUnit(this.getCoordinateSystem());
        GeodeticDatum geodeticDatum = this.getDatum();
        formatter.setAngularUnit(unit2);
        formatter.append(geodeticDatum);
        formatter.append(geodeticDatum.getPrimeMeridian());
        formatter.append(unit2);
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            formatter.append(this.getAxis(i));
        }
        if (!unit2.equals(this.getUnit())) {
            formatter.setInvalidWKT(GeographicCRS.class);
        }
        formatter.setAngularUnit(unit);
        return "GEOGCS";
    }

    static {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", "WGS84(DD)");
        String[] stringArray = new String[]{"WGS84", "WGS 84", "WGS 84 (3D)", "WGS 84 (geographic 3D)"};
        hashMap.put("alias", stringArray);
        hashMap.put("domainOfValidity", DefaultExtent.WORLD);
        WGS84 = new DefaultGeographicCRS(hashMap, (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        stringArray[1] = "WGS 84 (geographic 3D)";
        WGS84_3D = new DefaultGeographicCRS(hashMap, (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_3D);
    }
}

