/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.crs.AbstractSingleCRS;
import org.geotoolkit.referencing.cs.DefaultTimeCS;
import org.geotoolkit.referencing.datum.DefaultTemporalDatum;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

@XmlRootElement(name="TemporalCRS")
public class DefaultTemporalCRS
extends AbstractSingleCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    public static final DefaultTemporalCRS JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS MODIFIED_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.MODIFIED_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS TRUNCATED_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.TRUNCATED_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS DUBLIN_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.DUBLIN_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS UNIX = new DefaultTemporalCRS(DefaultTemporalDatum.UNIX, DefaultTimeCS.SECONDS);
    public static final DefaultTemporalCRS JAVA = new DefaultTemporalCRS(DefaultTemporalDatum.UNIX, DefaultTimeCS.MILLISECONDS);
    private transient UnitConverter toMillis;
    private transient long origin;

    private DefaultTemporalCRS() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultTemporalCRS(TemporalCRS temporalCRS) {
        super(temporalCRS);
    }

    public DefaultTemporalCRS(TemporalDatum temporalDatum, TimeCS timeCS) {
        this(DefaultTemporalCRS.getProperties(temporalDatum), temporalDatum, timeCS);
    }

    public DefaultTemporalCRS(String string, TemporalDatum temporalDatum, TimeCS timeCS) {
        this(Collections.singletonMap("name", string), temporalDatum, timeCS);
    }

    public DefaultTemporalCRS(Map<String, ?> map, TemporalDatum temporalDatum, TimeCS timeCS) {
        super(map, temporalDatum, timeCS);
    }

    public static DefaultTemporalCRS wrap(TemporalCRS temporalCRS) {
        if (temporalCRS == null || temporalCRS instanceof DefaultTemporalCRS) {
            return (DefaultTemporalCRS)temporalCRS;
        }
        return new DefaultTemporalCRS(temporalCRS);
    }

    private void initializeConverter() {
        this.origin = this.getDatum().getOrigin().getTime();
        this.toMillis = this.getAxis(0).getUnit().getConverterTo(Units.MILLISECOND);
    }

    @Override
    @XmlElement(name="temporalCS")
    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    final void setCoordinateSystem(TimeCS timeCS) {
        super.setCoordinateSystem(timeCS);
    }

    @Override
    @XmlElement(name="temporalDatum")
    public TemporalDatum getDatum() {
        return (TemporalDatum)super.getDatum();
    }

    final void setDatum(TemporalDatum temporalDatum) {
        super.setDatum(temporalDatum);
    }

    public Date toDate(double d) {
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return new Date(Math.round(this.toMillis.convert(d)) + this.origin);
    }

    public double toValue(Date date) {
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return this.toMillis.inverse().convert(date.getTime() - this.origin);
    }

    @Override
    public int hashCode() {
        return 0x86FFB877 ^ super.hashCode();
    }
}

