/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Arrays;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DirectionAlongMeridian;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

final class ComparableAxisWrapper
implements Comparable<ComparableAxisWrapper> {
    private final CoordinateSystemAxis axis;
    private final DirectionAlongMeridian meridian;

    private ComparableAxisWrapper(CoordinateSystemAxis coordinateSystemAxis) {
        this.axis = coordinateSystemAxis;
        this.meridian = DirectionAlongMeridian.parse(coordinateSystemAxis.getDirection());
    }

    private static boolean isCompassDirection(AxisDirection axisDirection) {
        int n = DefaultCoordinateSystemAxis.getCompassAngle(axisDirection, AxisDirection.NORTH);
        return n != Integer.MIN_VALUE;
    }

    @Override
    public int compareTo(ComparableAxisWrapper comparableAxisWrapper) {
        AxisDirection axisDirection = this.axis.getDirection();
        AxisDirection axisDirection2 = comparableAxisWrapper.axis.getDirection();
        int n = DefaultCoordinateSystemAxis.getCompassAngle(axisDirection2, axisDirection);
        if (n != Integer.MIN_VALUE) {
            return n;
        }
        if (ComparableAxisWrapper.isCompassDirection(axisDirection)) {
            assert (!ComparableAxisWrapper.isCompassDirection(axisDirection2)) : axisDirection2;
            return -1;
        }
        if (ComparableAxisWrapper.isCompassDirection(axisDirection2)) {
            assert (!ComparableAxisWrapper.isCompassDirection(axisDirection)) : axisDirection;
            return 1;
        }
        if (this.meridian != null) {
            if (comparableAxisWrapper.meridian != null) {
                return this.meridian.compareTo(comparableAxisWrapper.meridian);
            }
            return -1;
        }
        if (comparableAxisWrapper.meridian != null) {
            return 1;
        }
        return 0;
    }

    public static boolean sort(CoordinateSystemAxis[] coordinateSystemAxisArray) {
        boolean bl;
        Object[] objectArray = new ComparableAxisWrapper[coordinateSystemAxisArray.length];
        for (bl = false; bl < coordinateSystemAxisArray.length; bl += 1) {
            objectArray[bl] = new ComparableAxisWrapper(coordinateSystemAxisArray[bl]);
        }
        Arrays.sort(objectArray);
        bl = false;
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = ((ComparableAxisWrapper)objectArray[i]).axis;
            bl |= coordinateSystemAxisArray[i] != coordinateSystemAxis;
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        return bl;
    }
}

