/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.internal.jaxb.text.StringConverter;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.cs.DirectionAlongMeridian;
import org.geotoolkit.referencing.cs.Directions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.util.InternationalString;

public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = -7883614853277827689L;
    static final int COMPASS_DIRECTION_COUNT = 16;
    private static int PREDEFINED_COUNT = 0;
    private static final DefaultCoordinateSystemAxis[] PREDEFINED = new DefaultCoordinateSystemAxis[27];
    public static final DefaultCoordinateSystemAxis GEODETIC_LONGITUDE = new DefaultCoordinateSystemAxis(112, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis GEODETIC_LATITUDE = new DefaultCoordinateSystemAxis(111, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis LONGITUDE = new DefaultCoordinateSystemAxis(165, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis LATITUDE = new DefaultCoordinateSystemAxis(151, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis ELLIPSOIDAL_HEIGHT = new DefaultCoordinateSystemAxis(81, "h", AxisDirection.UP, SI.METRE);
    public static final DefaultCoordinateSystemAxis GRAVITY_RELATED_HEIGHT = new DefaultCoordinateSystemAxis(119, "H", AxisDirection.UP, SI.METRE);
    public static final DefaultCoordinateSystemAxis ALTITUDE = new DefaultCoordinateSystemAxis(8, "h", AxisDirection.UP, SI.METRE);
    public static final DefaultCoordinateSystemAxis DEPTH;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_RADIUS;
    public static final DefaultCoordinateSystemAxis SPHERICAL_LONGITUDE;
    public static final DefaultCoordinateSystemAxis SPHERICAL_LATITUDE;
    public static final DefaultCoordinateSystemAxis X;
    public static final DefaultCoordinateSystemAxis Y;
    public static final DefaultCoordinateSystemAxis Z;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_X;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Y;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Z;
    public static final DefaultCoordinateSystemAxis EASTING;
    public static final DefaultCoordinateSystemAxis WESTING;
    public static final DefaultCoordinateSystemAxis NORTHING;
    public static final DefaultCoordinateSystemAxis SOUTHING;
    public static final DefaultCoordinateSystemAxis TIME;
    public static final DefaultCoordinateSystemAxis COLUMN;
    public static final DefaultCoordinateSystemAxis ROW;
    public static final DefaultCoordinateSystemAxis DISPLAY_X;
    public static final DefaultCoordinateSystemAxis DISPLAY_Y;
    public static final DefaultCoordinateSystemAxis UNDEFINED;
    private static final DefaultCoordinateSystemAxis UNITIALIZED;
    private static final Map<String, CoordinateSystemAxis> ALIASES;
    @XmlElement(name="axisAbbrev", required=true)
    private final String abbreviation;
    @XmlElement(name="axisDirection", required=true)
    private final AxisDirection direction;
    @XmlAttribute(name="uom", required=true)
    private final Unit<?> unit;
    private final double minimum;
    private final double maximum;
    private final RangeMeaning rangeMeaning;
    private transient DefaultCoordinateSystemAxis opposite;

    private static boolean nameMatchesXY(String string, String string2) {
        if ((string = string.trim()).length() == 1) {
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis;
            switch (Character.toLowerCase(string.charAt(0))) {
                case 'x': {
                    defaultCoordinateSystemAxis = EASTING;
                    break;
                }
                case 'y': {
                    defaultCoordinateSystemAxis = NORTHING;
                    break;
                }
                default: {
                    return false;
                }
            }
            return defaultCoordinateSystemAxis.nameMatches(string2) || defaultCoordinateSystemAxis.getOpposite().nameMatches(string2);
        }
        return false;
    }

    @XmlID
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml", required=true)
    @XmlJavaTypeAdapter(value=StringConverter.class)
    final String getID() {
        return "coordinate-system-axis";
    }

    private DefaultCoordinateSystemAxis() {
        this(UNITIALIZED);
    }

    public DefaultCoordinateSystemAxis(CoordinateSystemAxis coordinateSystemAxis) {
        super(coordinateSystemAxis);
        this.abbreviation = coordinateSystemAxis.getAbbreviation();
        this.direction = coordinateSystemAxis.getDirection();
        this.unit = coordinateSystemAxis.getUnit();
        this.minimum = coordinateSystemAxis.getMinimumValue();
        this.maximum = coordinateSystemAxis.getMaximumValue();
        this.rangeMeaning = coordinateSystemAxis.getRangeMeaning();
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit, double d, double d2, RangeMeaning rangeMeaning) {
        super(map);
        this.abbreviation = string;
        this.direction = axisDirection;
        this.unit = unit;
        this.minimum = d;
        this.maximum = d2;
        this.rangeMeaning = rangeMeaning;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", string);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", axisDirection);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
        DefaultCoordinateSystemAxis.ensureNonNull("rangeMeaning", rangeMeaning);
        if (!(d < d2)) {
            throw new IllegalArgumentException(Errors.format(13, d, d2));
        }
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) {
        super(map);
        this.abbreviation = string;
        this.direction = axisDirection;
        this.unit = unit;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", string);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", axisDirection);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
        if (Units.isAngular(unit)) {
            UnitConverter unitConverter = NonSI.DEGREE_ANGLE.getConverterTo(unit);
            AxisDirection axisDirection2 = axisDirection.absolute();
            if (axisDirection2.equals(AxisDirection.NORTH)) {
                double d = Math.abs(unitConverter.convert(90.0));
                this.minimum = -d;
                this.maximum = d;
                this.rangeMeaning = RangeMeaning.EXACT;
                return;
            }
            if (axisDirection2.equals(AxisDirection.EAST)) {
                double d = Math.abs(unitConverter.convert(180.0));
                this.minimum = -d;
                this.maximum = d;
                this.rangeMeaning = RangeMeaning.WRAPAROUND;
                return;
            }
        }
        this.minimum = Double.NEGATIVE_INFINITY;
        this.maximum = Double.POSITIVE_INFINITY;
        this.rangeMeaning = RangeMeaning.EXACT;
    }

    public DefaultCoordinateSystemAxis(String string, AxisDirection axisDirection, Unit<?> unit) {
        this(Collections.singletonMap("name", string), string, axisDirection, unit);
    }

    public DefaultCoordinateSystemAxis(CharSequence charSequence, String string, AxisDirection axisDirection, Unit<?> unit) {
        this(DefaultCoordinateSystemAxis.toMap(charSequence), string, axisDirection, unit);
    }

    private static Map<String, Object> toMap(CharSequence charSequence) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        if (charSequence != null) {
            if (charSequence instanceof InternationalString) {
                hashMap.put("name", ((InternationalString)charSequence).toString(null));
                hashMap.put("alias", charSequence);
            } else {
                hashMap.put("name", ((Object)charSequence).toString());
            }
        }
        return hashMap;
    }

    private DefaultCoordinateSystemAxis(int n, String string, AxisDirection axisDirection, Unit<?> unit) {
        this(n >= 0 ? Vocabulary.formatInternational(n) : string, string, axisDirection, unit);
        DefaultCoordinateSystemAxis.PREDEFINED[DefaultCoordinateSystemAxis.PREDEFINED_COUNT++] = this;
    }

    public static DefaultCoordinateSystemAxis getPredefined(String string, AxisDirection axisDirection) {
        DefaultCoordinateSystemAxis.ensureNonNull("name", string);
        string = string.trim();
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = null;
        for (int i = 0; i < PREDEFINED_COUNT; ++i) {
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis2 = PREDEFINED[i];
            if (axisDirection != null && !axisDirection.equals(defaultCoordinateSystemAxis2.getDirection())) continue;
            if (defaultCoordinateSystemAxis2.abbreviation.equals(string)) {
                return defaultCoordinateSystemAxis2;
            }
            if (defaultCoordinateSystemAxis != null || !defaultCoordinateSystemAxis2.nameMatches(string) || (defaultCoordinateSystemAxis2 == GEODETIC_LONGITUDE || defaultCoordinateSystemAxis2 == GEODETIC_LATITUDE) && !string.toLowerCase().startsWith("geodetic")) continue;
            defaultCoordinateSystemAxis = defaultCoordinateSystemAxis2;
        }
        if (defaultCoordinateSystemAxis == null && string.length() == 1) {
            switch (string.charAt(0)) {
                case 'X': {
                    if (!AxisDirection.OTHER.equals(axisDirection)) break;
                    return GEOCENTRIC_X;
                }
                case 'Y': {
                    if (!AxisDirection.EAST.equals(axisDirection)) break;
                    return GEOCENTRIC_Y;
                }
                case 'Z': {
                    if (!AxisDirection.NORTH.equals(axisDirection)) break;
                    return GEOCENTRIC_Z;
                }
            }
        }
        return defaultCoordinateSystemAxis;
    }

    static DefaultCoordinateSystemAxis getPredefined(CoordinateSystemAxis coordinateSystemAxis) {
        return DefaultCoordinateSystemAxis.getPredefined(coordinateSystemAxis.getName().getCode(), coordinateSystemAxis.getDirection());
    }

    static DefaultCoordinateSystemAxis[] values() {
        return (DefaultCoordinateSystemAxis[])PREDEFINED.clone();
    }

    public static AxisDirection getDirection(String string) throws NoSuchElementException {
        DefaultCoordinateSystemAxis.ensureNonNull("direction", string);
        string = string.trim();
        AxisDirection axisDirection = Directions.find(string);
        if (axisDirection != null) {
            return axisDirection;
        }
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(string);
        if (directionAlongMeridian != null) {
            axisDirection = directionAlongMeridian.getDirection();
            assert (axisDirection == Directions.find(directionAlongMeridian.toString()));
            return axisDirection;
        }
        throw new NoSuchElementException(Errors.format(191, string));
    }

    @Override
    public AxisDirection getDirection() {
        return this.direction;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public double getMinimumValue() {
        return this.minimum;
    }

    @Override
    public double getMaximumValue() {
        return this.maximum;
    }

    @Override
    public RangeMeaning getRangeMeaning() {
        return this.rangeMeaning;
    }

    final DefaultCoordinateSystemAxis getOpposite() {
        return this.opposite;
    }

    public static boolean isCompassDirection(AxisDirection axisDirection) {
        DefaultCoordinateSystemAxis.ensureNonNull("direction", axisDirection);
        int n = axisDirection.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16;
    }

    public static double getAngle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        DirectionAlongMeridian directionAlongMeridian;
        DefaultCoordinateSystemAxis.ensureNonNull("source", axisDirection);
        DefaultCoordinateSystemAxis.ensureNonNull("target", axisDirection2);
        int n = DefaultCoordinateSystemAxis.getCompassAngle(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return (double)n * 22.5;
        }
        DirectionAlongMeridian directionAlongMeridian2 = DirectionAlongMeridian.parse(axisDirection);
        if (directionAlongMeridian2 != null && (directionAlongMeridian = DirectionAlongMeridian.parse(axisDirection2)) != null) {
            return directionAlongMeridian2.getAngle(directionAlongMeridian);
        }
        return Double.NaN;
    }

    static int getCompassAngle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.NORTH.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 16 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 16) {
            if ((n = n3 - n) < -8) {
                n += 16;
            } else if (n > 8) {
                n -= 16;
            }
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public static boolean perpendicular(AxisDirection axisDirection, AxisDirection axisDirection2) {
        return Math.abs(Math.abs(DefaultCoordinateSystemAxis.getAngle(axisDirection, axisDirection2)) - 90.0) <= 1.0E-10;
    }

    final DefaultCoordinateSystemAxis usingUnit(Unit<?> unit) throws IllegalArgumentException {
        if (this.unit.equals(unit)) {
            return this;
        }
        if (this.unit.isCompatible(unit)) {
            return new DefaultCoordinateSystemAxis(DefaultCoordinateSystemAxis.getProperties(this, null), this.abbreviation, this.direction, unit, this.minimum, this.maximum, this.rangeMeaning);
        }
        throw new IllegalArgumentException(Errors.format(81, unit));
    }

    @Override
    public boolean nameMatches(String string) {
        if (super.nameMatches(string)) {
            return true;
        }
        CoordinateSystemAxis coordinateSystemAxis = ALIASES.get(string.trim().toLowerCase());
        return coordinateSystemAxis != null && coordinateSystemAxis == ALIASES.get(this.getName().getCode().trim().toLowerCase());
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            return this.equals((DefaultCoordinateSystemAxis)abstractIdentifiedObject, bl, true);
        }
        return false;
    }

    final boolean equals(DefaultCoordinateSystemAxis defaultCoordinateSystemAxis, boolean bl, boolean bl2) {
        if (bl) {
            if (!Utilities.equals(this.abbreviation, defaultCoordinateSystemAxis.abbreviation) || !Utilities.equals(this.rangeMeaning, defaultCoordinateSystemAxis.rangeMeaning) || Double.doubleToLongBits(this.minimum) != Double.doubleToLongBits(defaultCoordinateSystemAxis.minimum) || Double.doubleToLongBits(this.maximum) != Double.doubleToLongBits(defaultCoordinateSystemAxis.maximum)) {
                return false;
            }
        } else {
            String string;
            String string2 = defaultCoordinateSystemAxis.getName().getCode();
            if (!this.nameMatches(string2) && !DefaultCoordinateSystemAxis.nameMatches((IdentifiedObject)defaultCoordinateSystemAxis, string = this.getName().getCode())) {
                if (!bl2) {
                    return false;
                }
                if (!DefaultCoordinateSystemAxis.nameMatchesXY(string2, string) && !DefaultCoordinateSystemAxis.nameMatchesXY(string, string2)) {
                    return false;
                }
            }
        }
        return Utilities.equals(this.direction, defaultCoordinateSystemAxis.direction) && (!bl2 || Utilities.equals(this.unit, defaultCoordinateSystemAxis.unit));
    }

    @Override
    public int hashCode() {
        int n = 1684127127;
        n = n * 31 + this.abbreviation.hashCode();
        n = n * 31 + this.direction.hashCode();
        n = n * 31 + this.unit.hashCode();
        return n;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.append(this.direction);
        return "AXIS";
    }

    static {
        DefaultCoordinateSystemAxis.ALTITUDE.opposite = DEPTH = new DefaultCoordinateSystemAxis(63, "d", AxisDirection.DOWN, SI.METRE);
        DefaultCoordinateSystemAxis.DEPTH.opposite = ALTITUDE;
        GEOCENTRIC_RADIUS = new DefaultCoordinateSystemAxis(104, "r", AxisDirection.UP, SI.METRE);
        SPHERICAL_LONGITUDE = new DefaultCoordinateSystemAxis(251, "\u03a9", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
        SPHERICAL_LATITUDE = new DefaultCoordinateSystemAxis(250, "\u03b8", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
        X = new DefaultCoordinateSystemAxis(-1, "x", AxisDirection.EAST, SI.METRE);
        Y = new DefaultCoordinateSystemAxis(-1, "y", AxisDirection.NORTH, SI.METRE);
        Z = new DefaultCoordinateSystemAxis(-1, "z", AxisDirection.UP, SI.METRE);
        GEOCENTRIC_X = new DefaultCoordinateSystemAxis(106, "X", AxisDirection.GEOCENTRIC_X, SI.METRE);
        GEOCENTRIC_Y = new DefaultCoordinateSystemAxis(107, "Y", AxisDirection.GEOCENTRIC_Y, SI.METRE);
        GEOCENTRIC_Z = new DefaultCoordinateSystemAxis(108, "Z", AxisDirection.GEOCENTRIC_Z, SI.METRE);
        EASTING = new DefaultCoordinateSystemAxis(77, "E", AxisDirection.EAST, SI.METRE);
        DefaultCoordinateSystemAxis.EASTING.opposite = WESTING = new DefaultCoordinateSystemAxis(294, "W", AxisDirection.WEST, SI.METRE);
        DefaultCoordinateSystemAxis.WESTING.opposite = EASTING;
        NORTHING = new DefaultCoordinateSystemAxis(185, "N", AxisDirection.NORTH, SI.METRE);
        DefaultCoordinateSystemAxis.NORTHING.opposite = SOUTHING = new DefaultCoordinateSystemAxis(248, "S", AxisDirection.SOUTH, SI.METRE);
        DefaultCoordinateSystemAxis.SOUTHING.opposite = NORTHING;
        TIME = new DefaultCoordinateSystemAxis(265, "t", AxisDirection.FUTURE, NonSI.DAY);
        COLUMN = new DefaultCoordinateSystemAxis(34, "i", AxisDirection.COLUMN_POSITIVE, Unit.ONE);
        ROW = new DefaultCoordinateSystemAxis(229, "j", AxisDirection.ROW_POSITIVE, Unit.ONE);
        DISPLAY_X = new DefaultCoordinateSystemAxis(-1, "x", AxisDirection.DISPLAY_RIGHT, Unit.ONE);
        DISPLAY_Y = new DefaultCoordinateSystemAxis(-1, "y", AxisDirection.DISPLAY_DOWN, Unit.ONE);
        UNDEFINED = new DefaultCoordinateSystemAxis(276, "?", AxisDirection.OTHER, Unit.ONE);
        UNITIALIZED = new DefaultCoordinateSystemAxis("Undefined", "?", AxisDirection.OTHER, Unit.ONE);
        ALIASES = new HashMap<String, CoordinateSystemAxis>(12);
        ALIASES.put("lat", GEODETIC_LATITUDE);
        ALIASES.put("latitude", GEODETIC_LATITUDE);
        ALIASES.put("geodetic latitude", GEODETIC_LATITUDE);
        ALIASES.put("lon", GEODETIC_LONGITUDE);
        ALIASES.put("long", GEODETIC_LONGITUDE);
        ALIASES.put("longitude", GEODETIC_LONGITUDE);
        ALIASES.put("geodetic longitude", GEODETIC_LONGITUDE);
    }
}

