/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;
    public static DefaultEllipsoidalCS GEODETIC_2D = new DefaultEllipsoidalCS(DefaultEllipsoidalCS.name(109), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE);
    public static DefaultEllipsoidalCS GEODETIC_3D = new DefaultEllipsoidalCS(DefaultEllipsoidalCS.name(110), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    private transient int longitudeAxis;
    private transient int latitudeAxis;
    private transient int heightAxis;
    private transient UnitConverter longitudeConverter;
    private transient UnitConverter latitudeConverter;
    private transient UnitConverter heightConverter;

    private DefaultEllipsoidalCS() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultEllipsoidalCS(EllipsoidalCS ellipsoidalCS) {
        super(ellipsoidalCS);
    }

    public DefaultEllipsoidalCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(string, new CoordinateSystemAxis[]{coordinateSystemAxis, coordinateSystemAxis2});
    }

    public DefaultEllipsoidalCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(string, new CoordinateSystemAxis[]{coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3});
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, new CoordinateSystemAxis[]{coordinateSystemAxis, coordinateSystemAxis2});
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, new CoordinateSystemAxis[]{coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3});
    }

    private DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.NORTH.equals(axisDirection = axisDirection.absolute()) || AxisDirection.EAST.equals(axisDirection) || AxisDirection.UP.equals(axisDirection);
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        if (AxisDirection.UP.equals(axisDirection = axisDirection.absolute())) {
            return Units.isLinear(unit);
        }
        return Units.isAngular(unit);
    }

    private void update() {
        int n = this.getDimension();
        while (--n >= 0) {
            CoordinateSystemAxis coordinateSystemAxis = this.getAxis(n);
            AxisDirection axisDirection = coordinateSystemAxis.getDirection().absolute();
            Unit<Quantity> unit = coordinateSystemAxis.getUnit();
            if (AxisDirection.EAST.equals(axisDirection)) {
                this.longitudeAxis = n;
                this.longitudeConverter = unit.getConverterTo(NonSI.DEGREE_ANGLE);
                continue;
            }
            if (AxisDirection.NORTH.equals(axisDirection)) {
                this.latitudeAxis = n;
                this.latitudeConverter = unit.getConverterTo(NonSI.DEGREE_ANGLE);
                continue;
            }
            if (AxisDirection.UP.equals(axisDirection)) {
                this.heightAxis = n;
                this.heightConverter = unit.getConverterTo(SI.METRE);
                continue;
            }
            throw new AssertionError(axisDirection);
        }
    }

    public double getLongitude(double[] dArray) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", dArray);
        if (this.longitudeConverter == null) {
            this.update();
        }
        return this.longitudeConverter.convert(dArray[this.longitudeAxis]);
    }

    public double getLatitude(double[] dArray) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", dArray);
        if (this.latitudeConverter == null) {
            this.update();
        }
        return this.latitudeConverter.convert(dArray[this.latitudeAxis]);
    }

    public double getHeight(double[] dArray) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", dArray);
        if (this.heightConverter == null) {
            this.update();
            if (this.heightConverter == null) {
                throw new IllegalStateException(Errors.format(135));
            }
        }
        return this.heightConverter.convert(dArray[this.heightAxis]);
    }

    public DefaultEllipsoidalCS usingUnit(Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] coordinateSystemAxisArray = this.axisUsingUnit(unit);
        if (coordinateSystemAxisArray == null) {
            return this;
        }
        return new DefaultEllipsoidalCS(DefaultEllipsoidalCS.getProperties(this, null), coordinateSystemAxisArray);
    }
}

