/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.util.InternationalString;

public class DefaultTimeCS
extends AbstractCS
implements TimeCS {
    private static final long serialVersionUID = 5222911412381303989L;
    public static final DefaultTimeCS DAYS;
    public static final DefaultTimeCS SECONDS;
    public static final DefaultTimeCS MILLISECONDS;

    private DefaultTimeCS() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultTimeCS(TimeCS timeCS) {
        super(timeCS);
    }

    public DefaultTimeCS(String string, CoordinateSystemAxis coordinateSystemAxis) {
        super(string, new CoordinateSystemAxis[]{coordinateSystemAxis});
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    public DefaultTimeCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) {
        super(map, new CoordinateSystemAxis[]{coordinateSystemAxis});
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.FUTURE.equals(axisDirection.absolute());
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        return SI.SECOND.isCompatible(unit);
    }

    @Override
    public Measure distance(double[] dArray, double[] dArray2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", dArray);
        this.ensureDimensionMatch("coord2", dArray2);
        return new Measure(Math.abs(dArray[0] - dArray2[0]), this.getDistanceUnit());
    }

    static {
        Map<String, Object> map = DefaultTimeCS.name(261);
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.TIME;
        DAYS = new DefaultTimeCS(map, (CoordinateSystemAxis)defaultCoordinateSystemAxis);
        InternationalString internationalString = defaultCoordinateSystemAxis.getAlias().iterator().next().toInternationalString();
        defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis(internationalString, "t", AxisDirection.FUTURE, SI.SECOND);
        SECONDS = new DefaultTimeCS(map, (CoordinateSystemAxis)defaultCoordinateSystemAxis);
        defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis(internationalString, "t", AxisDirection.FUTURE, SI.MILLI(SI.SECOND));
        MILLISECONDS = new DefaultTimeCS(map, (CoordinateSystemAxis)defaultCoordinateSystemAxis);
    }
}

