/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;

public class DefaultVerticalCS
extends AbstractCS
implements VerticalCS {
    private static final long serialVersionUID = 1201155778896630499L;
    public static DefaultVerticalCS ELLIPSOIDAL_HEIGHT = new DefaultVerticalCS(DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    public static DefaultVerticalCS GRAVITY_RELATED_HEIGHT = new DefaultVerticalCS(DefaultCoordinateSystemAxis.GRAVITY_RELATED_HEIGHT);
    public static DefaultVerticalCS DEPTH = new DefaultVerticalCS(DefaultCoordinateSystemAxis.DEPTH);

    private DefaultVerticalCS() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultVerticalCS(VerticalCS verticalCS) {
        super(verticalCS);
    }

    public DefaultVerticalCS(CoordinateSystemAxis coordinateSystemAxis) {
        super(DefaultVerticalCS.getProperties(coordinateSystemAxis), new CoordinateSystemAxis[]{coordinateSystemAxis});
    }

    public DefaultVerticalCS(String string, CoordinateSystemAxis coordinateSystemAxis) {
        super(string, new CoordinateSystemAxis[]{coordinateSystemAxis});
    }

    public DefaultVerticalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) {
        super(map, new CoordinateSystemAxis[]{coordinateSystemAxis});
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.UP.equals(axisDirection.absolute());
    }

    @Override
    public Measure distance(double[] dArray, double[] dArray2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", dArray);
        this.ensureDimensionMatch("coord2", dArray2);
        return new Measure(Math.abs(dArray[0] - dArray2[0]), this.getDistanceUnit());
    }
}

