/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.internal.jaxb.text.StringConverter;
import org.geotoolkit.internal.jaxb.uom.DateAsLongAdapter;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    private static final String[] LOCALIZABLES = new String[]{"anchorPoint", "scope"};
    @XmlElement
    private final InternationalString anchorPoint;
    @XmlElement
    @XmlJavaTypeAdapter(value=DateAsLongAdapter.class, type=long.class)
    private final long realizationEpoch;
    @XmlElement(name="validArea")
    private final Extent domainOfValidity;
    @XmlElement
    private final InternationalString scope;

    @XmlID
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml", required=true)
    @XmlJavaTypeAdapter(value=StringConverter.class)
    final String getID() {
        return "datum";
    }

    private AbstractDatum() {
        this(NullReferencingObject.INSTANCE);
    }

    public AbstractDatum(Datum datum) {
        super(datum);
        Date date = datum.getRealizationEpoch();
        this.realizationEpoch = date != null ? date.getTime() : Long.MIN_VALUE;
        this.domainOfValidity = datum.getDomainOfValidity();
        this.scope = datum.getScope();
        this.anchorPoint = datum.getAnchorPoint();
    }

    public AbstractDatum(Map<String, ?> map) {
        this(map, new HashMap<String, Object>());
    }

    private AbstractDatum(Map<String, ?> map, Map<String, Object> map2) {
        super(map, map2, LOCALIZABLES);
        this.anchorPoint = (InternationalString)map2.get("anchorPoint");
        Date date = (Date)map2.get("realizationEpoch");
        this.domainOfValidity = (Extent)map2.get("domainOfValidity");
        this.scope = (InternationalString)map2.get("scope");
        this.realizationEpoch = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    static Map<String, Object> name(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        InternationalString internationalString = Vocabulary.formatInternational(n);
        hashMap.put("name", internationalString.toString(null));
        hashMap.put("alias", internationalString);
        return hashMap;
    }

    @Override
    public InternationalString getAnchorPoint() {
        return this.anchorPoint;
    }

    @Override
    public Date getRealizationEpoch() {
        return this.realizationEpoch != Long.MIN_VALUE ? new Date(this.realizationEpoch) : null;
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    int getLegacyDatumType() {
        return 0;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (super.equals(abstractIdentifiedObject, bl)) {
            if (!bl) {
                return this.nameMatches(abstractIdentifiedObject.getName().getCode()) || abstractIdentifiedObject.nameMatches(this.getName().getCode());
            }
            AbstractDatum abstractDatum = (AbstractDatum)abstractIdentifiedObject;
            return this.realizationEpoch == abstractDatum.realizationEpoch && Utilities.equals(this.domainOfValidity, abstractDatum.domainOfValidity) && Utilities.equals(this.anchorPoint, abstractDatum.anchorPoint) && Utilities.equals(this.scope, abstractDatum.scope);
        }
        return false;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.append(this.getLegacyDatumType());
        return Classes.getShortClassName(this);
    }
}

