/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultPrimeMeridian;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum {
    private static final long serialVersionUID = 8832100095648302943L;
    private static final BursaWolfParameters[] EMPTY_BURSAWOLF = new BursaWolfParameters[0];
    public static final DefaultGeodeticDatum WGS84;
    public static final DefaultGeodeticDatum WGS72;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    private final Ellipsoid ellipsoid;
    private final PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    private DefaultGeodeticDatum() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultGeodeticDatum(GeodeticDatum geodeticDatum) {
        super(geodeticDatum);
        this.ellipsoid = geodeticDatum.getEllipsoid();
        this.primeMeridian = geodeticDatum.getPrimeMeridian();
        this.bursaWolf = geodeticDatum instanceof DefaultGeodeticDatum ? ((DefaultGeodeticDatum)geodeticDatum).bursaWolf : null;
    }

    public DefaultGeodeticDatum(String string, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        this(Collections.singletonMap("name", string), ellipsoid, primeMeridian);
    }

    public DefaultGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(map);
        BursaWolfParameters[] bursaWolfParametersArray;
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        DefaultGeodeticDatum.ensureNonNull("ellipsoid", ellipsoid);
        DefaultGeodeticDatum.ensureNonNull("primeMeridian", primeMeridian);
        Object obj = map.get(BURSA_WOLF_KEY);
        if (obj instanceof BursaWolfParameters) {
            bursaWolfParametersArray = new BursaWolfParameters[]{((BursaWolfParameters)obj).clone()};
        } else {
            bursaWolfParametersArray = (BursaWolfParameters[])obj;
            if (bursaWolfParametersArray != null) {
                if (bursaWolfParametersArray.length == 0) {
                    bursaWolfParametersArray = null;
                } else {
                    LinkedHashSet<BursaWolfParameters> linkedHashSet = new LinkedHashSet<BursaWolfParameters>();
                    for (int i = 0; i < bursaWolfParametersArray.length; ++i) {
                        linkedHashSet.add(bursaWolfParametersArray[i].clone());
                    }
                    bursaWolfParametersArray = linkedHashSet.toArray(new BursaWolfParameters[linkedHashSet.size()]);
                }
            }
        }
        this.bursaWolf = bursaWolfParametersArray;
    }

    @Override
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @Override
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters[] getBursaWolfParameters() {
        if (this.bursaWolf != null) {
            return (BursaWolfParameters[])this.bursaWolf.clone();
        }
        return EMPTY_BURSAWOLF;
    }

    public BursaWolfParameters getBursaWolfParameters(GeodeticDatum geodeticDatum) {
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters bursaWolfParameters = this.bursaWolf[i];
                if (!DefaultGeodeticDatum.equals(geodeticDatum, bursaWolfParameters.targetDatum, false)) continue;
                return bursaWolfParameters.clone();
            }
        }
        return null;
    }

    public static Matrix getAffineTransform(GeodeticDatum geodeticDatum, GeodeticDatum geodeticDatum2) {
        return DefaultGeodeticDatum.getAffineTransform(geodeticDatum, geodeticDatum2, null);
    }

    private static XMatrix getAffineTransform(GeodeticDatum geodeticDatum, GeodeticDatum geodeticDatum2, Set<GeodeticDatum> set) {
        Object object;
        int n;
        BursaWolfParameters[] bursaWolfParametersArray;
        DefaultGeodeticDatum.ensureNonNull("source", geodeticDatum);
        DefaultGeodeticDatum.ensureNonNull("target", geodeticDatum2);
        if (geodeticDatum instanceof DefaultGeodeticDatum && (bursaWolfParametersArray = ((DefaultGeodeticDatum)geodeticDatum).bursaWolf) != null) {
            for (n = 0; n < bursaWolfParametersArray.length; ++n) {
                object = bursaWolfParametersArray[n];
                if (!DefaultGeodeticDatum.equals(geodeticDatum2, ((BursaWolfParameters)object).targetDatum, false)) continue;
                return ((BursaWolfParameters)object).getAffineTransform();
            }
        }
        if (geodeticDatum2 instanceof DefaultGeodeticDatum && (bursaWolfParametersArray = ((DefaultGeodeticDatum)geodeticDatum2).bursaWolf) != null) {
            for (n = 0; n < bursaWolfParametersArray.length; ++n) {
                object = bursaWolfParametersArray[n];
                if (!DefaultGeodeticDatum.equals(geodeticDatum, ((BursaWolfParameters)object).targetDatum, false)) continue;
                XMatrix xMatrix = ((BursaWolfParameters)object).getAffineTransform();
                xMatrix.invert();
                return xMatrix;
            }
        }
        if (geodeticDatum instanceof DefaultGeodeticDatum && geodeticDatum2 instanceof DefaultGeodeticDatum) {
            bursaWolfParametersArray = ((DefaultGeodeticDatum)geodeticDatum).bursaWolf;
            BursaWolfParameters[] bursaWolfParametersArray2 = ((DefaultGeodeticDatum)geodeticDatum2).bursaWolf;
            if (bursaWolfParametersArray != null && bursaWolfParametersArray2 != null) {
                for (int i = 0; i < bursaWolfParametersArray.length; ++i) {
                    object = bursaWolfParametersArray[i].targetDatum;
                    for (int j = 0; j < bursaWolfParametersArray2.length; ++j) {
                        GeodeticDatum geodeticDatum3 = bursaWolfParametersArray2[j].targetDatum;
                        if (!DefaultGeodeticDatum.equals((IdentifiedObject)object, geodeticDatum3, false)) continue;
                        if (set == null) {
                            set = new HashSet<GeodeticDatum>();
                        }
                        if (!set.add(geodeticDatum)) continue;
                        if (set.add(geodeticDatum2)) {
                            XMatrix xMatrix;
                            XMatrix xMatrix2 = DefaultGeodeticDatum.getAffineTransform(geodeticDatum, (GeodeticDatum)object, set);
                            if (xMatrix2 != null && (xMatrix = DefaultGeodeticDatum.getAffineTransform(geodeticDatum3, geodeticDatum2, set)) != null) {
                                xMatrix.multiply(xMatrix2);
                                return xMatrix;
                            }
                            set.remove(geodeticDatum2);
                        }
                        set.remove(geodeticDatum);
                    }
                }
            }
        }
        return null;
    }

    public static boolean isWGS84(Datum datum) {
        if (datum instanceof AbstractIdentifiedObject) {
            return WGS84.equals((AbstractIdentifiedObject)((Object)datum), false);
        }
        return datum != null && datum.equals(WGS84);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultGeodeticDatum defaultGeodeticDatum = (DefaultGeodeticDatum)abstractIdentifiedObject;
            if (DefaultGeodeticDatum.equals(this.ellipsoid, defaultGeodeticDatum.ellipsoid, bl) && DefaultGeodeticDatum.equals(this.primeMeridian, defaultGeodeticDatum.primeMeridian, bl)) {
                return !bl || Arrays.equals(this.bursaWolf, defaultGeodeticDatum.bursaWolf);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * (this.ellipsoid.hashCode() + 31 * this.primeMeridian.hashCode()) ^ 0x15CF875F;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.append(this.ellipsoid);
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters bursaWolfParameters = this.bursaWolf[i];
                if (!DefaultGeodeticDatum.isWGS84(bursaWolfParameters.targetDatum)) continue;
                formatter.append(bursaWolfParameters);
                break;
            }
        }
        return "DATUM";
    }

    static {
        ReferenceIdentifier[] referenceIdentifierArray = new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "WGS84"), new NamedIdentifier(Citations.ORACLE, "WGS 84"), new NamedIdentifier(null, "WGS_84"), new NamedIdentifier(null, "WGS 1984"), new NamedIdentifier(null, "WGS_1984"), new NamedIdentifier(Citations.ESRI, "D_WGS_1984"), new NamedIdentifier(Citations.EPSG, "World Geodetic System 1984")};
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("alias", referenceIdentifierArray);
        WGS84 = new DefaultGeodeticDatum(hashMap, (Ellipsoid)DefaultEllipsoid.WGS84, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
        referenceIdentifierArray = new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "WGS72"), new NamedIdentifier(Citations.EPSG, "World Geodetic System 1972")};
        hashMap = new HashMap(4);
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("alias", referenceIdentifierArray);
        WGS72 = new DefaultGeodeticDatum(hashMap, (Ellipsoid)DefaultEllipsoid.WGS72, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
    }
}

