/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.Map;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;

public class DefaultImageDatum
extends AbstractDatum
implements ImageDatum {
    private static final long serialVersionUID = -4304193511244150936L;
    private final PixelInCell pixelInCell;

    private DefaultImageDatum() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultImageDatum(ImageDatum imageDatum) {
        super(imageDatum);
        this.pixelInCell = imageDatum.getPixelInCell();
    }

    public DefaultImageDatum(String string, PixelInCell pixelInCell) {
        this(Collections.singletonMap("name", string), pixelInCell);
    }

    public DefaultImageDatum(Map<String, ?> map, PixelInCell pixelInCell) {
        super(map);
        this.pixelInCell = pixelInCell;
        DefaultImageDatum.ensureNonNull("pixelInCell", pixelInCell);
    }

    @Override
    public PixelInCell getPixelInCell() {
        return this.pixelInCell;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultImageDatum defaultImageDatum = (DefaultImageDatum)abstractIdentifiedObject;
            return Utilities.equals(this.pixelInCell, defaultImageDatum.pixelInCell);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.pixelInCell.hashCode();
    }

    @Override
    public String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        formatter.append(this.pixelInCell);
        formatter.setInvalidWKT(ImageDatum.class);
        return "IMAGE_DATUM";
    }
}

