/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.internal.jaxb.text.StringConverter;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.datum.PrimeMeridian;

public class DefaultPrimeMeridian
extends AbstractIdentifiedObject
implements PrimeMeridian {
    private static final long serialVersionUID = 541978454643213305L;
    public static final DefaultPrimeMeridian GREENWICH = new DefaultPrimeMeridian("Greenwich", 0.0, NonSI.DEGREE_ANGLE);
    @XmlElement(required=true)
    private final double greenwichLongitude;
    private final Unit<Angle> angularUnit;

    @XmlID
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml", required=true)
    @XmlJavaTypeAdapter(value=StringConverter.class)
    final String getID() {
        return "meridian";
    }

    private DefaultPrimeMeridian() {
        this(GREENWICH);
    }

    public DefaultPrimeMeridian(PrimeMeridian primeMeridian) {
        super(primeMeridian);
        this.greenwichLongitude = primeMeridian.getGreenwichLongitude();
        this.angularUnit = primeMeridian.getAngularUnit();
    }

    public DefaultPrimeMeridian(String string, double d) {
        this(string, d, NonSI.DEGREE_ANGLE);
    }

    public DefaultPrimeMeridian(String string, double d, Unit<Angle> unit) {
        this(Collections.singletonMap("name", string), d, unit);
    }

    public DefaultPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) {
        super(map);
        this.greenwichLongitude = d;
        this.angularUnit = unit;
        DefaultPrimeMeridian.ensureAngularUnit(unit);
    }

    @Override
    public double getGreenwichLongitude() {
        return this.greenwichLongitude;
    }

    public double getGreenwichLongitude(Unit<Angle> unit) {
        return this.getAngularUnit().getConverterTo(unit).convert(this.getGreenwichLongitude());
    }

    @Override
    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultPrimeMeridian defaultPrimeMeridian = (DefaultPrimeMeridian)abstractIdentifiedObject;
            if (bl) {
                return Double.doubleToLongBits(this.greenwichLongitude) == Double.doubleToLongBits(defaultPrimeMeridian.greenwichLongitude) && Utilities.equals(this.angularUnit, defaultPrimeMeridian.angularUnit);
            }
            return Double.doubleToLongBits(this.getGreenwichLongitude(NonSI.DEGREE_ANGLE)) == Double.doubleToLongBits(defaultPrimeMeridian.getGreenwichLongitude(NonSI.DEGREE_ANGLE));
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.greenwichLongitude);
        return (int)(l >>> 32) ^ (int)l ^ 0x70EC83F9;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Unit<Angle> unit = formatter.getAngularUnit();
        if (unit == null) {
            unit = NonSI.DEGREE_ANGLE;
        }
        formatter.append(this.getGreenwichLongitude(unit));
        return "PRIMEM";
    }
}

