/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.util.InternationalString;

public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = 3357241732140076884L;
    public static final DefaultTemporalDatum JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(148), new Date(-210866760000000L));
    public static final DefaultTemporalDatum MODIFIED_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(176), new Date(-3506716800000L));
    public static final DefaultTemporalDatum TRUNCATED_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(274), new Date(-50716800000L));
    public static final DefaultTemporalDatum DUBLIN_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(73), new Date(-2209032000000L));
    public static final DefaultTemporalDatum UNIX = new DefaultTemporalDatum("UNIX", new Date(0L));
    private final long origin;

    private DefaultTemporalDatum() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultTemporalDatum(TemporalDatum temporalDatum) {
        super(temporalDatum);
        this.origin = temporalDatum.getOrigin().getTime();
    }

    public DefaultTemporalDatum(String string, Date date) {
        this(Collections.singletonMap("name", string), date);
    }

    public DefaultTemporalDatum(Map<String, ?> map, Date date) {
        super(map);
        DefaultTemporalDatum.ensureNonNull("origin", date);
        this.origin = date.getTime();
    }

    @Override
    public Date getOrigin() {
        return new Date(this.origin);
    }

    @Override
    public InternationalString getAnchorPoint() {
        return super.getAnchorPoint();
    }

    @Override
    public Date getRealizationEpoch() {
        return super.getRealizationEpoch();
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultTemporalDatum defaultTemporalDatum = (DefaultTemporalDatum)abstractIdentifiedObject;
            return this.origin == defaultTemporalDatum.origin;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.origin ^ (int)(this.origin >>> 32);
    }
}

