/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.Map;
import org.geotoolkit.internal.referencing.NullReferencingObject;
import org.geotoolkit.internal.referencing.VerticalDatumTypes;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

public class DefaultVerticalDatum
extends AbstractDatum
implements VerticalDatum {
    private static final long serialVersionUID = 380347456670516572L;
    private static final VerticalDatumType[] TYPES = VerticalDatumTypes.values();
    private static final short[] LEGACY_CODES = new short[TYPES.length];
    private final VerticalDatumType type;
    public static final DefaultVerticalDatum GEOIDAL;
    public static final DefaultVerticalDatum ELLIPSOIDAL;

    private DefaultVerticalDatum() {
        this(NullReferencingObject.INSTANCE);
    }

    public DefaultVerticalDatum(String string, VerticalDatumType verticalDatumType) {
        this(Collections.singletonMap("name", string), verticalDatumType);
    }

    public DefaultVerticalDatum(VerticalDatum verticalDatum) {
        super(verticalDatum);
        this.type = verticalDatum.getVerticalDatumType();
    }

    public DefaultVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) {
        super(map);
        this.type = verticalDatumType;
        DefaultVerticalDatum.ensureNonNull("type", verticalDatumType);
    }

    @Override
    public VerticalDatumType getVerticalDatumType() {
        return this.type;
    }

    @Override
    final int getLegacyDatumType() {
        int n = this.type.ordinal();
        if (n >= 0 && n < LEGACY_CODES.length) {
            assert (this.type.equals(TYPES[n])) : this.type;
            return LEGACY_CODES[n];
        }
        return 0;
    }

    public static VerticalDatumType getVerticalDatumTypeFromLegacyCode(int n) {
        for (int i = 0; i < LEGACY_CODES.length; ++i) {
            if (LEGACY_CODES[i] != n) continue;
            return TYPES[i];
        }
        return null;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultVerticalDatum defaultVerticalDatum = (DefaultVerticalDatum)abstractIdentifiedObject;
            return Utilities.equals(this.type, defaultVerticalDatum.type);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.type.hashCode();
    }

    @Override
    public String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        return "VERT_DATUM";
    }

    static {
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.GEOIDAL.ordinal()] = 2005;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumTypes.ELLIPSOIDAL.ordinal()] = 2002;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.DEPTH.ordinal()] = 2006;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.BAROMETRIC.ordinal()] = 2003;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumTypes.ORTHOMETRIC.ordinal()] = 2001;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.OTHER_SURFACE.ordinal()] = 2000;
        GEOIDAL = new DefaultVerticalDatum(DefaultVerticalDatum.name(114), VerticalDatumType.GEOIDAL);
        ELLIPSOIDAL = new DefaultVerticalDatum(DefaultVerticalDatum.name(80), VerticalDatumTypes.ELLIPSOIDAL);
    }
}

