/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class AuthorityFactoryAdapter
extends AbstractAuthorityFactory {
    static final int TYPE_COUNT = 4;
    private static final Class<? extends AuthorityFactory>[] TYPES = new Class[]{CRSAuthorityFactory.class, CSAuthorityFactory.class, DatumAuthorityFactory.class, CoordinateOperationAuthorityFactory.class};
    private static final Hints.Key[] HINT_KEYS = new Hints.Key[]{Hints.CRS_AUTHORITY_FACTORY, Hints.CS_AUTHORITY_FACTORY, Hints.DATUM_AUTHORITY_FACTORY, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY};
    private static final String[] NAMES = new String[]{"crsFactory", "csFactory", "datumFactory", "operationFactory"};
    private CRSAuthorityFactory crsFactory;
    private CSAuthorityFactory csFactory;
    private DatumAuthorityFactory datumFactory;
    private CoordinateOperationAuthorityFactory operationFactory;
    private long lastAttempt;
    private volatile Hints deferred;
    private static final Hints.Key AUTHORITY_KEY = new Hints.Key(String.class);

    final AuthorityFactory getFactory(int n) {
        switch (n) {
            case 0: {
                return this.crsFactory;
            }
            case 1: {
                return this.csFactory;
            }
            case 2: {
                return this.datumFactory;
            }
            case 3: {
                return this.operationFactory;
            }
        }
        throw new AssertionError(n);
    }

    private void setFactory(int n, AuthorityFactory authorityFactory) {
        switch (n) {
            case 0: {
                this.crsFactory = (CRSAuthorityFactory)authorityFactory;
                break;
            }
            case 1: {
                this.csFactory = (CSAuthorityFactory)authorityFactory;
                break;
            }
            case 2: {
                this.datumFactory = (DatumAuthorityFactory)authorityFactory;
                break;
            }
            case 3: {
                this.operationFactory = (CoordinateOperationAuthorityFactory)authorityFactory;
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
    }

    private void setFactory(int n, String string, Hints hints) throws FactoryRegistryException {
        switch (n) {
            case 0: {
                this.crsFactory = AuthorityFactoryFinder.getCRSAuthorityFactory(string, hints);
                break;
            }
            case 1: {
                this.csFactory = AuthorityFactoryFinder.getCSAuthorityFactory(string, hints);
                break;
            }
            case 2: {
                this.datumFactory = AuthorityFactoryFinder.getDatumAuthorityFactory(string, hints);
                break;
            }
            case 3: {
                this.operationFactory = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory(string, hints);
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
    }

    AuthorityFactoryAdapter() {
        super(EMPTY_HINTS);
    }

    protected AuthorityFactoryAdapter(AuthorityFactory authorityFactory) {
        this(authorityFactory, null);
    }

    AuthorityFactoryAdapter(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
        super(EMPTY_HINTS);
        for (int i = 0; i < TYPES.length; ++i) {
            AuthorityFactory authorityFactory3;
            Class<? extends AuthorityFactory> clazz = TYPES[i];
            if (clazz.isInstance(authorityFactory)) {
                authorityFactory3 = authorityFactory;
            } else {
                if (!clazz.isInstance(authorityFactory2)) continue;
                authorityFactory3 = authorityFactory2;
            }
            this.setFactory(i, authorityFactory3);
        }
        this.putFactoryHints();
    }

    protected AuthorityFactoryAdapter(CRSAuthorityFactory cRSAuthorityFactory, CSAuthorityFactory cSAuthorityFactory, DatumAuthorityFactory datumAuthorityFactory, CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory) {
        super(EMPTY_HINTS);
        this.crsFactory = cRSAuthorityFactory;
        this.csFactory = cSAuthorityFactory;
        this.datumFactory = datumAuthorityFactory;
        this.operationFactory = coordinateOperationAuthorityFactory;
        this.putFactoryHints();
    }

    protected AuthorityFactoryAdapter(String string, Hints hints) throws FactoryRegistryException {
        super(hints);
        if (string == null) {
            this.setFactories(string, hints);
        } else {
            this.deferred = (hints != null ? hints : EMPTY_HINTS).clone();
            this.deferred.put(AUTHORITY_KEY, string);
        }
    }

    private void setFactories(String string, Hints hints) throws FactoryRegistryException {
        for (int i = 0; i < 4; ++i) {
            Hints.Key key = HINT_KEYS[i];
            Hints hints2 = hints;
            if (hints != null) {
                for (int j = 0; j < HINT_KEYS.length; ++j) {
                    Hints.Key key2 = HINT_KEYS[j];
                    if (key.equals(key2)) continue;
                    if (hints2 == hints) {
                        if (!hints.containsKey(key2)) continue;
                        hints2 = hints.clone();
                    }
                    hints2.remove(key2);
                }
            }
            this.setFactory(i, string, hints2);
        }
        this.putFactoryHints();
    }

    private void putFactoryHints() {
        for (int i = 0; i < 4; ++i) {
            Hints.Key key;
            AuthorityFactory authorityFactory;
            AuthorityFactory authorityFactory2 = this.getFactory(i);
            Class<? extends AuthorityFactory> clazz = TYPES[i];
            if (clazz.isInstance(this)) {
                AuthorityFactoryAdapter.ensureNonNull(NAMES[i], authorityFactory2);
            }
            if (authorityFactory2 != null && (authorityFactory = this.hints.put(key = HINT_KEYS[i], authorityFactory2)) != null && authorityFactory != authorityFactory2) {
                throw new AssertionError(key);
            }
        }
    }

    final boolean isInitialized() {
        return this.deferred == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureInitialized() throws FactoryRegistryException {
        if (!this.isInitialized()) {
            AuthorityFactoryAdapter authorityFactoryAdapter = this;
            synchronized (authorityFactoryAdapter) {
                Hints hints = this.deferred;
                if (hints != null) {
                    String string = (String)hints.get(AUTHORITY_KEY);
                    this.toBackingFactoryHints(hints);
                    this.setFactories(string, hints);
                    this.putCustomHints();
                    this.deferred = null;
                }
            }
        }
    }

    void putCustomHints() {
    }

    final Hints dependencyHints() {
        this.ensureInitialized();
        Hints hints = EMPTY_HINTS.clone();
        hints.putAll((Map<?, ?>)this.hints);
        int n = 4;
        while (--n >= 0) {
            AuthorityFactory authorityFactory = this.getFactory(n);
            if (!(authorityFactory instanceof Factory)) continue;
            hints.putAll(((Factory)((Object)authorityFactory)).getImplementationHints());
        }
        hints.putAll((Map<?, ?>)this.hints);
        return hints;
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        try {
            object = this.getAuthorityFactory(null);
        }
        catch (FactoryException factoryException) {
            object = factoryException;
        }
        arrayList.add(object);
        return arrayList;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory authorityFactory) {
        if (super.sameAuthorityCodes(authorityFactory)) {
            return true;
        }
        if (!this.isCodeMethodOverriden()) {
            this.ensureInitialized();
            for (int i = 0; i < 4; ++i) {
                if (AuthorityFactoryAdapter.sameAuthorityCodes(this.getFactory(i), authorityFactory)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean sameAuthorityCodes(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
        if (authorityFactory instanceof AbstractAuthorityFactory && ((AbstractAuthorityFactory)authorityFactory).sameAuthorityCodes(authorityFactory2)) {
            return true;
        }
        return authorityFactory2 == authorityFactory || authorityFactory == null;
    }

    private boolean failedRecently(long l) {
        long l2 = this.lastAttempt;
        return l2 != 0L && l - l2 < 200L;
    }

    @Override
    public synchronized ConformanceResult availability() {
        long l = System.currentTimeMillis();
        if (this.failedRecently(l)) {
            return new Unavailable(null);
        }
        try {
            this.ensureInitialized();
        }
        catch (RuntimeException runtimeException) {
            Logging.recoverableException(LOGGER, AuthorityFactoryAdapter.class, "availability", runtimeException);
            this.lastAttempt = l;
            return new Factory.Availability(runtimeException);
        }
        for (int i = 0; i < 4; ++i) {
            ConformanceResult conformanceResult;
            AuthorityFactory authorityFactory = this.getFactory(i);
            if (!(authorityFactory instanceof Factory) || (conformanceResult = ((Factory)((Object)authorityFactory)).availability()).pass()) continue;
            this.lastAttempt = l;
            return new Unavailable(conformanceResult);
        }
        this.lastAttempt = 0L;
        return super.availability();
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        this.ensureInitialized();
        return super.getImplementationHints();
    }

    Unit<?> replace(Unit<?> unit) throws FactoryException {
        return unit;
    }

    CoordinateSystemAxis replace(CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        return coordinateSystemAxis;
    }

    <T extends CoordinateSystem> T replace(T t) throws FactoryException {
        return t;
    }

    <T extends Datum> T replace(T t) throws FactoryException {
        return t;
    }

    <T extends CoordinateReferenceSystem> T replace(T t) throws FactoryException {
        return t;
    }

    <T extends CoordinateOperation> T replace(T t) throws FactoryException {
        return t;
    }

    private IdentifiedObject replaceObject(IdentifiedObject identifiedObject) throws FactoryException {
        if (identifiedObject instanceof CoordinateReferenceSystem) {
            return this.replace((CoordinateReferenceSystem)identifiedObject);
        }
        if (identifiedObject instanceof CoordinateSystem) {
            return this.replace((CoordinateSystem)identifiedObject);
        }
        if (identifiedObject instanceof CoordinateSystemAxis) {
            return this.replace((CoordinateSystemAxis)identifiedObject);
        }
        if (identifiedObject instanceof Datum) {
            return this.replace((Datum)identifiedObject);
        }
        if (identifiedObject instanceof CoordinateOperation) {
            return this.replace((CoordinateOperation)identifiedObject);
        }
        return identifiedObject;
    }

    private AbstractAuthorityFactory getGeotoolkitFactory(String string, String string2) throws FactoryException {
        AuthorityFactory authorityFactory = this.getAuthorityFactory(string2);
        if (authorityFactory instanceof AbstractAuthorityFactory) {
            return (AbstractAuthorityFactory)authorityFactory;
        }
        if (string == null) {
            return null;
        }
        throw new FactoryException(Errors.format(57, string));
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getGeotoolkitFactory(null, null);
        return abstractAuthorityFactory != null ? abstractAuthorityFactory.getBackingStoreDescription() : null;
    }

    @Override
    final synchronized Citation getCitation(String string) {
        long l = System.currentTimeMillis();
        if (!this.failedRecently(l)) {
            try {
                this.lastAttempt = 0L;
                return AuthorityFactoryAdapter.getCitation(this.getAuthorityFactory(), string);
            }
            catch (FactoryNotFoundException factoryNotFoundException) {
                this.lastAttempt = l;
                Logging.recoverableException(LOGGER, AuthorityFactoryAdapter.class, string, factoryNotFoundException);
            }
        }
        return super.getCitation(string);
    }

    @Override
    public Citation getVendor() {
        return this.getCitation("getVendor");
    }

    @Override
    public Citation getAuthority() {
        return this.getCitation("getAuthority");
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return this.getAuthorityFactory(null).getAuthorityCodes(clazz);
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        return this.getAuthorityFactory(string).getDescriptionText(this.toBackingFactoryCode(string));
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.replaceObject(this.getAuthorityFactory(string).createObject(this.toBackingFactoryCode(string)));
    }

    @Override
    public Datum createDatum(String string) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(string).createDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String string) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(string).createEngineeringDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public ImageDatum createImageDatum(String string) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(string).createImageDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public VerticalDatum createVerticalDatum(String string) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(string).createVerticalDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public TemporalDatum createTemporalDatum(String string) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(string).createTemporalDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String string) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(string).createGeodeticDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws FactoryException {
        return this.getDatumAuthorityFactory(string).createEllipsoid(this.toBackingFactoryCode(string));
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws FactoryException {
        return this.getDatumAuthorityFactory(string).createPrimeMeridian(this.toBackingFactoryCode(string));
    }

    @Override
    public Extent createExtent(String string) throws FactoryException {
        return this.getGeotoolkitFactory("createExtent", string).createExtent(this.toBackingFactoryCode(string));
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createCoordinateSystem(this.toBackingFactoryCode(string)));
    }

    @Override
    public CartesianCS createCartesianCS(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createCartesianCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public PolarCS createPolarCS(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createPolarCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public CylindricalCS createCylindricalCS(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createCylindricalCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public SphericalCS createSphericalCS(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createSphericalCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createEllipsoidalCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public VerticalCS createVerticalCS(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createVerticalCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public TimeCS createTimeCS(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createTimeCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createCoordinateSystemAxis(this.toBackingFactoryCode(string)));
    }

    @Override
    public Unit<?> createUnit(String string) throws FactoryException {
        return this.replace((CoordinateOperation)((Object)this.getCSAuthorityFactory(string).createUnit(this.toBackingFactoryCode(string))));
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createCoordinateReferenceSystem(this.toBackingFactoryCode(string)));
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createCompoundCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createDerivedCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createEngineeringCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createGeographicCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createGeocentricCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createImageCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createProjectedCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createTemporalCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createVerticalCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String string) throws FactoryException {
        return this.getGeotoolkitFactory("createParameterDescriptor", string).createParameterDescriptor(this.toBackingFactoryCode(string));
    }

    @Override
    public OperationMethod createOperationMethod(String string) throws FactoryException {
        return this.getGeotoolkitFactory("createOperationMethod", string).createOperationMethod(this.toBackingFactoryCode(string));
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String string) throws FactoryException {
        return this.replace(this.getCoordinateOperationAuthorityFactory(string).createCoordinateOperation(this.toBackingFactoryCode(string)));
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory;
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory2 = this.getCoordinateOperationAuthorityFactory(string);
        if (coordinateOperationAuthorityFactory2 != (coordinateOperationAuthorityFactory = this.getCoordinateOperationAuthorityFactory(string2))) {
            LogRecord logRecord = Loggings.format(Level.WARNING, 34, string, string2);
            logRecord.setSourceMethodName("createFromCoordinateReferenceSystemCodes");
            logRecord.setSourceClassName(AuthorityFactoryAdapter.class.getName());
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
            return Collections.emptySet();
        }
        return coordinateOperationAuthorityFactory2.createFromCoordinateReferenceSystemCodes(this.toBackingFactoryCode(string), this.toBackingFactoryCode(string2));
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(clazz);
    }

    private FactoryException missingFactory(Class<?> clazz, String string) {
        return new NoSuchAuthorityCodeException(Errors.format(53, clazz), Citations.getIdentifier(this.getAuthority()), this.trimAuthority(string));
    }

    private AuthorityFactory getAuthorityFactory() throws FactoryRegistryException {
        try {
            return this.getAuthorityFactory(null);
        }
        catch (FactoryException factoryException) {
            throw new IllegalStateException(Errors.format(180), factoryException);
        }
    }

    protected <T extends AuthorityFactory> T getAuthorityFactory(Class<T> clazz, String string) throws FactoryException {
        AuthorityFactory authorityFactory;
        if (CRSAuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getCRSAuthorityFactory(string);
        } else if (CSAuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getCSAuthorityFactory(string);
        } else if (DatumAuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getDatumAuthorityFactory(string);
        } else if (CoordinateOperationAuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getCoordinateOperationAuthorityFactory(string);
        } else if (AuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getAuthorityFactory(string);
        } else {
            throw new IllegalArgumentException(Errors.format(198, clazz));
        }
        return (T)((AuthorityFactory)clazz.cast(authorityFactory));
    }

    protected AuthorityFactory getAuthorityFactory(String string) throws FactoryException {
        this.ensureInitialized();
        for (int i = 0; i < 4; ++i) {
            AuthorityFactory authorityFactory = this.getFactory(i);
            if (authorityFactory == null) continue;
            return authorityFactory;
        }
        throw this.missingFactory(AuthorityFactory.class, string);
    }

    protected DatumAuthorityFactory getDatumAuthorityFactory(String string) throws FactoryException {
        this.ensureInitialized();
        DatumAuthorityFactory datumAuthorityFactory = this.datumFactory;
        if (datumAuthorityFactory == null) {
            throw this.missingFactory(DatumAuthorityFactory.class, string);
        }
        return datumAuthorityFactory;
    }

    protected CSAuthorityFactory getCSAuthorityFactory(String string) throws FactoryException {
        this.ensureInitialized();
        CSAuthorityFactory cSAuthorityFactory = this.csFactory;
        if (cSAuthorityFactory == null) {
            throw this.missingFactory(CSAuthorityFactory.class, string);
        }
        return cSAuthorityFactory;
    }

    protected CRSAuthorityFactory getCRSAuthorityFactory(String string) throws FactoryException {
        this.ensureInitialized();
        CRSAuthorityFactory cRSAuthorityFactory = this.crsFactory;
        if (cRSAuthorityFactory == null) {
            throw this.missingFactory(CRSAuthorityFactory.class, string);
        }
        return cRSAuthorityFactory;
    }

    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String string) throws FactoryException {
        this.ensureInitialized();
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.operationFactory;
        if (coordinateOperationAuthorityFactory == null) {
            throw this.missingFactory(CoordinateOperationAuthorityFactory.class, string);
        }
        return coordinateOperationAuthorityFactory;
    }

    final CoordinateOperationFactory getCoordinateOperationFactory() throws FactoryException {
        Map<RenderingHints.Key, ?> map;
        Object obj;
        this.ensureInitialized();
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.operationFactory;
        if (coordinateOperationAuthorityFactory instanceof Factory && (obj = (map = ((Factory)((Object)coordinateOperationAuthorityFactory)).getImplementationHints()).get(Hints.COORDINATE_OPERATION_FACTORY)) instanceof CoordinateOperationFactory) {
            return (CoordinateOperationFactory)obj;
        }
        return AuthorityFactoryFinder.getCoordinateOperationFactory(this.dependencyHints());
    }

    void toBackingFactoryHints(Hints hints) {
    }

    protected String toBackingFactoryCode(String string) throws FactoryException {
        return string;
    }

    final boolean isCodeMethodOverriden() {
        Class[] classArray = new Class[]{String.class};
        Class<?> clazz = this.getClass();
        while (!AuthorityFactoryAdapter.class.equals(clazz)) {
            try {
                clazz.getDeclaredMethod("toBackingFactoryCode", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    class Finder
    extends IdentifiedObjectFinder.Adapter {
        private IdentifiedObject original;

        protected Finder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
            super(AuthorityFactoryAdapter.this.getGeotoolkitFactory("getIdentifiedObjectFinder", null).getIdentifiedObjectFinder(clazz));
        }

        @Override
        final IdentifiedObject create(String string, int n) throws FactoryException {
            switch (n) {
                case 0: {
                    this.original = super.create(string, n);
                    return this.original;
                }
                case 1: {
                    IdentifiedObject identifiedObject = AuthorityFactoryAdapter.this.replaceObject(this.original);
                    this.original = null;
                    return identifiedObject;
                }
            }
            return null;
        }
    }

    private final class Unavailable
    extends Factory.Availability {
        Unavailable(ConformanceResult conformanceResult) {
            super(conformanceResult instanceof Factory.Availability ? ((Factory.Availability)conformanceResult).getFailureCause() : null);
        }

        @Override
        public boolean pass() {
            return false;
        }
    }
}

