/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactoryProxy;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;

abstract class AuthorityFactoryProxy {
    private AuthorityFactoryProxy() {
    }

    public static AuthorityFactoryProxy getInstance(AuthorityFactory authorityFactory, Class<? extends IdentifiedObject> clazz) {
        return AuthorityFactoryProxy.getInstance(authorityFactory, clazz, true);
    }

    static AuthorityFactoryProxy getInstance(AuthorityFactory authorityFactory, Class<? extends IdentifiedObject> clazz, boolean bl) {
        AbstractAuthorityFactory.ensureNonNull("type", clazz);
        AbstractAuthorityFactory.ensureNonNull("factory", authorityFactory);
        AbstractAuthorityFactoryProxy<? extends IdentifiedObject> abstractAuthorityFactoryProxy = AbstractAuthorityFactoryProxy.getInstance(clazz);
        clazz = abstractAuthorityFactoryProxy.type.asSubclass(IdentifiedObject.class);
        if (bl && authorityFactory instanceof AbstractAuthorityFactory) {
            AbstractAuthorityFactoryProxy<? extends IdentifiedObject> abstractAuthorityFactoryProxy2 = abstractAuthorityFactoryProxy;
            return new Geotoolkit((AbstractAuthorityFactory)authorityFactory, abstractAuthorityFactoryProxy2);
        }
        if (authorityFactory instanceof CRSAuthorityFactory) {
            CRSAuthorityFactory cRSAuthorityFactory = (CRSAuthorityFactory)authorityFactory;
            if (clazz.equals(ProjectedCRS.class)) {
                return new Projected(cRSAuthorityFactory);
            }
            if (clazz.equals(GeographicCRS.class)) {
                return new Geographic(cRSAuthorityFactory);
            }
            if (clazz.equals(CoordinateReferenceSystem.class)) {
                return new CRS(cRSAuthorityFactory);
            }
        }
        return new Default(authorityFactory, clazz);
    }

    public abstract Class<? extends IdentifiedObject> getObjectType();

    public abstract AuthorityFactory getAuthorityFactory();

    public final Set<String> getAuthorityCodes() throws FactoryException {
        return this.getAuthorityFactory().getAuthorityCodes(this.getObjectType());
    }

    public abstract IdentifiedObject create(String var1) throws NoSuchAuthorityCodeException, FactoryException;

    public String toString() {
        return this.toString(AuthorityFactoryProxy.class);
    }

    final String toString(Class<?> clazz) {
        AuthorityFactory authorityFactory = this.getAuthorityFactory();
        return Classes.getShortName(clazz) + '[' + Classes.getShortName(this.getObjectType()) + " in " + Classes.getShortClassName(authorityFactory) + "(\"" + authorityFactory.getAuthority().getTitle() + "\")]";
    }

    private static class CRS
    extends AuthorityFactoryProxy {
        protected final CRSAuthorityFactory factory;

        protected CRS(CRSAuthorityFactory cRSAuthorityFactory) {
            this.factory = cRSAuthorityFactory;
        }

        public Class<? extends CoordinateReferenceSystem> getObjectType() {
            return CoordinateReferenceSystem.class;
        }

        @Override
        public final AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            return this.factory.createCoordinateReferenceSystem(string);
        }
    }

    private static final class Default
    extends AuthorityFactoryProxy {
        private static final Class<?>[] PARAMETERS = new Class[]{String.class};
        private final AuthorityFactory factory;
        private final Class<? extends IdentifiedObject> type;
        private final Method method;

        Default(AuthorityFactory authorityFactory, Class<? extends IdentifiedObject> clazz) throws IllegalArgumentException {
            this.factory = authorityFactory;
            this.type = clazz;
            Method[] methodArray = authorityFactory.getClass().getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.getName().startsWith("create") || !clazz.equals(method.getReturnType()) || !Arrays.equals(PARAMETERS, method.getParameterTypes())) continue;
                this.method = method;
                return;
            }
            throw new IllegalArgumentException(Errors.format(198, clazz));
        }

        @Override
        public Class<? extends IdentifiedObject> getObjectType() {
            return this.type;
        }

        @Override
        public AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            try {
                return (IdentifiedObject)this.method.invoke((Object)this.factory, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof FactoryException) {
                    throw (FactoryException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new FactoryException(throwable.getLocalizedMessage(), throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FactoryException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
            }
        }
    }

    private static final class Geographic
    extends CRS {
        protected Geographic(CRSAuthorityFactory cRSAuthorityFactory) {
            super(cRSAuthorityFactory);
        }

        public Class<GeographicCRS> getObjectType() {
            return GeographicCRS.class;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            return this.factory.createGeographicCRS(string);
        }
    }

    private static final class Geotoolkit
    extends AuthorityFactoryProxy {
        private final AbstractAuthorityFactory factory;
        private final AbstractAuthorityFactoryProxy<? extends IdentifiedObject> proxy;

        Geotoolkit(AbstractAuthorityFactory abstractAuthorityFactory, AbstractAuthorityFactoryProxy<? extends IdentifiedObject> abstractAuthorityFactoryProxy) {
            this.factory = abstractAuthorityFactory;
            this.proxy = abstractAuthorityFactoryProxy;
        }

        @Override
        public Class<? extends IdentifiedObject> getObjectType() {
            return this.proxy.type;
        }

        @Override
        public AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            return this.proxy.create(this.factory, string);
        }
    }

    private static final class Projected
    extends CRS {
        protected Projected(CRSAuthorityFactory cRSAuthorityFactory) {
            super(cRSAuthorityFactory);
        }

        public Class<ProjectedCRS> getObjectType() {
            return ProjectedCRS.class;
        }

        @Override
        public IdentifiedObject create(String string) throws FactoryException {
            return this.factory.createProjectedCRS(string);
        }
    }
}

