/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.lang.Buffered;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactoryProxy;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.referencing.factory.NoSuchFactoryException;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Exceptions;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.Cache;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

@Buffered
public class CachingAuthorityFactory
extends AbstractAuthorityFactory {
    static final int DEFAULT_MAX = 100;
    private final AbstractAuthorityFactory backingStore;
    private transient Object status;
    private final Cache<Object, Object> cache;
    private final Map<IdentifiedObject, IdentifiedObject> findPool = new WeakHashMap<IdentifiedObject, IdentifiedObject>();

    protected CachingAuthorityFactory(AbstractAuthorityFactory abstractAuthorityFactory) {
        this(abstractAuthorityFactory, 100);
    }

    protected CachingAuthorityFactory(AbstractAuthorityFactory abstractAuthorityFactory, int n) {
        super(abstractAuthorityFactory);
        if (abstractAuthorityFactory instanceof CachingAuthorityFactory) {
            LOGGER.warning("Factory is already caching.");
        }
        this.backingStore = abstractAuthorityFactory;
        CachingAuthorityFactory.ensureNotSmaller("maxStrongReferences", n, 0);
        this.cache = new Cache(20, n, false);
        Map map = this.hints;
        if (abstractAuthorityFactory instanceof DatumAuthorityFactory) {
            map.put(Hints.DATUM_AUTHORITY_FACTORY, abstractAuthorityFactory);
        }
        if (abstractAuthorityFactory instanceof CSAuthorityFactory) {
            map.put(Hints.CS_AUTHORITY_FACTORY, abstractAuthorityFactory);
        }
        if (abstractAuthorityFactory instanceof CRSAuthorityFactory) {
            map.put(Hints.CRS_AUTHORITY_FACTORY, abstractAuthorityFactory);
        }
        if (abstractAuthorityFactory instanceof CoordinateOperationAuthorityFactory) {
            map.put(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, abstractAuthorityFactory);
        }
    }

    CachingAuthorityFactory(Hints hints, int n) {
        super(hints);
        CachingAuthorityFactory.ensureNotSmaller("maxStrongReferences", n, 0);
        this.cache = new Cache(20, n, false);
        this.backingStore = null;
    }

    static void ensureNotSmaller(String string, int n, int n2) {
        if (n < n2) {
            throw new IllegalArgumentException(Errors.format(63, string, n));
        }
    }

    @Override
    final Collection<? super AuthorityFactory> dependencies() {
        Object object;
        try {
            AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
            this.release();
            object = abstractAuthorityFactory;
        }
        catch (FactoryException factoryException) {
            object = factoryException;
        }
        return Collections.singleton(object);
    }

    AbstractAuthorityFactory getBackingStore() throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.backingStore;
        if (abstractAuthorityFactory == null) {
            throw new FactoryException(Errors.format(44));
        }
        return abstractAuthorityFactory;
    }

    void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ConformanceResult availability() {
        Object object = this.status;
        if (object == null) {
            AbstractAuthorityFactory abstractAuthorityFactory = null;
            try {
                abstractAuthorityFactory = this.getBackingStore();
                try {
                    ConformanceResult conformanceResult = abstractAuthorityFactory.availability();
                    if (conformanceResult instanceof Factory.Availability) {
                        object = ((Factory.Availability)conformanceResult).getFailureCause();
                    }
                    if (object == null) {
                        object = conformanceResult.pass();
                    }
                }
                finally {
                    this.release();
                }
            }
            catch (FactoryException factoryException) {
                this.unavailable(factoryException, abstractAuthorityFactory);
                object = factoryException;
            }
            this.status = object;
        }
        if (object instanceof Throwable) {
            return new Factory.Availability((Throwable)object);
        }
        return new Factory.Availability(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean pass() {
                Class<CachingAuthorityFactory> clazz = CachingAuthorityFactory.class;
                synchronized (CachingAuthorityFactory.class) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return Boolean.TRUE.equals(CachingAuthorityFactory.this.status) && super.pass();
                }
            }
        };
    }

    final void unavailable(FactoryException factoryException, AbstractAuthorityFactory abstractAuthorityFactory) {
        Collection<? extends InternationalString> collection;
        assert (Thread.holdsLock(this));
        Level level = factoryException instanceof NoSuchFactoryException ? Level.CONFIG : Level.WARNING;
        Citation citation = abstractAuthorityFactory != null ? abstractAuthorityFactory.getAuthority() : CachingAuthorityFactory.getAuthority(this.getClass());
        InternationalString internationalString = null;
        if (citation != null) {
            internationalString = citation.getTitle();
            collection = citation.getAlternateTitles();
            if (collection != null) {
                for (InternationalString internationalString2 : collection) {
                    if (internationalString != null && internationalString2.length() <= internationalString.length()) continue;
                    internationalString = internationalString2;
                }
            }
        }
        if (internationalString == null) {
            internationalString = Vocabulary.formatInternational(280);
        }
        collection = new LogRecord(level, Exceptions.formatChainedMessages(Loggings.getResources(null).getString(49, internationalString), factoryException));
        ((LogRecord)((Object)collection)).setSourceClassName(this.getClass().getCanonicalName());
        ((LogRecord)((Object)collection)).setSourceMethodName("availability");
        ((LogRecord)((Object)collection)).setThrown(factoryException);
        ((LogRecord)((Object)collection)).setLoggerName(LOGGER.getName());
        LOGGER.log((LogRecord)((Object)collection));
    }

    @Override
    final boolean sameAuthorityCodes(AuthorityFactory authorityFactory) {
        AbstractAuthorityFactory abstractAuthorityFactory = this.backingStore;
        if (abstractAuthorityFactory != null && abstractAuthorityFactory.sameAuthorityCodes(authorityFactory)) {
            return true;
        }
        return super.sameAuthorityCodes(authorityFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final Citation getCitation(String string) {
        if (this.availability().pass()) {
            AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
            try {
                Citation citation = CachingAuthorityFactory.getCitation(abstractAuthorityFactory, string);
                this.release();
                return citation;
            }
            catch (Throwable throwable) {
                try {
                    this.release();
                    throw throwable;
                }
                catch (FactoryException factoryException) {
                    Logging.recoverableException(LOGGER, CachingAuthorityFactory.class, string, factoryException);
                }
            }
        }
        return super.getCitation(string);
    }

    @Override
    public Citation getVendor() {
        return this.getCitation("getVendor");
    }

    @Override
    public Citation getAuthority() {
        return this.getCitation("getAuthority");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBackingStoreDescription() throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
        try {
            String string = abstractAuthorityFactory.getBackingStoreDescription();
            return string;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
        try {
            Set<String> set = abstractAuthorityFactory.getAuthorityCodes(clazz);
            return set;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternationalString getDescriptionText(String string) throws NoSuchAuthorityCodeException, FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
        try {
            InternationalString internationalString = abstractAuthorityFactory.getDescriptionText(string);
            return internationalString;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T create(AbstractAuthorityFactoryProxy<T> abstractAuthorityFactoryProxy, String string) throws FactoryException {
        Object object;
        Class clazz;
        block7: {
            clazz = abstractAuthorityFactoryProxy.type;
            String string2 = this.trimAuthority(string);
            object = this.cache.peek(string2);
            if (!clazz.isInstance(object)) {
                Cache.Handler<Object> handler = this.cache.lock(string2);
                try {
                    T t;
                    object = handler.peek();
                    if (clazz.isInstance(object)) break block7;
                    AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
                    try {
                        t = abstractAuthorityFactoryProxy.create(abstractAuthorityFactory, string);
                    }
                    finally {
                        this.release();
                    }
                    object = t;
                    T t2 = t;
                    return t2;
                }
                finally {
                    handler.putAndUnlock(object);
                }
            }
        }
        return clazz.cast(object);
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.OBJECT, string);
    }

    @Override
    public Datum createDatum(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.DATUM, string);
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.ENGINEERING_DATUM, string);
    }

    @Override
    public ImageDatum createImageDatum(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.IMAGE_DATUM, string);
    }

    @Override
    public VerticalDatum createVerticalDatum(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.VERTICAL_DATUM, string);
    }

    @Override
    public TemporalDatum createTemporalDatum(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.TEMPORAL_DATUM, string);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.GEODETIC_DATUM, string);
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.ELLIPSOID, string);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.PRIME_MERIDIAN, string);
    }

    @Override
    public Extent createExtent(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.EXTENT, string);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.COORDINATE_SYSTEM, string);
    }

    @Override
    public CartesianCS createCartesianCS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.CARTESIAN_CS, string);
    }

    @Override
    public PolarCS createPolarCS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.POLAR_CS, string);
    }

    @Override
    public CylindricalCS createCylindricalCS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.CYLINDRICAL_CS, string);
    }

    @Override
    public SphericalCS createSphericalCS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.SPHERICAL_CS, string);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.ELLIPSOIDAL_CS, string);
    }

    @Override
    public VerticalCS createVerticalCS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.VERTICAL_CS, string);
    }

    @Override
    public TimeCS createTimeCS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.TIME_CS, string);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.AXIS, string);
    }

    @Override
    public Unit<?> createUnit(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.UNIT, string);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.CRS, string);
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.COMPOUND_CRS, string);
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.DERIVED_CRS, string);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.ENGINEERING_CRS, string);
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.GEOGRAPHIC_CRS, string);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.GEOCENTRIC_CRS, string);
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.IMAGE_CRS, string);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.PROJECTED_CRS, string);
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.TEMPORAL_CRS, string);
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.VERTICAL_CRS, string);
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.PARAMETER, string);
    }

    @Override
    public OperationMethod createOperationMethod(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.METHOD, string);
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String string) throws FactoryException {
        return this.create(AbstractAuthorityFactoryProxy.OPERATION, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        Object object;
        CodePair codePair = new CodePair(this.trimAuthority(string), this.trimAuthority(string2));
        Object object2 = this.cache.peek(codePair);
        if (!(object2 instanceof Set)) {
            object = this.cache.lock(codePair);
            try {
                object2 = object.peek();
                if (!(object2 instanceof Set)) {
                    AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
                    try {
                        Set<CoordinateOperation> set;
                        object2 = set = Collections.unmodifiableSet(abstractAuthorityFactory.createFromCoordinateReferenceSystemCodes(string, string2));
                        Set<CoordinateOperation> set2 = set;
                        this.release();
                        return set2;
                    }
                    catch (Throwable throwable) {
                        this.release();
                        throw throwable;
                    }
                }
            }
            finally {
                object.putAndUnlock(object2);
            }
        }
        object = (Set)object2;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
        try {
            Finder finder = new Finder(abstractAuthorityFactory.getIdentifiedObjectFinder(clazz));
            return finder;
        }
        finally {
            this.release();
        }
    }

    protected void setKeyCollisionAllowed(boolean bl) {
        this.cache.setKeyCollisionAllowed(bl);
    }

    @Override
    protected synchronized void dispose(boolean bl) {
        this.cache.clear();
        AbstractAuthorityFactory abstractAuthorityFactory = this.backingStore;
        if (abstractAuthorityFactory != null) {
            abstractAuthorityFactory.dispose(bl);
        }
        super.dispose(bl);
    }

    private static final class CodePair {
        private final String source;
        private final String target;

        public CodePair(String string, String string2) {
            this.source = string;
            this.target = string2;
        }

        public int hashCode() {
            int n = 0;
            if (this.source != null) {
                n = this.source.hashCode();
            }
            if (this.target != null) {
                n += this.target.hashCode() * 31;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof CodePair) {
                CodePair codePair = (CodePair)object;
                return Utilities.equals(this.source, codePair.source) && Utilities.equals(this.target, codePair.target);
            }
            return false;
        }

        public String toString() {
            return this.source + " \u21e8 " + this.target;
        }
    }

    private final class Finder
    extends IdentifiedObjectFinder.Adapter {
        Finder(IdentifiedObjectFinder identifiedObjectFinder) {
            super(identifiedObjectFinder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObject identifiedObject2;
            Map map = CachingAuthorityFactory.this.findPool;
            synchronized (map) {
                identifiedObject2 = (IdentifiedObject)CachingAuthorityFactory.this.findPool.get(identifiedObject);
            }
            if (identifiedObject2 == null && (identifiedObject2 = this.finder.find(identifiedObject)) != null) {
                map = CachingAuthorityFactory.this.findPool;
                synchronized (map) {
                    CachingAuthorityFactory.this.findPool.put(identifiedObject, identifiedObject2);
                }
            }
            return identifiedObject2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObject identifiedObject2;
            Map map = CachingAuthorityFactory.this.findPool;
            synchronized (map) {
                identifiedObject2 = (IdentifiedObject)CachingAuthorityFactory.this.findPool.get(identifiedObject);
            }
            if (identifiedObject2 != null) {
                return this.getIdentifier(identifiedObject2);
            }
            return this.finder.findIdentifier(identifiedObject);
        }
    }
}

