/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.AuthorityFactoryAdapter;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.collection.WeakValueHashMap;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class FallbackAuthorityFactory
extends AuthorityFactoryAdapter {
    private final AbstractAuthorityFactory fallback;
    private static final Map<Key, AuthorityFactory> POOL = new WeakValueHashMap<Key, AuthorityFactory>();
    private static final AtomicInteger failureCount = new AtomicInteger();

    static boolean chainable(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
        return (FallbackAuthorityFactory.interfaceMask(authorityFactory) & FallbackAuthorityFactory.interfaceMask(authorityFactory2)) != 0;
    }

    protected FallbackAuthorityFactory(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
        super(authorityFactory, authorityFactory2);
        FallbackAuthorityFactory.ensureNonNull("fallback", authorityFactory2);
        this.fallback = authorityFactory2 instanceof AbstractAuthorityFactory ? (AbstractAuthorityFactory)authorityFactory2 : new AuthorityFactoryAdapter(authorityFactory2);
    }

    public static <T extends AuthorityFactory> T create(Class<T> clazz, T ... TArray) throws FactoryNotFoundException, ClassCastException {
        return FallbackAuthorityFactory.create(clazz, Arrays.asList(TArray));
    }

    public static <T extends AuthorityFactory> T create(Class<T> clazz, Collection<T> collection) throws FactoryNotFoundException, ClassCastException {
        FallbackAuthorityFactory.ensureNonNull("type", clazz);
        FallbackAuthorityFactory.ensureNonNull("factories", collection);
        if (collection.isEmpty()) {
            throw new FactoryNotFoundException(Errors.format(53, clazz));
        }
        return (T)((AuthorityFactory)clazz.cast(FallbackAuthorityFactory.create(false, FallbackAuthorityFactory.interfaceMask(clazz), collection.iterator())));
    }

    public static AuthorityFactory create(Collection<? extends AuthorityFactory> collection) throws FactoryNotFoundException {
        FallbackAuthorityFactory.ensureNonNull("factories", collection);
        if (collection.isEmpty()) {
            throw new FactoryNotFoundException(Errors.format(53, AuthorityFactory.class));
        }
        return FallbackAuthorityFactory.create(false, FallbackAuthorityFactory.interfaceMask(collection), collection.iterator());
    }

    private static AuthorityFactory create(boolean bl, int n, Iterator<? extends AuthorityFactory> iterator) throws FactoryNotFoundException {
        AuthorityFactory authorityFactory = iterator.next();
        if (iterator.hasNext()) {
            AuthorityFactory authorityFactory2 = FallbackAuthorityFactory.create(true, n, iterator);
            while (authorityFactory2 != authorityFactory) {
                if (!FallbackAuthorityFactory.sameAuthorityCodes(authorityFactory2, authorityFactory)) {
                    if (bl) {
                        n &= FallbackAuthorityFactory.interfaceMask(authorityFactory) | FallbackAuthorityFactory.interfaceMask(authorityFactory2);
                    }
                    authorityFactory = FallbackAuthorityFactory.create(n, authorityFactory, authorityFactory2);
                    break;
                }
                if (!(authorityFactory2 instanceof FallbackAuthorityFactory)) break;
                authorityFactory2 = ((FallbackAuthorityFactory)authorityFactory2).fallback;
            }
        }
        return authorityFactory;
    }

    @Override
    final Collection<? super AuthorityFactory> dependencies() {
        Collection<? super AuthorityFactory> collection = super.dependencies();
        collection.add(this.fallback);
        return collection;
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(super.getAuthorityCodes(clazz));
        linkedHashSet.addAll(this.fallback.getAuthorityCodes(clazz));
        return linkedHashSet;
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        try {
            return super.getDescriptionText(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("getDescriptionText", factoryException);
            try {
                return this.fallback.getDescriptionText(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        try {
            return super.createObject(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createObject", factoryException);
            try {
                return this.fallback.createObject(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public org.opengis.referencing.datum.Datum createDatum(String string) throws FactoryException {
        try {
            return super.createDatum(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createDatum", factoryException);
            try {
                return this.fallback.createDatum(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String string) throws FactoryException {
        try {
            return super.createEngineeringDatum(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createEngineeringDatum", factoryException);
            try {
                return this.fallback.createEngineeringDatum(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public ImageDatum createImageDatum(String string) throws FactoryException {
        try {
            return super.createImageDatum(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createImageDatum", factoryException);
            try {
                return this.fallback.createImageDatum(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public VerticalDatum createVerticalDatum(String string) throws FactoryException {
        try {
            return super.createVerticalDatum(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createVerticalDatum", factoryException);
            try {
                return this.fallback.createVerticalDatum(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public TemporalDatum createTemporalDatum(String string) throws FactoryException {
        try {
            return super.createTemporalDatum(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createTemporalDatum", factoryException);
            try {
                return this.fallback.createTemporalDatum(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String string) throws FactoryException {
        try {
            return super.createGeodeticDatum(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createGeodeticDatum", factoryException);
            try {
                return this.fallback.createGeodeticDatum(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws FactoryException {
        try {
            return super.createEllipsoid(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createEllipsoid", factoryException);
            try {
                return this.fallback.createEllipsoid(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws FactoryException {
        try {
            return super.createPrimeMeridian(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createPrimeMeridian", factoryException);
            try {
                return this.fallback.createPrimeMeridian(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public Extent createExtent(String string) throws FactoryException {
        try {
            return super.createExtent(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createExtent", factoryException);
            try {
                return this.fallback.createExtent(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String string) throws FactoryException {
        try {
            return super.createCoordinateSystem(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateSystem", factoryException);
            try {
                return this.fallback.createCoordinateSystem(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public CartesianCS createCartesianCS(String string) throws FactoryException {
        try {
            return super.createCartesianCS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createCartesianCS", factoryException);
            try {
                return this.fallback.createCartesianCS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public PolarCS createPolarCS(String string) throws FactoryException {
        try {
            return super.createPolarCS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createPolarCS", factoryException);
            try {
                return this.fallback.createPolarCS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public CylindricalCS createCylindricalCS(String string) throws FactoryException {
        try {
            return super.createCylindricalCS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createCylindricalCS", factoryException);
            try {
                return this.fallback.createCylindricalCS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public SphericalCS createSphericalCS(String string) throws FactoryException {
        try {
            return super.createSphericalCS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createSphericalCS", factoryException);
            try {
                return this.fallback.createSphericalCS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String string) throws FactoryException {
        try {
            return super.createEllipsoidalCS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createEllipsoidalCS", factoryException);
            try {
                return this.fallback.createEllipsoidalCS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public VerticalCS createVerticalCS(String string) throws FactoryException {
        try {
            return super.createVerticalCS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createVerticalCS", factoryException);
            try {
                return this.fallback.createVerticalCS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public TimeCS createTimeCS(String string) throws FactoryException {
        try {
            return super.createTimeCS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createTimeCS", factoryException);
            try {
                return this.fallback.createTimeCS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws FactoryException {
        try {
            return super.createCoordinateSystemAxis(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateSystemAxis", factoryException);
            try {
                return this.fallback.createCoordinateSystemAxis(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public Unit<?> createUnit(String string) throws FactoryException {
        try {
            return super.createUnit(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createUnit", factoryException);
            try {
                return this.fallback.createUnit(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        try {
            return super.createCoordinateReferenceSystem(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateReferenceSystem", factoryException);
            try {
                return this.fallback.createCoordinateReferenceSystem(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        try {
            return super.createCompoundCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createCompoundCRS", factoryException);
            try {
                return this.fallback.createCompoundCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        try {
            return super.createDerivedCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createDerivedCRS", factoryException);
            try {
                return this.fallback.createDerivedCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        try {
            return super.createEngineeringCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createEngineeringCRS", factoryException);
            try {
                return this.fallback.createEngineeringCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        try {
            return super.createGeographicCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createGeographicCRS", factoryException);
            try {
                return this.fallback.createGeographicCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        try {
            return super.createGeocentricCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createGeocentricCRS", factoryException);
            try {
                return this.fallback.createGeocentricCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        try {
            return super.createImageCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createImageCRS", factoryException);
            try {
                return this.fallback.createImageCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        try {
            return super.createProjectedCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createProjectedCRS", factoryException);
            try {
                return this.fallback.createProjectedCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        try {
            return super.createTemporalCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createTemporalCRS", factoryException);
            try {
                return this.fallback.createTemporalCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        try {
            return super.createVerticalCRS(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createVerticalCRS", factoryException);
            try {
                return this.fallback.createVerticalCRS(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String string) throws FactoryException {
        try {
            return super.createParameterDescriptor(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createParameterDescriptor", factoryException);
            try {
                return this.fallback.createParameterDescriptor(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public OperationMethod createOperationMethod(String string) throws FactoryException {
        try {
            return super.createOperationMethod(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createOperationMethod", factoryException);
            try {
                return this.fallback.createOperationMethod(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String string) throws FactoryException {
        try {
            return super.createCoordinateOperation(string);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateOperation", factoryException);
            try {
                return this.fallback.createCoordinateOperation(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        try {
            return super.createFromCoordinateReferenceSystemCodes(string, string2);
        }
        catch (FactoryException factoryException) {
            FallbackAuthorityFactory.notifyFailure("createFromCoordinateReferenceSystemCodes", factoryException);
            try {
                return this.fallback.createFromCoordinateReferenceSystemCodes(string, string2);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                throw factoryException;
            }
        }
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(clazz);
    }

    private static void notifyFailure(String string, FactoryException factoryException) {
        failureCount.incrementAndGet();
        if (LOGGER.isLoggable(Level.FINE)) {
            LogRecord logRecord = Loggings.format(Level.FINE, 27, factoryException);
            logRecord.setSourceClassName(FallbackAuthorityFactory.class.getName());
            logRecord.setSourceMethodName(string);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    static int getFailureCount() {
        return failureCount.get();
    }

    private static int interfaceMask(Collection<? extends AuthorityFactory> collection) {
        int n = 0;
        for (AuthorityFactory authorityFactory : collection) {
            n |= FallbackAuthorityFactory.interfaceMask(authorityFactory);
        }
        return n;
    }

    private static int interfaceMask(AuthorityFactory authorityFactory) {
        return FallbackAuthorityFactory.interfaceMask(authorityFactory.getClass());
    }

    private static int interfaceMask(Class<? extends AuthorityFactory> clazz) {
        int n = 0;
        if (CoordinateOperationAuthorityFactory.class.isAssignableFrom(clazz)) {
            n |= 1;
        }
        if (CSAuthorityFactory.class.isAssignableFrom(clazz)) {
            n |= 2;
        }
        if (DatumAuthorityFactory.class.isAssignableFrom(clazz)) {
            n |= 4;
        }
        if (CRSAuthorityFactory.class.isAssignableFrom(clazz)) {
            n |= 8;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthorityFactory create(int n, AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
        AuthorityFactory authorityFactory3;
        assert ((n & ~(FallbackAuthorityFactory.interfaceMask(authorityFactory) | FallbackAuthorityFactory.interfaceMask(authorityFactory2))) == 0) : n;
        Key key = new Key(n, authorityFactory, authorityFactory2);
        Map<Key, AuthorityFactory> map = POOL;
        synchronized (map) {
            authorityFactory3 = POOL.get(key);
            if (authorityFactory3 == null) {
                switch (n) {
                    case 15: {
                        authorityFactory3 = new All(authorityFactory, authorityFactory2);
                        break;
                    }
                    case 14: {
                        authorityFactory3 = new CRS_Datum_CS(authorityFactory, authorityFactory2);
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        authorityFactory3 = new CRS(authorityFactory, authorityFactory2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        authorityFactory3 = new Datum(authorityFactory, authorityFactory2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        authorityFactory3 = new CS(authorityFactory, authorityFactory2);
                        break;
                    }
                    case 1: {
                        authorityFactory3 = new Operation(authorityFactory, authorityFactory2);
                        break;
                    }
                    case 0: {
                        authorityFactory3 = new FallbackAuthorityFactory(authorityFactory, authorityFactory2);
                        break;
                    }
                    default: {
                        throw new AssertionError(n);
                    }
                }
                POOL.put(key, authorityFactory3);
            }
        }
        assert ((FallbackAuthorityFactory.interfaceMask(authorityFactory3) & ~n) == 0) : n;
        return authorityFactory3;
    }

    private static final class All
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory,
    CSAuthorityFactory,
    DatumAuthorityFactory,
    CoordinateOperationAuthorityFactory {
        All(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
            super(authorityFactory, authorityFactory2);
        }
    }

    private static final class CRS
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory {
        CRS(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
            super(authorityFactory, authorityFactory2);
        }
    }

    private static final class CRS_Datum_CS
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory,
    CSAuthorityFactory,
    DatumAuthorityFactory {
        CRS_Datum_CS(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
            super(authorityFactory, authorityFactory2);
        }
    }

    private static final class CS
    extends FallbackAuthorityFactory
    implements CSAuthorityFactory {
        CS(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
            super(authorityFactory, authorityFactory2);
        }
    }

    private static final class Datum
    extends FallbackAuthorityFactory
    implements DatumAuthorityFactory {
        Datum(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
            super(authorityFactory, authorityFactory2);
        }
    }

    private final class Finder
    extends AuthorityFactoryAdapter.Finder {
        private transient IdentifiedObjectFinder fallback;

        Finder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
            super(clazz);
        }

        private void ensureFallback() throws FactoryException {
            if (this.fallback == null) {
                this.fallback = FallbackAuthorityFactory.this.fallback.getIdentifiedObjectFinder(this.proxy.getObjectType());
            }
            this.fallback.setFullScanAllowed(this.isFullScanAllowed());
        }

        @Override
        public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObject identifiedObject2 = this.finder.find(identifiedObject);
            if (identifiedObject2 != null) {
                return identifiedObject2;
            }
            this.ensureFallback();
            identifiedObject2 = this.fallback.find(identifiedObject);
            return identifiedObject2;
        }

        @Override
        public String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
            String string = this.finder.findIdentifier(identifiedObject);
            if (string != null) {
                return string;
            }
            this.ensureFallback();
            string = this.fallback.findIdentifier(identifiedObject);
            return string;
        }
    }

    private static final class Key {
        private final int mask;
        private final AuthorityFactory primary;
        private final AuthorityFactory fallback;

        Key(int n, AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
            this.mask = n;
            this.primary = authorityFactory;
            this.fallback = authorityFactory2;
        }

        public int hashCode() {
            return this.mask + 31 * (System.identityHashCode(this.primary) + 31 * System.identityHashCode(this.fallback));
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.mask == key.mask && this.primary == key.primary && this.fallback == key.fallback;
            }
            return false;
        }
    }

    private static final class Operation
    extends FallbackAuthorityFactory
    implements CoordinateOperationAuthorityFactory {
        Operation(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
            super(authorityFactory, authorityFactory2);
        }
    }
}

