/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.factory.AuthorityFactoryProxy;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

public class IdentifiedObjectFinder {
    final AuthorityFactoryProxy proxy;
    private boolean fullScan = true;

    IdentifiedObjectFinder(IdentifiedObjectFinder identifiedObjectFinder) {
        this.proxy = identifiedObjectFinder.proxy;
    }

    protected IdentifiedObjectFinder(AuthorityFactory authorityFactory, Class<? extends IdentifiedObject> clazz) {
        this.proxy = AuthorityFactoryProxy.getInstance(authorityFactory, clazz);
    }

    public Citation getAuthority() {
        return this.proxy.getAuthorityFactory().getAuthority();
    }

    public boolean isFullScanAllowed() {
        return this.fullScan;
    }

    public void setFullScanAllowed(boolean bl) {
        this.fullScan = bl;
    }

    public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
        IdentifiedObject identifiedObject2 = this.createFromIdentifiers(identifiedObject);
        if (identifiedObject2 != null) {
            return identifiedObject2;
        }
        identifiedObject2 = this.createFromNames(identifiedObject);
        if (identifiedObject2 != null) {
            return identifiedObject2;
        }
        return this.fullScan ? this.createFromCodes(identifiedObject) : null;
    }

    public String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
        IdentifiedObject identifiedObject2 = this.find(identifiedObject);
        return identifiedObject2 != null ? this.getIdentifier(identifiedObject2) : null;
    }

    final String getIdentifier(IdentifiedObject identifiedObject) {
        ReferenceIdentifier referenceIdentifier;
        Citation citation = this.getAuthority();
        if (ReferencingFactory.ALL.equals(citation)) {
            citation = null;
        }
        if ((referenceIdentifier = AbstractIdentifiedObject.getIdentifier(identifiedObject, citation)) == null) {
            referenceIdentifier = identifiedObject.getName();
        }
        String string = referenceIdentifier.getCode();
        String string2 = referenceIdentifier.getCodeSpace();
        if (string2 != null) {
            return string2 + ':' + string;
        }
        return string;
    }

    final IdentifiedObject createFromIdentifiers(IdentifiedObject identifiedObject) throws FactoryException {
        Citation citation = this.getAuthority();
        boolean bl = ReferencingFactory.ALL.equals(citation);
        block2: for (ReferenceIdentifier referenceIdentifier : identifiedObject.getIdentifiers()) {
            if (!bl && !Citations.identifierMatches(citation, referenceIdentifier.getAuthority())) continue;
            String string = referenceIdentifier.toString();
            int n = 0;
            while (true) {
                block5: {
                    IdentifiedObject identifiedObject2;
                    try {
                        identifiedObject2 = this.create(string, n);
                    }
                    catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                        break block5;
                    }
                    if (identifiedObject2 == null) continue block2;
                    if (CRS.equalsIgnoreMetadata(identifiedObject2, identifiedObject)) {
                        return identifiedObject2;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    final IdentifiedObject createFromNames(IdentifiedObject identifiedObject) throws FactoryException {
        String string = identifiedObject.getName().getCode();
        int n = 0;
        while (true) {
            block9: {
                IdentifiedObject object;
                try {
                    object = this.create(string, n);
                }
                catch (FactoryException factoryException) {
                    break block9;
                }
                if (object == null) break;
                if (CRS.equalsIgnoreMetadata(object, identifiedObject)) {
                    return object;
                }
            }
            ++n;
        }
        block5: for (GenericName genericName : identifiedObject.getAlias()) {
            string = ((Object)genericName).toString();
            int n2 = 0;
            while (true) {
                block10: {
                    IdentifiedObject identifiedObject2;
                    try {
                        identifiedObject2 = this.create(string, n2);
                    }
                    catch (FactoryException factoryException) {
                        break block10;
                    }
                    if (identifiedObject2 == null) continue block5;
                    if (CRS.equalsIgnoreMetadata(identifiedObject2, identifiedObject)) {
                        return identifiedObject2;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    final IdentifiedObject createFromCodes(IdentifiedObject identifiedObject) throws FactoryException {
        Set<String> set = this.getCodeCandidates(identifiedObject);
        block2: for (String string : set) {
            int n = 0;
            while (true) {
                block6: {
                    IdentifiedObject identifiedObject2;
                    try {
                        identifiedObject2 = this.create(string, n);
                    }
                    catch (FactoryException factoryException) {
                        break block6;
                    }
                    if (identifiedObject2 == null) continue block2;
                    if (CRS.equalsIgnoreMetadata(identifiedObject2, identifiedObject)) {
                        return identifiedObject2;
                    }
                }
                ++n;
            }
        }
        Logger logger = Logging.getLogger(IdentifiedObjectFinder.class);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("No match found for \"" + identifiedObject.getName() + "\" among " + set);
        }
        return null;
    }

    IdentifiedObject create(String string, int n) throws FactoryException {
        return n == 0 ? this.proxy.create(string) : null;
    }

    protected Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
        return this.proxy.getAuthorityCodes();
    }

    public String toString() {
        return this.proxy.toString(IdentifiedObjectFinder.class);
    }

    static class Adapter
    extends IdentifiedObjectFinder {
        protected final IdentifiedObjectFinder finder;

        protected Adapter(IdentifiedObjectFinder identifiedObjectFinder) {
            super(identifiedObjectFinder);
            this.finder = identifiedObjectFinder;
        }

        @Override
        public void setFullScanAllowed(boolean bl) {
            this.finder.setFullScanAllowed(bl);
            super.setFullScanAllowed(bl);
        }

        @Override
        protected Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
            return this.finder.getCodeCandidates(identifiedObject);
        }

        @Override
        IdentifiedObject create(String string, int n) throws FactoryException {
            return this.finder.create(string, n);
        }
    }
}

