/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.AuthorityFactoryProxy;
import org.geotoolkit.referencing.factory.BackingStoreException;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.ReferenceIdentifier;

public class IdentifiedObjectSet<T extends IdentifiedObject>
extends AbstractSet<T>
implements Serializable {
    private static final long serialVersionUID = -4221260663706882719L;
    private final Map<String, T> objects = new LinkedHashMap<String, T>();
    private final AuthorityFactoryProxy proxy;
    protected final Class<T> type;

    public IdentifiedObjectSet(AuthorityFactory authorityFactory, Class<T> clazz) {
        this.proxy = AuthorityFactoryProxy.getInstance(authorityFactory, clazz);
        this.type = clazz;
    }

    @Override
    public void clear() {
        this.objects.clear();
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    public boolean addAuthorityCode(String string) {
        boolean bl = this.objects.containsKey(string);
        IdentifiedObject identifiedObject = this.objects.put(string, null);
        if (identifiedObject != null) {
            this.objects.put(string, identifiedObject);
            return false;
        }
        return !bl;
    }

    @Override
    public boolean add(T t) {
        String string = this.getAuthorityCode(t);
        return !Utilities.equals(this.objects.put(string, t), t);
    }

    private T get(String string) throws BackingStoreException {
        IdentifiedObject identifiedObject = (IdentifiedObject)this.objects.get(string);
        if (identifiedObject == null && this.objects.containsKey(string)) {
            try {
                identifiedObject = this.createObject(string);
                this.objects.put(string, identifiedObject);
            }
            catch (FactoryException factoryException) {
                if (!this.isRecoverableFailure(factoryException)) {
                    throw new BackingStoreException(factoryException);
                }
                IdentifiedObjectSet.log(factoryException, string);
                this.objects.remove(string);
            }
        }
        return (T)identifiedObject;
    }

    @Override
    public boolean contains(Object object) {
        String string = this.getAuthorityCode((IdentifiedObject)this.type.cast(object));
        T t = this.get(string);
        return object.equals(t);
    }

    @Override
    public boolean remove(Object object) {
        String string = this.getAuthorityCode((IdentifiedObject)this.type.cast(object));
        T t = this.get(string);
        if (object.equals(t)) {
            this.objects.remove(string);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter(this.objects.entrySet().iterator());
    }

    public void resolve(int n) throws FactoryException {
        if (n > 0) {
            try {
                for (IdentifiedObject identifiedObject : this) {
                    if (--n != 0) continue;
                    break;
                }
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrap();
            }
        }
    }

    public String[] getAuthorityCodes() {
        Set<String> set = this.objects.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void setAuthorityCodes(String[] stringArray) {
        HashMap<String, T> hashMap = new HashMap<String, T>(this.objects);
        this.objects.clear();
        for (String string : stringArray) {
            this.objects.put(string, hashMap.get(string));
        }
    }

    protected String getAuthorityCode(T t) {
        Set<ReferenceIdentifier> set = t.getIdentifiers();
        Identifier identifier = set != null && !set.isEmpty() ? (Identifier)set.iterator().next() : t.getName();
        return identifier.getCode();
    }

    protected AuthorityFactory getAuthorityFactory() {
        return this.proxy.getAuthorityFactory();
    }

    protected T createObject(String string) throws FactoryException {
        return (T)((IdentifiedObject)this.type.cast(this.getAuthorityFactory().createObject(string)));
    }

    protected boolean isRecoverableFailure(FactoryException factoryException) {
        return factoryException instanceof NoSuchIdentifierException;
    }

    static void log(FactoryException factoryException, String string) {
        LogRecord logRecord = Loggings.format(Level.FINE, 8, string);
        logRecord.setSourceClassName(IdentifiedObjectSet.class.getName());
        logRecord.setSourceMethodName("createObject");
        logRecord.setThrown(factoryException);
        Logger logger = AbstractAuthorityFactory.LOGGER;
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashSet(this);
    }

    private final class Iter
    implements Iterator<T> {
        private final Iterator<Map.Entry<String, T>> iterator;
        private T element;

        public Iter(Iterator<Map.Entry<String, T>> iterator) {
            this.iterator = iterator;
            this.toNext();
        }

        private void toNext() throws BackingStoreException {
            while (this.iterator.hasNext()) {
                Map.Entry entry = this.iterator.next();
                this.element = (IdentifiedObject)entry.getValue();
                if (this.element == null) {
                    String string = entry.getKey();
                    try {
                        this.element = IdentifiedObjectSet.this.createObject(string);
                    }
                    catch (FactoryException factoryException) {
                        if (!IdentifiedObjectSet.this.isRecoverableFailure(factoryException)) {
                            throw new BackingStoreException(factoryException);
                        }
                        IdentifiedObjectSet.log(factoryException, string);
                        this.iterator.remove();
                        continue;
                    }
                    entry.setValue(this.element);
                }
                return;
            }
            this.element = null;
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public T next() throws NoSuchElementException {
            Object t = this.element;
            if (t == null) {
                throw new NoSuchElementException();
            }
            this.toNext();
            return t;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

