/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.AuthorityFactoryAdapter;
import org.geotoolkit.referencing.factory.FallbackAuthorityFactory;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.InternationalString;

public class MultiAuthoritiesFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private static final Class<? extends AuthorityFactory>[] FACTORY_TYPES = new Class[]{CRSAuthorityFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CoordinateOperationAuthorityFactory.class};
    private static final Class<? extends IdentifiedObject>[] OBJECT_TYPES = new Class[]{CoordinateReferenceSystem.class, Datum.class, CoordinateSystem.class, CoordinateOperation.class};
    private List<AuthorityFactory> factories;
    private final ThreadLocal<Boolean> inProgress = new ThreadLocal();

    public MultiAuthoritiesFactory(Collection<? extends AuthorityFactory> collection) {
        this.hints.clear();
        if (collection != null && !collection.isEmpty()) {
            for (AuthorityFactory authorityFactory : collection) {
                if (!(authorityFactory instanceof Factory)) continue;
                this.hints.putAll(((Factory)((Object)authorityFactory)).getImplementationHints());
            }
            this.factories = MultiAuthoritiesFactory.createFallbacks(collection);
        }
    }

    public List<AuthorityFactory> getFactories() {
        return this.factories;
    }

    final void setFactories(Collection<AuthorityFactory> collection) {
        assert (Thread.holdsLock(this));
        this.factories = MultiAuthoritiesFactory.createFallbacks(collection);
    }

    private static List<AuthorityFactory> createFallbacks(Collection<? extends AuthorityFactory> collection) {
        Object object;
        int n = 0;
        Citation[] citationArray = new Citation[collection.size()];
        List[] listArray = new List[citationArray.length];
        for (AuthorityFactory object22 : collection) {
            int n2;
            Object i = object22.getAuthority();
            for (n2 = 0; n2 < n; ++n2) {
                object = citationArray[n2];
                if (!Citations.identifierMatches((Citation)object, (Citation)i)) continue;
                i = object;
                break;
            }
            if (n2 == n) {
                citationArray[n++] = i;
                object = new ArrayList<AuthorityFactory>(4);
                listArray[n2] = object;
            } else {
                object = listArray[n2];
            }
            if (object.contains(object22)) continue;
            object.add(object22);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<AuthorityFactory> arrayList2 = new ArrayList<AuthorityFactory>(4);
        for (int i = 0; i < n; ++i) {
            List list = listArray[i];
            while (!list.isEmpty()) {
                object = null;
                boolean bl = false;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AuthorityFactory authorityFactory = (AuthorityFactory)iterator.next();
                    if (object == null) {
                        object = authorityFactory;
                    } else if (!FallbackAuthorityFactory.chainable(object, authorityFactory)) {
                        bl = true;
                        continue;
                    }
                    arrayList2.add(authorityFactory);
                    if (bl) continue;
                    iterator.remove();
                }
                arrayList.add(FallbackAuthorityFactory.create(arrayList2));
                arrayList2.clear();
            }
        }
        return UnmodifiableArrayList.wrap(arrayList.toArray(new AuthorityFactory[arrayList.size()]));
    }

    @Override
    final boolean sameAuthorityCodes(AuthorityFactory authorityFactory) {
        return authorityFactory == this;
    }

    protected char getSeparator(String string) {
        string = string.trim();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            if (!string.regionMatches(i, "://", 0, 3)) break;
            return '/';
        }
        return ':';
    }

    private static boolean canSeparateAt(String string, int n) {
        char c;
        int n2 = n;
        do {
            if (--n2 >= 0) continue;
            return false;
        } while (Character.isWhitespace(c = string.charAt(n2)));
        if (!Character.isJavaIdentifierPart(c)) {
            return false;
        }
        int n3 = string.length();
        n2 = n;
        do {
            if (++n2 < n3) continue;
            return false;
        } while (Character.isWhitespace(c = string.charAt(n2)));
        return Character.isJavaIdentifierPart(c);
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLKIT;
    }

    @Override
    public Citation getAuthority() {
        return ALL;
    }

    public Set<String> getAuthorityNames() {
        HashSet<String> hashSet = new HashSet<String>();
        List<AuthorityFactory> list = this.getFactories();
        if (list != null) {
            for (AuthorityFactory authorityFactory : list) {
                hashSet.add(Citations.getIdentifier(authorityFactory.getAuthority()));
            }
        }
        return hashSet;
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        return null;
    }

    @Override
    final Collection<? super AuthorityFactory> dependencies() {
        return this.getFactories();
    }

    static boolean isExcluded(AuthorityFactory authorityFactory) {
        if (authorityFactory instanceof MultiAuthoritiesFactory) {
            return true;
        }
        if (authorityFactory instanceof AuthorityFactoryAdapter) {
            AuthorityFactoryAdapter authorityFactoryAdapter = (AuthorityFactoryAdapter)authorityFactory;
            authorityFactoryAdapter.ensureInitialized();
            for (int i = 0; i < 4; ++i) {
                if (!MultiAuthoritiesFactory.isExcluded(authorityFactoryAdapter.getFactory(i))) continue;
                return true;
            }
        }
        return false;
    }

    final void fromFactoryRegistry(String string, Class<? extends AuthorityFactory> clazz, Set<AuthorityFactory> set) {
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            AuthorityFactory authorityFactory;
            if (!OBJECT_TYPES[i].isAssignableFrom(clazz)) continue;
            try {
                authorityFactory = this.fromFactoryRegistry(string, FACTORY_TYPES[i]);
            }
            catch (FactoryRegistryException factoryRegistryException) {
                continue;
            }
            if (MultiAuthoritiesFactory.isExcluded(authorityFactory)) continue;
            set.add(authorityFactory);
        }
    }

    <T extends AuthorityFactory> T fromFactoryRegistry(String string, Class<T> clazz) throws FactoryRegistryException {
        return null;
    }

    @Override
    protected <T extends AuthorityFactory> T getAuthorityFactory(Class<T> clazz, String string) throws NoSuchAuthorityCodeException {
        Object object;
        Object object2;
        MultiAuthoritiesFactory.ensureNonNull("code", string);
        String string2 = null;
        Throwable throwable = null;
        List<AuthorityFactory> list = this.getFactories();
        char c = this.getSeparator(string);
        int n = string.lastIndexOf(c);
        while (n >= 0) {
            block10: {
                if (MultiAuthoritiesFactory.canSeparateAt(string, n)) {
                    string2 = string.substring(0, n).trim();
                    if (list != null) {
                        object2 = list.iterator();
                        while (object2.hasNext()) {
                            object = (AuthorityFactory)object2.next();
                            if (!clazz.isAssignableFrom(object.getClass()) || !Citations.identifierMatches(object.getAuthority(), string2)) continue;
                            return (T)((AuthorityFactory)clazz.cast(object));
                        }
                    }
                    try {
                        object2 = this.fromFactoryRegistry(string2, clazz);
                    }
                    catch (FactoryRegistryException factoryRegistryException) {
                        throwable = factoryRegistryException;
                        break block10;
                    }
                    if (object2 != null) {
                        return (T)((AuthorityFactory)clazz.cast(object2));
                    }
                }
            }
            n = string.lastIndexOf(c, n - 1);
        }
        String string3 = null;
        if (string2 == null) {
            string2 = Vocabulary.format(278);
            string3 = Errors.format(103, string);
        } else {
            for (object2 = throwable; object2 != null; object2 = ((Throwable)object2).getCause()) {
                object = ((Throwable)object2).getLocalizedMessage();
                if (object == null) continue;
                string3 = object;
            }
            string3 = string3 != null ? Errors.format(221, string2, string3) : Errors.format(190, string2);
        }
        object2 = new NoSuchAuthorityCodeException(string3, string2, string);
        ((Throwable)object2).initCause(throwable);
        throw object2;
    }

    @Override
    protected final AuthorityFactory getAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(AuthorityFactory.class, string);
    }

    @Override
    protected final DatumAuthorityFactory getDatumAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(DatumAuthorityFactory.class, string);
    }

    @Override
    protected final CSAuthorityFactory getCSAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CSAuthorityFactory.class, string);
    }

    @Override
    protected final CRSAuthorityFactory getCRSAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CRSAuthorityFactory.class, string);
    }

    @Override
    protected final CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        if (Boolean.TRUE.equals(this.inProgress.get())) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        HashSet<AuthorityFactory> hashSet = new HashSet<AuthorityFactory>();
        hashSet.add(this);
        this.inProgress.set(Boolean.TRUE);
        try {
            for (String string : this.getAuthorityNames()) {
                string = string.trim();
                char c = this.getSeparator(string);
                StringBuilder stringBuilder = new StringBuilder(string);
                int n = stringBuilder.length();
                if (n != 0 && stringBuilder.charAt(n - 1) != c) {
                    stringBuilder.append(c);
                    n = stringBuilder.length();
                }
                stringBuilder.append("all");
                String string2 = stringBuilder.toString();
                block8: for (int i = 0; i < FACTORY_TYPES.length; ++i) {
                    AuthorityFactory authorityFactory;
                    if (!OBJECT_TYPES[i].isAssignableFrom(clazz)) continue;
                    Class<? extends AuthorityFactory> clazz2 = FACTORY_TYPES[i];
                    try {
                        authorityFactory = this.getAuthorityFactory(clazz2, string2);
                    }
                    catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                        continue;
                    }
                    if (!hashSet.add(authorityFactory)) continue;
                    AuthorityFactory authorityFactory2 = authorityFactory;
                    while (authorityFactory2 instanceof AuthorityFactoryAdapter) {
                        AuthorityFactoryAdapter authorityFactoryAdapter = (AuthorityFactoryAdapter)authorityFactory2;
                        try {
                            authorityFactory2 = authorityFactoryAdapter.getAuthorityFactory(clazz2, string2);
                        }
                        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                            continue block8;
                        }
                        if (hashSet.add(authorityFactory2)) continue;
                        continue block8;
                    }
                    for (String string3 : authorityFactory.getAuthorityCodes(clazz)) {
                        if ((string3 = string3.trim()).length() < n || Character.isLetterOrDigit(string3.charAt(n - 1)) || !string.equalsIgnoreCase(string3.substring(0, n - 1))) {
                            stringBuilder.setLength(n);
                            stringBuilder.append(string3);
                            string3 = stringBuilder.toString();
                        }
                        linkedHashSet.add(string3);
                    }
                }
            }
        }
        finally {
            this.inProgress.remove();
        }
        return linkedHashSet;
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        HashSet<AuthorityFactory> hashSet = new HashSet<AuthorityFactory>();
        hashSet.add(this);
        FactoryException factoryException = null;
        for (int i = 0; i < FACTORY_TYPES.length; ++i) {
            AuthorityFactory authorityFactory;
            try {
                authorityFactory = this.getAuthorityFactory(FACTORY_TYPES[i], string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                if (factoryException != null) continue;
                factoryException = noSuchAuthorityCodeException;
                continue;
            }
            if (!hashSet.add(authorityFactory)) continue;
            try {
                return authorityFactory.getDescriptionText(string);
            }
            catch (FactoryException factoryException2) {
                if (factoryException != null && !(factoryException.getCause() instanceof FactoryRegistryException)) continue;
                factoryException = factoryException2;
            }
        }
        if (factoryException == null) {
            factoryException = this.noSuchAuthorityCode(IdentifiedObject.class, string);
        }
        throw factoryException;
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        HashSet<AuthorityFactory> hashSet = new HashSet<AuthorityFactory>();
        hashSet.add(this);
        FactoryException factoryException = null;
        for (int i = 0; i < FACTORY_TYPES.length; ++i) {
            AuthorityFactory authorityFactory;
            try {
                authorityFactory = this.getAuthorityFactory(FACTORY_TYPES[i], string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                if (factoryException != null) continue;
                factoryException = noSuchAuthorityCodeException;
                continue;
            }
            if (!hashSet.add(authorityFactory)) continue;
            try {
                return authorityFactory.createObject(string);
            }
            catch (FactoryException factoryException2) {
                if (factoryException != null && !(factoryException.getCause() instanceof FactoryRegistryException)) continue;
                factoryException = factoryException2;
            }
        }
        if (factoryException == null) {
            factoryException = this.noSuchAuthorityCode(IdentifiedObject.class, string);
        }
        throw factoryException;
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(this, clazz);
    }

    static class Finder
    extends IdentifiedObjectFinder {
        protected Finder(MultiAuthoritiesFactory multiAuthoritiesFactory, Class<? extends IdentifiedObject> clazz) {
            super(multiAuthoritiesFactory, clazz);
        }

        final Class<? extends AuthorityFactory> getFactoryType() {
            Class<? extends IdentifiedObject> clazz = this.proxy.getObjectType();
            for (int i = 0; i < OBJECT_TYPES.length; ++i) {
                if (!OBJECT_TYPES[i].isAssignableFrom(clazz)) continue;
                return FACTORY_TYPES[i];
            }
            throw new IllegalStateException(Errors.format(198, clazz));
        }

        final Collection<AuthorityFactory> getFactories() {
            return ((MultiAuthoritiesFactory)this.proxy.getAuthorityFactory()).getFactories();
        }

        final IdentifiedObjectFinder next(Iterator<AuthorityFactory> iterator) throws FactoryException {
            while (iterator.hasNext()) {
                AbstractAuthorityFactory abstractAuthorityFactory;
                IdentifiedObjectFinder identifiedObjectFinder;
                AuthorityFactory authorityFactory = iterator.next();
                if (MultiAuthoritiesFactory.isExcluded(authorityFactory) || !(authorityFactory instanceof AbstractAuthorityFactory) || (identifiedObjectFinder = (abstractAuthorityFactory = (AbstractAuthorityFactory)authorityFactory).getIdentifiedObjectFinder(this.proxy.getObjectType())) == null) continue;
                identifiedObjectFinder.setFullScanAllowed(this.isFullScanAllowed());
                return identifiedObjectFinder;
            }
            return null;
        }

        @Override
        public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObject identifiedObject2;
            block2: {
                IdentifiedObjectFinder identifiedObjectFinder;
                identifiedObject2 = this.createFromIdentifiers(identifiedObject);
                if (identifiedObject2 != null) {
                    return identifiedObject2;
                }
                Collection<AuthorityFactory> collection = this.getFactories();
                if (collection == null) break block2;
                Iterator<AuthorityFactory> iterator = collection.iterator();
                while ((identifiedObjectFinder = this.next(iterator)) != null && (identifiedObject2 = identifiedObjectFinder.find(identifiedObject)) == null) {
                }
            }
            return identifiedObject2;
        }

        @Override
        public String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
            Iterator<Object> iterator;
            Set<ReferenceIdentifier> set;
            Object object;
            IdentifiedObject identifiedObject2 = this.createFromIdentifiers(identifiedObject);
            if (identifiedObject2 != null) {
                object = null;
                set = identifiedObject2.getIdentifiers();
                if (set != null) {
                    iterator = set.iterator();
                    while (iterator.hasNext() && (object = (ReferenceIdentifier)iterator.next()) == null) {
                    }
                }
                if (object == null) {
                    object = identifiedObject2.getName();
                }
                if (object != null) {
                    return object.toString();
                }
            }
            if ((object = this.getFactories()) != null) {
                iterator = object.iterator();
                while ((set = this.next(iterator)) != null) {
                    String string = ((IdentifiedObjectFinder)((Object)set)).findIdentifier(identifiedObject);
                    if (string == null) continue;
                    return string;
                }
            }
            return null;
        }
    }
}

