/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.factory.ThreadedAuthorityFactory;
import org.geotoolkit.util.logging.Logging;

final class StoreDisposer
extends Thread {
    static final StoreDisposer INSTANCE = new StoreDisposer();
    private final DelayQueue<Ref> queue = new DelayQueue();

    private StoreDisposer() {
        super("BackingStores disposer");
        this.setPriority(6);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        DelayQueue<Ref> delayQueue;
        while ((delayQueue = this.queue) != null) {
            long l;
            Ref ref;
            try {
                ref = (Ref)delayQueue.take();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            ThreadedAuthorityFactory threadedAuthorityFactory = (ThreadedAuthorityFactory)ref.get();
            if (threadedAuthorityFactory == null || (l = threadedAuthorityFactory.disposeExpired()) == Long.MIN_VALUE) continue;
            delayQueue.add(new Ref(threadedAuthorityFactory, l));
        }
        Logging.getLogger(StoreDisposer.class).severe("Daemon stopped.");
    }

    final void schedule(ThreadedAuthorityFactory threadedAuthorityFactory, long l) {
        assert (Thread.holdsLock(threadedAuthorityFactory));
        this.queue.add(new Ref(threadedAuthorityFactory, l));
    }

    final long getDelay() {
        Object object = this.queue.peek();
        if (object == null) {
            return 0L;
        }
        return object.getDelay(TimeUnit.MILLISECONDS);
    }

    final void cancel(ThreadedAuthorityFactory threadedAuthorityFactory) {
        assert (Thread.holdsLock(threadedAuthorityFactory));
        Iterator<Ref> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            ThreadedAuthorityFactory threadedAuthorityFactory2 = (ThreadedAuthorityFactory)iterator.next().get();
            if (threadedAuthorityFactory2 != null && threadedAuthorityFactory2 != threadedAuthorityFactory) continue;
            iterator.remove();
        }
    }

    @Override
    public String toString() {
        return "Next in " + this.getDelay() + " ms.";
    }

    static {
        INSTANCE.start();
    }

    private static final class Ref
    extends WeakReference<ThreadedAuthorityFactory>
    implements Delayed {
        private final long schedule;

        Ref(ThreadedAuthorityFactory threadedAuthorityFactory, long l) {
            super(threadedAuthorityFactory);
            this.schedule = l;
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.schedule - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            return XMath.sgn(this.schedule - ((Ref)delayed).schedule);
        }
    }
}

