/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.wkt.ReferencingParser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.io.wkt.WKTFormat;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.factory.BackingStoreException;
import org.geotoolkit.referencing.factory.DirectAuthorityFactory;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.collection.DerivedSet;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.ScopedName;

public class WKTParsingAuthorityFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory {
    private Citation authority;
    private final Citation[] authorities;
    final Map<String, String> definitions;
    private final Set<String> codes;
    private transient Map<Class<? extends IdentifiedObject>, Set<String>> filteredCodes;
    private transient Parser parser;

    /*
     * WARNING - void declaration
     */
    public WKTParsingAuthorityFactory(Hints hints, Map<String, String> map, Citation ... citationArray) {
        super(hints);
        void var4_9;
        Boolean bl;
        Boolean bl2;
        WKTParsingAuthorityFactory.ensureNonNull("authorities", citationArray);
        WKTParsingAuthorityFactory.ensureNonNull("definitions", map);
        if (citationArray.length == 0) {
            throw new IllegalArgumentException(Errors.format(49));
        }
        this.authorities = (Citation[])citationArray.clone();
        this.definitions = map;
        for (Citation citation : this.authorities) {
            WKTParsingAuthorityFactory.ensureNonNull("authority", citation);
        }
        this.codes = Collections.unmodifiableSet(map.keySet());
        Boolean bl3 = Boolean.FALSE;
        if (hints != null && (bl2 = (Boolean)hints.get(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER)) == null && (bl = (Boolean)hints.get(Hints.FORCE_STANDARD_AXIS_DIRECTIONS)) == null) {
            Boolean bl4 = Boolean.FALSE;
        }
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, var4_9);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, var4_9);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
    }

    @Override
    public ConformanceResult availability() {
        return new Factory.Availability(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean pass() {
                WKTParsingAuthorityFactory wKTParsingAuthorityFactory = WKTParsingAuthorityFactory.this;
                synchronized (wKTParsingAuthorityFactory) {
                    return super.pass() && !WKTParsingAuthorityFactory.this.definitions.isEmpty();
                }
            }
        };
    }

    final Citation authority() {
        return this.authorities[0];
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            switch (this.authorities.length) {
                case 0: {
                    this.authority = Citations.EPSG;
                    break;
                }
                case 1: {
                    this.authority = this.authorities[0];
                    break;
                }
                default: {
                    DefaultCitation defaultCitation = new DefaultCitation(this.authorities[0]);
                    Collection<Identifier> collection = defaultCitation.getIdentifiers();
                    for (int i = 1; i < this.authorities.length; ++i) {
                        collection.addAll(this.authorities[i].getIdentifiers());
                    }
                    defaultCitation.freeze();
                    this.authority = defaultCitation;
                    break;
                }
            }
        }
        return this.authority;
    }

    @Override
    public synchronized Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        Codes codes;
        if (clazz == null || clazz.isAssignableFrom(IdentifiedObject.class)) {
            return this.codes;
        }
        if (this.filteredCodes == null) {
            this.filteredCodes = new HashMap<Class<? extends IdentifiedObject>, Set<String>>();
        }
        if ((codes = this.filteredCodes.get(clazz)) == null) {
            codes = new Codes(this.definitions, clazz);
            this.filteredCodes.put(clazz, codes);
        }
        return codes;
    }

    private String getWKT(Class<?> clazz, String string) throws FactoryException {
        String string2;
        assert (Thread.holdsLock(this));
        WKTParsingAuthorityFactory.ensureNonNull("code", string);
        String string3 = this.trimAuthority(string);
        try {
            string2 = this.definitions.get(string3);
        }
        catch (BackingStoreException backingStoreException) {
            throw backingStoreException.unwrap();
        }
        if (string2 == null) {
            throw this.noSuchAuthorityCode(clazz, string);
        }
        return string2.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternationalString getDescriptionText(String string) throws NoSuchAuthorityCodeException, FactoryException {
        int n;
        String string2;
        WKTParsingAuthorityFactory wKTParsingAuthorityFactory = this;
        synchronized (wKTParsingAuthorityFactory) {
            string2 = this.getWKT(IdentifiedObject.class, string);
        }
        int n2 = string2.indexOf(34);
        if (n2 >= 0 && (n = string2.indexOf(34, ++n2)) >= 0) {
            return new SimpleInternationalString(string2.substring(n2, n).trim());
        }
        return null;
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.parser = new Parser();
            this.parser.setAxisIgnored(Boolean.TRUE.equals(this.hints.get(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER)));
        }
        return this.parser;
    }

    @Override
    public synchronized IdentifiedObject createObject(String string) throws NoSuchAuthorityCodeException, FactoryException {
        String string2 = this.getWKT(IdentifiedObject.class, string);
        Parser parser = this.getParser();
        try {
            parser.code = string;
            return (IdentifiedObject)parser.parseObject(string2);
        }
        catch (ParseException parseException) {
            throw new FactoryException(parseException);
        }
    }

    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        String string2 = this.getWKT(CoordinateReferenceSystem.class, string);
        Parser parser = this.getParser();
        try {
            parser.code = string;
            return parser.parseCoordinateReferenceSystem(string2);
        }
        catch (ParseException parseException) {
            throw new FactoryException(parseException);
        }
    }

    @Override
    protected String trimAuthority(String string) {
        GenericName genericName = this.nameFactory.parseGenericName(null, string = string.trim());
        if (genericName instanceof ScopedName) {
            GenericName genericName2 = ((ScopedName)genericName).path();
            String string2 = ((Object)genericName2).toString();
            for (int i = 0; i < this.authorities.length; ++i) {
                if (!Citations.identifierMatches(this.authorities[i], string2)) continue;
                return ((Object)genericName.tip()).toString().trim();
            }
        }
        return string;
    }

    @Override
    public synchronized IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        Parser parser = this.getParser();
        if (!parser.isAxisIgnored()) {
            return super.getIdentifiedObjectFinder(clazz);
        }
        return new Finder(clazz);
    }

    private static final class Codes
    extends DerivedSet<String, String> {
        private static final long serialVersionUID = 2681905294171687900L;
        private final Class<? extends IdentifiedObject> type;
        private final Map<String, String> definitions;

        public Codes(Map<String, String> map, Class<? extends IdentifiedObject> clazz) {
            super(map.keySet(), String.class);
            this.definitions = map;
            this.type = clazz;
        }

        @Override
        protected String baseToDerived(String string) {
            int n;
            String string2 = this.definitions.get(string);
            int n2 = string2.length();
            for (n = 0; n < n2 && Character.isJavaIdentifierPart(string2.charAt(n)); ++n) {
            }
            Class<Object> clazz = WKTFormat.getClassOf(string2.substring(0, n));
            if (clazz == null) {
                clazz = IdentifiedObject.class;
            }
            return this.type.isAssignableFrom(clazz) ? string : null;
        }

        @Override
        protected String derivedToBase(String string) {
            return string;
        }
    }

    private final class Finder
    extends IdentifiedObjectFinder {
        Finder(Class<? extends IdentifiedObject> clazz) {
            super(WKTParsingAuthorityFactory.this, clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final IdentifiedObject create(String string, int n) throws FactoryException {
            switch (n) {
                case 0: {
                    return super.create(string, n);
                }
                case 1: {
                    WKTParsingAuthorityFactory wKTParsingAuthorityFactory = WKTParsingAuthorityFactory.this;
                    synchronized (wKTParsingAuthorityFactory) {
                        IdentifiedObject identifiedObject;
                        Parser parser = WKTParsingAuthorityFactory.this.getParser();
                        assert (parser.isAxisIgnored());
                        try {
                            parser.setAxisIgnored(false);
                            identifiedObject = super.create(string, 0);
                        }
                        catch (Throwable throwable) {
                            parser.setAxisIgnored(true);
                            throw throwable;
                        }
                        parser.setAxisIgnored(true);
                        return identifiedObject;
                    }
                }
            }
            return null;
        }
    }

    private final class Parser
    extends ReferencingParser {
        private static final long serialVersionUID = -5910561042299146066L;
        String code;

        public Parser() {
            super(Symbols.DEFAULT, WKTParsingAuthorityFactory.this.factories);
        }

        @Override
        protected Map<String, Object> alterProperties(Map<String, Object> map) {
            Object object = map.get("identifiers");
            if (object == null && this.code != null) {
                NamedIdentifier[] namedIdentifierArray;
                map = new HashMap<String, Object>(map);
                this.code = WKTParsingAuthorityFactory.this.trimAuthority(this.code);
                if (WKTParsingAuthorityFactory.this.authorities.length == 1) {
                    namedIdentifierArray = new NamedIdentifier(WKTParsingAuthorityFactory.this.authorities[0], this.code);
                } else {
                    NamedIdentifier[] namedIdentifierArray2 = new NamedIdentifier[WKTParsingAuthorityFactory.this.authorities.length];
                    for (int i = 0; i < namedIdentifierArray2.length; ++i) {
                        namedIdentifierArray2[i] = new NamedIdentifier(WKTParsingAuthorityFactory.this.authorities[i], this.code);
                    }
                    namedIdentifierArray = namedIdentifierArray2;
                }
                map.put("identifiers", namedIdentifierArray);
            }
            return super.alterProperties(map);
        }
    }
}

